% all dialog varconst
% P. Nedoma 2005

% === system ==============================================
vs1 = varconst('number of components',    'ncom', 'positive integer');
vs2 = varconst('number of channels',      'nchn', 'positive interger');
vs3 = varconst('covariance diagonal',     'diac', 'positive');
vs4 = varconst('output noise covariance', 'covy', 'positive');
vs5 = varconst('input noise covariance',  'covu', 'positive');
vs6 = varconst('transition table diag.|0','diam',  {'>=',0,'<=',1});
vs7 = varconst('alpha',                   'alpha', {'>', 0,'<',1});    
vs8 = varconst('noise covariance', 'cove', 'positive');              
vs9 = varconst('order (2 or 4)', 'ord', ...
     {'one of',{2,4}});

% section1=secconst('System',{....});

% === measurements ========================================
vm1 = varconst('length',                  'ndat','positive integer');
vm2 = varconst('seed (0 for no) ',        'seed');
vm3 = varconst('scaling (1|0)',           'scale', {'one of',{1,0}} );

%section2=secconst('Measurements',{...});

% === initialization ============================================
vi1 = varconst('number if iterations',    'niter',  'positive integer');
vi2 = varconst('prior No. of components', 'ncomi',  'positive integer');
vi3 = varconst('number of iterations',    'niter',  'positive integer');
vi3a= varconst('model order',             'ordi',   'positive integer');
vi4 = varconst('order of initial factor', 'ord',    'positive integer');
vi5 = varconst('....estimation in initialization....');
vi6 = varconst('number of iterations',    'niteri', 'positive integer');
vi7 = varconst('options (n, | q | f) ', 'opt' , ...
      {'one of',{'n','p','q','f'}});

%section3=secconst('Initialization',{  });

% === estimation ==========================================
ve1 = varconst('alternative forgetting rate', 'frga',  {'>=',0.5,'<=', 0.9});
ve2 = varconst('forgetting rate',             'frg',   {'>=',0.5,'<=', 1});
%section3=secconst('Estimation',{  });

% === mixcelaneous ========================================
vx1 = varconst('difference in v-log-likelihood', 'ro');
vx2 = varconst('gain range',              'gain');
vx3 = varconst('richest model order',     'ord',    'positive integer');
vx4 = varconst('diag. of covariance',     'diaCth', 'positive');
vx5 =  varconst('degree of freedom',      'dfm' ,   'positive integer');
vx6 =  varconst('system',                 'sys', ...
       {'one of', { 1 2 3 4 5 } }) ;
vx7 = varconst('    sys=2      -> 2nd order');
vx8 = varconst('    sys=3      -> 2nd order');
vx9 = varconst('    sys=4|5|62 -> 4nd order');
vx10 = varconst('gain range', 'gain');
vx11 = varconst('number of segments',      'n',  'positive integer');



%dia = diaconst('MODEL CHARACTERISTICS VIA EXTENDED SIMULATION',...
%       {section1,section2,section3});

%dialog;

return

% ########################################################

% ==========================================================
diabase;
section1=secconst('System',{vs2,vs1,vs3});
section2=secconst('Measurements',{vm1,vm2,vm3});
section3=secconst('Initialization',{vi2, vi3,   vi5,vi7, vi6});
dia = diaconst('COMPUTATIONAL EFFICIENCY OF STATIC MIXTURE INITIALIZATION',...      
      {section1,section2,section3});
dialog;
% ===========================================================


% ==========================================================
diabase;
section1=secconst('System',{vs1,vs3});
section2=secconst('Measurements',{vm1,vm2,vs6});
dia = diaconst(...
'DATA USED IN CASE STUDIES (STATIC MICTURES, 2 DIMENSIONS', ...
      {section1,section2});
dialog;
% ===========================================================





