% estcmpdyn.m
% case study: COMPARISON OF MIXTURE ESTIMATION ALGORITHMS: DYNAMIC CASE
%
% Design : P. Nedoma
% Updated: January 2001, MK October 2004 
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%

prodini
echo off
idef = [];


while 1 % ==============================================
if isempty(idef)
ndat = 1000;                         % sample size     
covy = 0.39463^2;   
covu = 0.16;
frg  = 1;                            % forgetting rate
frga = 0.61;
seed = 123;                          % seed of random generator
niter= 10;                           % No. of iterations
alpha = 0.3; 
end

% ==========================================================
diabase;
section1=secconst('System',{vs4,vs5,vs7});
section2=secconst('Measurements',{vm1,vm2});
section3=secconst('Estimation',{vi1, ve1, ve2});
dia = diaconst(...
'COMPARISON OF MIXTURE ESTIMATION ALGORITHMS: DYNAMIC CASE',...
      {section1,section2,section3});
dialog;
% ===========================================================


if seed, randn('seed', seed); end
TIME0=min(ndat,300);
ychn = 1;                              % output channel
uchn = 2;                              % input  channel

str = [1 1 1 1 2 2;  1 2 3 4 3 4];     % common structure
Fac = facarxls(ychn, str);             % model of output channel

% 1st dynamic system
Eth1     = [1.41833  -1.5894  1.3161  -0.88642  0.2826  0.50666];
Fac.Eth  = Eth1;
Fac.cove = covy;                       % variance of output noise
Facs{1}  = Fac;

% 2nd dynamic system
Eth2 = [2.0968  -2.3196  1.9335  -0.8713  0.641  0.1041];
Fac.Eth  = Eth2;
Fac.cove = covy;                       % variance of output noise
Facs{2}  = Fac;

% input channel - noise
Fac = facarxls(uchn,[]);               % model of input channel for simulation
Fac.cove = covu;                       % variance of output noise
Facs{3}  = Fac;
Facs{4}  = Fac;

% mixture simulator
dfcs0 = [alpha, (1-alpha)];            % degree of freedom of components
Sim   = mixconst(Facs, [1 3; 2 4], dfcs0); % mixture simulator

% get data sample
DATA = zeros(2, ndat);                 % pre-allocated DATA
mixsimul(Sim, ndat);                   % build data sample

TIME = TIME0;
sub = 330; 
LegendSize = 11;

n = floor(ndat/9);
for i=n:n:6*n
  sub = sub + 1; subplot(sub);
  [x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
  TIME = i;
  if i==n, H=legend('simulator',['time ',int2str(TIME)],0);
           xlabel('chn1'), ylabel('chn2'); 
           title('pdf(chn1,chn2)');
  else     H=legend(['time ',int2str(TIME)],0);
  end
  set(H, 'fontSize', LegendSize); grid on
  drawnow

end



Fac  = facarx(ychn, str);             % model of output channel
Facu = facarx(uchn, [0;1]);

Facs = {Fac, Fac, Facu, Facu};
dfcs0 =[alpha, (1-alpha)];
Mix0  = mixconst(Facs, [1 3; 2 4], dfcs0);




method = 'q';                          % quasi-Bayes estimation
Mix    = mixest(Mix0, frg, ndat, niter, method); % estimation
Mix    = mixstats(Mix,ndat);
vll    = Mix.states.mixll;
err    = relep(Mix, ndat, 1);

method = 'b';                          % batch quasi-Bayes
Mix = mixest(Mix0, frg, ndat, niter, method); % estimation
Mix = mixstats(Mix,ndat);
vll = [vll, Mix.states.mixll];
err = [err, relep(Mix, ndat, 1)];

method = 'f';                          % forgetting branching
Mix = mixest(Mix0, frga, ndat, niter, method); % estimation
Mix = mixstats(Mix,ndat);
vll = [vll, Mix.states.mixll];
err = [err, relep(Mix, ndat, 1)];

sub  = sub + 1; subplot(sub);
plot(1,vll(1), 'o');  hold on; grid on
plot(2,vll(2), 'd'); 
plot(3,vll(3), '*');
plot(vll,':');
ax = axis; ax(1)=0.5; ax(2)=4.5;
axis(ax);
title('v-log-likelihood');
drawnow

H=legend('QB','BQB', 'BFRG',0); 
set(H, 'fontSize', LegendSize); grid on


sub=sub+1;
sub  = sub + 1; subplot(sub);
plot(1,err(1,1), 'o');  hold on
plot(2,err(1,2), 'd'); 
plot(3,err(1,3), '*')
plot(err(1,:),':');
ax = axis; ax(1)=0.5; ax(2)=4.5;
axis(ax);
title('prediction-errors norm');

H=legend('QB','BQB', 'BFRG',0); 
set(H, 'fontSize', LegendSize); grid on

axis(ax);

%setaxis([333:335]);
plt('estcmpdyn_');
dial2
end % ====================================
