% initdyn.m
% DYNAMIC MIXTURE INITIALIZATION
%
% Designed : P. Nedoma
% Updated  : November 2002, MK October, 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

prodini
echo off
idef = [];

relerr=[];

while 1 % ==============================================
if isempty(idef)
ndat  = 300;                          % sample size       
cove  = 0.16;
frg   = 1;                            % forgetting rate
frga  = 0.6;
seed  = 4;                            % No. of iterations
alpha = 0.5; 
ord   = 5;                            % order
opt   = 'n'; 
niteri = 10;
niter  = 5;
end

% ==========================================================
diabase;
section1=secconst('System',{vs8});
section2=secconst('Measurements',{vm1,vm2});
section3=secconst('Initialization',{vx3, vi3,  vi5, vi7, vi6});
dia = diaconst(...
'DYNAMIC MIXTURE INITIALIZATION',...   
      {section1,section2,section3});
dialog;
% ===========================================================


if opt(1)=='n', OPT = [];
else
   OPT = [opt,'n',int2str(niteri)]; 
end


TIME0=ndat;
ychn = 1;                              % output channel
uchn = 2;                              % input  channel

str = [1 1 1 1 2 2;  1 2 3 4 3 4];     % common structure
Fac = facarxls(ychn, str);             % model of output channel

% 1st dynamic system
Eth1     = [1.41833  -1.5894  1.3161  -0.88642  0.2826  0.50666];
Fac.Eth  = Eth1;
Fac.cove = 0.39463^2;                  % variance of output noise
Facs{1}  = Fac;

% 2nd dynamic system
Eth2 = [2.0968  -2.3196  1.9335  -0.8713  0.641  0.1041];
Fac.Eth  = Eth2;
Fac.cove = 0.37255^2;                  % variance of output noise
Facs{2}  = Fac;

% input channel - noise
Fac = facarxls(uchn,[]);               % model of input channel for simulation
Fac.cove = cove;                       % variance of output noise
Facs{3}  = Fac;
Facs{4}  = Fac;

% mixture simulator
dfcs0 = [alpha, (1-alpha)];            % degree of freedom of components
Sim   = mixconst(Facs, [1 3; 2 4], dfcs0); % mixture simulator

% get data sample
if seed, randn('seed', seed); end

DATA = zeros(2, ndat+10);                 % pre-allocated DATA
mixsimul(Sim, ndat+10);                   % build data sample
DATA = DATA(:,10:end);                    % because of 'p', zeros must be eliminated

TIME = TIME0;
sub = 220; 
LegendSize = 11;
clf


if 0
sub = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
H=legend(['Simulator, time ',int2str(TIME0)],0);
xlabel('chn1'); ylabel('chn2'); title('pdf(chn1,chn2)');
set(H, 'fontSize', LegendSize); grid on 
drawnow, figure(1)
end


if 0
sub = sub + 1; subplot(sub);
plot(DATA(2,:));  grid on
H=legend('input',0);
xlabel('time'); ylabel('value, chn2'); 
set(H, 'fontSize', LegendSize); grid on 
drawnow, figure(1)
end


sub = sub + 1; subplot(sub);
plot(DATA(1,:));  grid on
H=legend('output trajectory',0);
xlabel('time'); ylabel('value, chn2'); 
set(H, 'fontSize', LegendSize); grid on 
drawnow, figure(1)


% mixture initialization
% richest mixture
maxstr   = [ [ones(1,ord), 1+ones(1,ord), 0]; [ [1:ord], [1:ord] 1] ];
Mix0     = genmixe(1,[ychn uchn], maxstr);

disp('initialization is running ...');

FRG = frg;
if ~isempty(opt)
   i = find(opt=='f');
   if ~isempty(i), FRG = frga; end
end

Mix   = mixinit(Mix0, FRG, ndat, niter, OPT); % mixture initialization


[se, yp] = relep(Mix, ndat, 1);

disp(' ===================================');
fprintf('No. of components = %i\n', length(Mix.dfcs));
prt('Prediction-errors norm', se);
disp(' ===================================');


% setting TIME
TIME = ndat;
maxtd = Mix.states.maxtd;
dd   = DATA(1, maxtd+1:ndat);
sub = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
xlabel('chn1'); ylabel('chn2'); title('pdf(chn1,chn2)');
H=legend(['Initialized time ',int2str(TIME0)],...
         [' no of components ', int2str(length(Mix.dfcs))], 0);
set(H, 'fontSize', LegendSize); grid on
drawnow

sub = sub + 1; subplot(sub);
ep  = dd - yp(1,:);
hist(ep,20); grid on
H=legend('prediction error',[' norm=', num2str(ep(1))],0);
set(H, 'fontSize', LegendSize); grid on
drawnow

sub = sub + 1; subplot(sub);
plot(yp(1,:), dd,'.','MarkerSize',3); grid on
H=legend('prediction x data',0);
xlabel('channel 1'); ylabel('prediction'); 
set(H, 'fontSize', LegendSize); grid on
drawnow

plt('initdyn_');

dial2
end % ====================================
