% inititer.m
% case study: SCANNING OF STATIC MIXTURE INITIALIZATION
%
% Design : P. Nedoma
% Updated: November 2002, MK October 2004
% Project: GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%          MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

prodini
echo off
idef = [];


results = [];

while 1 % ==============================================
if isempty(idef)

nchn = 4;                            % number of channels     
ncom = 5;                            % component covariance
diac = 0.1;                          % diagonal of covar. matrix

ndat = 1000;                         % sample size 
seed = 6;                            % seed of random generator

niter = 3;                            % No. of iterations
ncomi = 1;
frg   = 1;                            % forgetting rate
frga  = 0.6;  
niteri = 10;

ncomi = 1;
opt   = 'n';
end

% ==========================================================
diabase;
section1=secconst('System',{vs2,vs1,vs3});
section2=secconst('Measurements',{vm1,vm2});
section3=secconst('Initialization',{vi2, vi3,   vi5,vi7, vi6});
dia = diaconst(...
'SCANNING OF STATIC MIXTURE INITIALIZATION', ...
     {section1,section2,section3});
dialog;
% ===========================================================

if opt(1)=='n', OPT = [];
else
   OPT = [opt,'n',int2str(niteri)]; 
end

DATA  = zeros(nchn, ndat);           % data sample
str   = [0; 1];                      % static factor structure
ychns = 1:nchn;                      % modelled channels in component
Com   = comarxls(ychns, str);        % build matrix ARX LS component
Com.cove = ltdl( diac*eye(nchn) + 0.05*diac*rand(nchn, nchn) ); % noise variance

Eth   = zeros(1,nchn);               % regression coefficients

if seed, randn('seed', seed); end

Coms=[];
for com = 1:ncom                     % generate array of components
    Com.Eth   = Eth';
    Coms{com} = Com;
    Eth = Eth + ones(1,nchn) + randn(1,nchn);
end



Sim   = mixconst(Coms,ncom:-1:1);   % mixture simulator
mixsimul(Sim, ndat);                % simulate mixture

% ----------------------------------------------------------
sub  = 230;
LegendSize=11;


PLOTNO=2; PLOTSUB=230;
clf; figure(1);
sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
xlabel('chn1'); ylabel('chn2');
title('pdf(chn1,chn2)');
H=legend('Simulator',0); 
set(H, 'fontSize', LegendSize); grid on
drawnow
% ----------------------------------------------------------

Mix0 = genmixe(ncomi);
disp('initialization in progress ...');

FRG = frg;
if ~isempty(opt)
   i = find(opt=='f');
   if ~isempty(i), FRG = frga; end
   i = find(opt=='p');
   if ~isempty(i), 
       FRG = 1; warning('projection needs no forgetting');  
   end
end

tic
DEBUG=1;
Mix   = mixinit(Mix0, FRG, ndat, niter, OPT); % mixture initialization
t = toc;

pchns = 1;
pMix = mix2pro(Mix, pchns);
[se, er] = relep(pMix,ndat,1);

% ----------------------------------------------------------
Mix0= mixflat(Mix);
Mix = mixestqb(Mix0, 1, ndat, 30);
sub=230+PLOTNO-1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('Initialized',0);
set(H, 'fontSize', LegendSize); grid on
drawnow

lin = sprintf('nchn=%i  ncom=%i  ndat=%i opt=%s  -> ncom=%i relerr=%g time= %g', ...
     nchn, ncom, ndat, opt,  length(Mix.dfcs), se, t);
line = blanks(80);
line(1:length(lin)) = lin;
results = [results;line];
disp('RESULTS');
disp(results);

% ----------------------------------------------------------
plt('inititer_');
dial2;
end % ====================================