% zdata1.m
% case study: DATA USED IN CASE STUDIES (STATIC MIXTURES, 2 DIMENSIONS)
%
% Design : P. Nedoma
% Updated: November 2002, MK October 2004
% Project: GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%          MINERVA 110330-CP-1-2003-1-ES-MINERVA-M


prodini
echo off
idef = [];

while 1 % ==============================================
if isempty(idef)
ncom  = 4;     
diac  = 0.1;       
diam  = 0.5;
ndat  = 500;                              
seed  = 0;            
end

% ==========================================================
diabase;
section1=secconst('System',{vs1,vs3});
section2=secconst('Measurements',{vm1,vm2,vs6});
dia = diaconst(...
'DATA USED IN CASE STUDIES (STATIC MICTURES, 2 DIMENSIONS', ...
      {section1,section2});
dialog;
% ===========================================================

cove = ltdl([diac 0.1*diac; 0.1*diac diac]);     % noise covariance

if seed, randn('seed', seed); rand('seed',seed); end

maxtd  = 0;
DATA=zeros(2, ndat);
if diam==0
   clear CUMTAB ACTIVE
   Sim=statsim(ndat, ncom, cove);
else
   CUMTAB = gentab(ncom, diam);
   Sim  = statsim(0, ncom, cove);   
   actives = zeros(1,ndat);
   for TIME=maxtd+1:ndat
       Sim=mixsimul(Sim);
       actives(TIME)=ACTIVE;
   end
end


sub = 220; 
LegendSize = 11;
clf

sub = sub + 1; subplot(sub);
[x,y,xy] = mixgrid(Sim); contour(x,y,xy,20);
xlabel('chn1'); ylabel('chn2'); title('pdf(chn1,chn2)');
H = legend('Simulator');
set(H, 'fontSize', LegendSize); grid on
drawnow

sub = sub + 1; subplot(sub);
plot(DATA(1,:),DATA(2,:),'.');
xlabel('channel 1'); ylabel('channel 2'); 
H = legend('Data clusters');
set(H, 'fontSize', LegendSize); grid on
drawnow

if diam~=0
subplot(212);
plot(actives);
xlabel('time'); ylabel('active');
H = legend('active component');
set(H, 'fontSize', LegendSize); grid on
%ax=axis;  ax(3)=0; ax(4)=3; axis(ax);
drawnow
end

figure(1);
dial2
end % ====================================
