% Case study: ACADEMIC DESIGN WITH MARKOV CHAIN MIXTURES
% Rem: Two-valued data (1,2), mixture of coins with memory
%
% Designed : LT, JaK
% Updated  : MK, October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

echo off; 
clear all; 
close all; 
rand('seed', 123);
clc; 

global TIME DATA;

F{1}      = facmark1(1,[1; 1],[2]);
F{2}      = facmark1(1,[1; 1],[2]);
F{1}.dfm  = 1;
F{2}.dfm  = 1;
Fu{1}     = facmark1(1,[1; 1],[2]);
Fu{1}.dfm = 1;  

idef = [];
while isempty(idef) | idef ~= 's' % ============================================
close all;
% initial values
if isempty(idef),
    % model parameters
    th1   = [0.85 0.05];                      % prob. of y=1, component 1
    th2   = [0.1 0.9];                        % prob. of y=1, component 2
    alpha = 0.2;                              % weight of the first component
    Uth   = [0.05 0.05];                      % prob. of y=1, user ideal pdf
    Ufc= 0.5;                              % user ideal pdf of the pointer to the first component
    nhor = 10;                                % time horizon length
    data  = 1;                                % starting DATA
    ndat  = 50;                               % number of simulated data
end


clc
while 1;
fprintf('\n ACADEMIC DESIGN FOR MARKOV CHAIN MIXTURES\n');
fprintf('===========================================\n');
fprintf('\n--- System ------------------------------------------------\n');
fprintf('probabilities of y(t)=1 for        y(t-1)=1  y(t-1)=2\n');   
fprintf('component 1:           ->  th1   = '); displ(th1, '\n');
fprintf('component 2:           ->  th2   = '); displ(th2, '\n');
fprintf('weight of component 1  ->  alpha = '); displ(alpha, '\n');  
fprintf('\n--- User''s ideal pdf --------------------------------------\n');
fprintf('probabilities of y(t)=1 for        y(t-1)=1  y(t-1)=2\n');   
fprintf('                       ->  Uth   = '); displ(Uth, '\n');
fprintf('weight of component 1  ->  Ufc   = '); displ(Ufc, '\n');  
fprintf('\n--- Design ---------------------------------------------------\n');
fprintf('design horizon         ->  nhor  = '); displ(nhor, '\n');  
fprintf('length of simulation   ->  ndat  = '); displ(ndat, '\n');
dial1
[t1,th1]   = test01(th1, 'th1',1,2);
[t2,th2]   = test01(th2, 'th2',1,2);
[t3,alpha] = test01(alpha, 'alpha',1,1);
[t4,Uth]   = test01(Uth, 'Uth',1,2);
[t5,Ufc]= test01(Ufc, 'Ufc',1,1);
t6 = (nhor>0)& ~(nhor - floor(nhor));
t7 = (ndat> 0)& ~(ndat  - floor(ndat));
if t1&t2&t3&t4&t5&t6&t7;
   break;
end;
fprintf('\n\nEnter valid inputs:\n');
end;

% model pdf
F{1}.trt = [th1; 1-th1];         
F{2}.trt = [th2; 1-th2];         
Mix=markmixc(F,[1; 2],[1 1]);
Mix.dfcs = [alpha 1-alpha];

% user ideal pdf
Fu{1}.trt = [Uth; 1-Uth];
Mixu = markmixc(Fu,[1],[1]);

% simulation loop with original weights of components
TIME = size(data,2);
DATA = data(1,:);
marksim(Mix, ndat);
dorig = DATA;
figure(1);
sp1 = subplot(3,1,1);
axis([1, ndat + size(data, 2), 0.9, 2.1]);
set(figure(1), 'Position', [400 50 400 500], 'MenuBar', 'none')
set(sp1, 'Position', [0.15 0.73 0.75 0.20], ...
    'YTick', [1; 2]);
title('Unguided system');
xlabel('time');
ylabel('output');
hold on;
plot(dorig,'*');

% simulation loop with optimized weights of components
% initial TIME and DATA
TIME = size(data,2);
DATA = data(1,:);
% mixture for simulaiton
Mixo = Mix;
sp2 = subplot(3,1,2);
axis([1, ndat + size(data, 2), 0.9, 2.1]);
set(sp2, 'Position', [0.15 0.40 0.75 0.20], ...
    'YTick', [1; 2]);
title('Guided system');
xlabel('time');
ylabel('output');
hold on;
for t = 1:ndat,
    % optimization of a control strategy
    ocw = mdesaca(Mix, Mixu, [Ufc, 1-Ufc], nhor);
    Mixo.dfcs = ocw;
    marksim(Mixo,1);
    plot(DATA,'r*');
    pause(0.001);
end
dopt = DATA;

sp3 = subplot(3,1,3);
axis([1, ndat + size(data, 2), 0.9, 2.1]);
set(sp3, 'Position', [0.15 0.08 0.75 0.20], ...
    'YTick', [1; 2]);
title('Time evolution of mean value of output');
xlabel('time');
ylabel('mean output');
hold on;
plot(cumsum(dorig)./(1:length(dorig)), 'b');
plot(cumsum(dopt)./(1:length(dopt)), 'r');
% desired transition table
Mixup = mst2par(Mixu);
dt = Mixup.Facs{1}.trt;
[eve, eva] = eig(dt);
% stationary distribution
st = eve(:, find(abs(sum(eva) - 1) <= eps))';
st = st./sum(st);
plot(st*[1; 2]*ones(size(dorig)), 'g:');
legend('unguided system', 'guided system', 'mean of user ideal pdf' );


TIME = 1;
DATA = [1 2];
ocw1 = mdesaca(Mix, Mixu, [Ufc, 1-Ufc], nhor);
TIME = 2;
ocw2 = mdesaca(Mix, Mixu, [Ufc, 1-Ufc], nhor);

fprintf('--- optimal advising strategy ----------------------------------------\n');
fprintf('probabilities of pointers to components for a given previous output\n');
fprintf('         y(t-1)=1  y(t-1)=2\n');
fprintf('   c=1   '); displ([ocw1(1) ocw2(1)], '\n');
fprintf('   c=2   '); displ([ocw1(2) ocw2(2)], '\n');
fprintf('----------------------------------------------------------------------\n');

% projection of the optimal stratey to data
dproj(:,1) = [Mix.Facs{1}.trt(:,1) Mix.Facs{2}.trt(:,1)] * ocw1';
dproj(:,2) = [Mix.Facs{1}.trt(:,2) Mix.Facs{2}.trt(:,2)] * ocw2';
     
fprintf('\n--- projection on user data ------------------------------------------\n');
fprintf('probabilities of a current output for a given previous output\n');
fprintf('         y(t-1)=1  y(t-1)=2\n');
fprintf('y(t)=1   '); displ(dproj(1,:), '\n');
fprintf('y(t)=2   '); displ(dproj(2,:), '\n');
fprintf('----------------------------------------------------------------------\n');
 
dial2
end % ==========================================================
