% TESTING OF HYPOTHESES ABOUT FIXED PARAMETER VALUES
% Remark: Two-valued data (1,2), static model without control
%
% Design   : I. Nagy
% Updated  : July 2004, MK October 2004 
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre

prodini, echo off
idef=[];
while 1 % ============================================

% definitions and initial values
if isempty(idef)
  ndat = 10;                           % number of data records
  th = [.2 .5 .7];                     % hypotheses
end
th1=.2;                                 % true value

clc

fprintf('\n TESTING OF HYPOTHESES ABOUT FIXED PARAMETER VALUES');
fprintf('\n        th=th(1) or th=th(2) or th=th(3)           ');
fprintf('\n ==================================================\n');
%fprintf('\n Input variables\n');
fprintf('\n--- System --------------------------------\n');
fprintf(' Number of data records           ->   ndat  = %i;\n',  ndat);
fprintf(' Parameters defining  hypotheses  ->   th    = \n');   
fprintf('                             H1   ->   th(1) = %g \n',th(1))
fprintf('                             H2   ->   th(2) = %g \n',th(2))
fprintf('                             H3   ->   th(3) = %g \n',th(3))
fprintf(' evaluate hypotheses                         \n');
fprintf(' for true parameter value         ->   th1   = %g;\n',th1);

fprintf('-------------------------------------------\n');

dial1

% errors
while 1;
hlp=[''];
[t1,th1]  = test01(th1,'th1',1,1);
[t2,th]   = test01(th,'th', 1,3);
[t3,ndat] = testint(ndat,'ndat', 1,1); 
if t1&t2&t3;
   break
end;

fprintf('\n\n');
fprintf('\n\nEnter valid inputs:\n');

if ~t1,th1 = input(' th1 = '); end
if ~t2,th  = input(' th = '); end
if ~t3,ndat= input(' ndat = '); end
    
end

% computed variables
f1=[]; f2=[]; f3=[];

% **************************************************************

% simulation + statistics
ii=0:.05:1;
for a=ii
  S(1)=a*ndat;
  S(2)=ndat-S(1);
  
  % hypothesis
  nH(1)=th(1)^S(1)*(1-th(1))^S(2);
  nH(2)=th(2)^S(1)*(1-th(2))^S(2);
  nH(3)=th(3)^S(1)*(1-th(3))^S(2);
  fH=[nH(1) nH(2) nH(3)]/(nH(1)+nH(2)+nH(3));
  f1=[f1 fH(1)];
  f2=[f2 fH(2)];
  f3=[f3 fH(3)];
  if a==th1 
    th01=fH(1);
    th02=fH(2);
    th03=fH(3);
  end

end

% plotting of the parameters value
th1S=['H1: th1 =' num2str(th(1))];
th2S=['H2: th2 =' num2str(th(2))];
th3S=['H3: th3 =' num2str(th(3))];
tit=['Test of hypotheses - prior parameter value th1=' num2str(th1)];

% graphic conclusions
%set(figure(1),'Position',[300 100 600 600])%,'MenuBar','none')
% resizefig(60,20,20);
figure(1)
subplot(2,1,2)
plot(ii,f1,'ro-','markersize',3)
hold on
plot(ii,f2,'bo-','markersize',3)
plot(ii,f3,'go-','markersize',3)
hold off
title('Test of hypotheses - all values of true parameter value th1',...
  'FontWeight','bold')
xlabel('relative frequency of y=1','HorizontalAlignment','left');
ylabel('probabilities of the hypothesis');
legend('1st hypothesis','2nd hypothesis','3rd hypothesis',-1)

subplot(2,1,1)
plot(th1,th01,'ro')
hold on
plot(th1,th02,'bo')
plot(th1,th03,'go')
hold off
title(tit,'FontWeight','bold')
axis([0 1 0 1])
xlabel('relative frequency of y=1','HorizontalAlignment','left');
ylabel('probabilities of the hypothesis');
legend('1st hypothesis','2nd hypothesis','3rd hypothesis',' ','Note:',th1S,th2S,th3S,-1),

% **************************************************************

dial2
end % ==========================================================
