% MULTI-STEP PREDICTION FOR CCM MODEL WITH KNOWN PARAMETERS
% Rem: Two-valued data (1,2), controlled coin model with memory 
%      (evolution of the prediction in dependence on prediction length)
%
% designed : IN
% updated  : MK October, 2004
% projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

prodini, echo off
idef=[];
while 1 % ============================================

% definitions and initial values
if isempty(idef)
  nstep=20;                            % length of prediction 
  th1=[.1; .93];                       % prob. of 1 for y=1 and y=2 for u=1
  th2=[.8; .5];                        % prob. of 1 for y=1 and y=2 for u=2
end

clc
while 1;
fprintf('\n MULTI-STEP PREDICTION FOR CCM MODEL WITH KNOWN PARAMETERS');
fprintf('\n =========================================================\n');
%fprintf('\n Input variables\n');
fprintf('\n--- System --------------------------------\n');
fprintf('prediction horizon                               ->         nstep  = %i;\n',  nstep);
fprintf('parameters for regression vector y=1 and 2, u=1  ->  column th1    = %g %g;\n',th1);
fprintf('parameters for regression vector y=1 and 2, u=2  ->  column th2    = %g %g;\n',th2);
fprintf('-------------------------------------------\n');

dial1

% errors
hlp=[''];
[t1,th1]  = test01(th1, 'th1',2,1);
[t2,th2]  = test01(th2, 'th2',2,1);
[t3,nstep]= testint(nstep,  'nstep',1,1);
if t1&t2&t3;
   break;
end;
    
fprintf('\n\nEnter valid inputs for %s:\n',hlp);
if ~t1, th1=input(' th1 = '); end
if ~t2, th2=input(' th2 = '); end
if ~t3, nstep=input(' nstep = '); end
end

% computed variables
th{1}=[th1 1-th1];                     % model parameters
th{2}=[th2 1-th2];                     % model parameters
y=[1; 2];                              % all values of y
yy=[]; ti=eye(size(th));

% **************************************************************
y=[1; 2];                              % possible values of y
u=round(rand(1,nstep))+1;              % generator of u
yy=[]; ti=eye(length(y));
for i=1:nstep                          % nstep-step prediction
  ti=ti*th{u(i)};                      % trans. matrix for prediction
  yp=ti*y;                             % predictions
  yy=[yy yp];
end

% plotting of the predictions
resizefig(60,20,20); 
subplot(211),plot(yy(1,:))
axis([1,nstep,1,2])
title('Predicted output in dependence on prediction length','FontWeight'...
    ,'bold')
xlabel('number of prediction steps','HorizontalAlignment','left');
ylabel('prediction');
legend('prediction','for y0=1',-1);

subplot(212),plot(yy(2,:))
axis([1,nstep,1,2])
xlabel('number of steps of prediction','HorizontalAlignment','left');
ylabel('prediction');
legend('prediction','for y0=2',-1);

% **************************************************************

dial2
end % ==========================================================
