prodini
echo off

idef = [];
while 1 % ==============================================
if isempty(idef)

% system definition; two channels, three components
Eth11 =[1.81 -0.8189 0 0 0.00438 0.00468  0];
Eth12 =[1.81 -0.8189 0.00438 0.00468 0 0 0];
Eth13 =[2.1040    -1.1067 0 0.00468 0.00438 0 0];

str1 =[ 1     1     2     2     2   2   0;
        1     2     0     1     2   3  1];
str2 =[ 2   1   1    0;
        1   1   2    1];
 Eth21=[0 0 0 0];
 Eth22=[-.33 -94  81 0];
 Eth23=[0 0 0 0];
 
fac11=facarxls(1,str1);
fac12=facarxls(1,str1);
fac13=facarxls(1,str1);

fac21=facarxls(2,str2);
fac22=facarxls(2,str2);
fac23=facarxls(2,str2);

fac11.Eth=Eth11;
fac11.cove=.1;
fac12.Eth= Eth12;
fac12.cove=1;
fac13.Eth= Eth13;
fac13.cove=.1;

fac21.Eth=Eth21;
fac21.cove=.1;
fac22.Eth= Eth22;
fac22.cove=.1;
fac23.Eth= Eth23;
fac23.cove=.1;


%required mixture Mix0
coms0 =[     1     2];
 str0=[0;1];
 fac01=facarxls(1,str0);
 fac02=facarxls(2,str0);
 fac01.cove=1;             % penal y
 fac02.cove= 10;          % penal u
 fac01.Eth=-5;
 fac02.Eth=-5;
 dfcs0=1;
  hor=500 ;% [1 50];
% ufc = ufcgen(aMix, aMixu)
ufc=[1 1 1];
dfcs=[10 10 10];

end
clc
Eth11=fac11.Eth;cove11=fac11.cove;
Eth21=fac21.Eth;cove21=fac21.cove;
Eth12=fac12.Eth;cove12=fac12.cove;
Eth22=fac22.Eth;cove22=fac22.cove;
Eth13=fac13.Eth;cove13=fac13.cove;
Eth23=fac23.Eth;cove23=fac23.cove;
Uth1=fac01.Eth;Ucov1=fac01.cove;
Uth2=fac02.Eth;Ucov2=fac02.cove;
alpha=dfcs/sum(dfcs);

while 1
fprintf('\n INDUSTRIAL DESIGN WITH DYNAMIC MIXTURE \n');
fprintf('= = = = = = = = = = = = = = = = = = = = =\n');
%fprintf('\nCase study setup: \n');
fprintf('--- Simulated system (mixture of three components) ---\n');
fprintf('component 1   factor 1   ->   Eth11= ');
fprintf('%g  ',fac11.Eth);
fprintf(';\n');
fprintf('component 1   factor 1   ->  cove11= %g;\n',    fac11.cove);
fprintf('component 1   factor 2   ->   Eth21= ');
fprintf('%g  ',fac21.Eth);
fprintf(';\n');
fprintf('component 1   factor 2   ->  cove21= %g;\n',    fac21.cove);
fprintf('component 2   factor 1   ->   Eth12= ');
fprintf('%g  ',fac12.Eth);
fprintf(';\n');
fprintf('component 2   factor 1   ->  cove12= %g;\n',    fac12.cove);
fprintf('component 2   factor 2   ->   Eth22= ');
fprintf('%g  ',fac22.Eth);
fprintf(';\n');
fprintf('component 2   factor 2   ->  cove22= %g;\n',    fac22.cove);
fprintf('component 3   factor 1   ->   Eth13= ');
fprintf('%g  ',fac13.Eth);
fprintf(';\n');
fprintf('component 3   factor 1   ->  cove13= %g;\n',    fac13.cove);
fprintf('component 3   factor 2   ->   Eth23= ');
fprintf('%g  ',fac23.Eth);
fprintf(';\n');
fprintf('component 3   factor 2   ->  cove23= %g;\n',    fac23.cove);
fprintf('---------- True user''s ideal ------------------------\n');
fprintf('component 1   factor 1   ->   Uth1= ');
fprintf('%g  ',fac01.Eth);
fprintf(';\n');
fprintf('component 1   factor 1   ->  Ucov1= %g;\n',    fac01.cove);
fprintf('component 1   factor 2   ->   Uth2= ');
fprintf('%g  ',fac02.Eth);
fprintf(';\n');
fprintf('component 1   factor 2   ->  Ucov2= %g;\n',    fac02.cove);
fprintf('--- Parameters of the optimization--------------------\n');
fprintf('optimization horizon  -> hor= %i;\n');
fprintf('%g  ',hor);
fprintf(';\n');
fprintf('                         -> alpha= ');
fprintf('%g  ',alpha);
fprintf(';\n');

dial1;
[t1,cove11]  = test_double(cove11, 'cove11',1,1,0,Inf);
[t2,cove12]  = test_double(cove12, 'cove12',1,1,0,Inf);
[t3,cove13]  = test_double(cove13, 'cove13',1,1,0,Inf);
[t4,cove21]  = test_double(cove21, 'cove21',1,1,0,Inf);
[t5,cove22]  = test_double(cove22, 'cove22',1,1,0,Inf);
[t6,cove23]  = test_double(cove23, 'cove23',1,1,0,Inf);
[t7,Ucov1]  = test_double(Ucov1, 'Ucov1',1,1,0,Inf);
[t8,Ucov2]  = test_double(Ucov2, 'Ucov2',1,1,0,Inf);
[t9,alpha]  = test_double(alpha,'alpha',1,3,0,Inf);
if t1&t2&t3&t4&t5&t6&t7&t8&t9;
   break;
end;
fprintf('\n\nEnter valid inputs:\n');
end;

fac11.Eth =Eth11;fac11.cove =cove11;
fac21.Eth =Eth21;fac21.cove =cove21;
fac12.Eth =Eth12;fac12.cove =cove12;
fac22.Eth =Eth22;fac22.cove =cove22;
fac13.Eth =Eth13;fac13.cove =cove13;
fac23.Eth =Eth23;fac23.cove =cove23;
fac01.Eth =Uth1;fac01.cove =Ucov1;
fac02.Eth =Uth2;fac02.cove =Ucov2;
dfcs=alpha;

Facs={fac11 fac12 fac13 fac21 fac22 fac23};
coms=[1 4;2 5;3 6];
[Mix, maxtd]= mixconst(Facs,coms,dfcs);

 Fac0={fac01 fac02};
 [Mixu, maxtdu]= mixconst(Fac0,coms0,dfcs0);
Mix.states.uchns=2;
ndat=1000;
echo off
DATA=zeros(3,ndat);
table=[.8 .1 .1;.1 .8 .1; .1 .1 .8];
Mix=setsim(Mix,{'table',table});
To=1;
Mix.states.uchn=2;
randn('seed',19);
rand('seed',29);
for TIME=4:ndat,
%  mixsimul(Mix);
Mix= mixsimul(Mix);
DATA(3,TIME)=ACTIVE;
end

figure(1)
resizefig(50,0,40);
subplot(3,1,1)
plot(DATA(1,:));
title('Original system data')
%legend('orig. output')
ylabel('output')
axoriy=axis;
subplot(3,1,2);
plot(DATA(2,:));
axoriu=axis;
%legend('orig. input')
ylabel('input')
subplot(3,1,3);
plot(DATA(3,:));
legend('component used')
ylabel('component No.')
xlabel('time')
axis([0 1000 0 4])
drawnow
covd1or=cov(DATA(1,:));
covd2or=cov(DATA(2,:));
meand1or=mean(DATA(1,:));

To=1;
Sim=Mix;
Sim.states.uchn=2;
ACTIVE=1;
DATAORI=DATA;
DATA=zeros(3,ndat);
 uchan=[2];
 [aMix,aMixu] =inisyn(Mix,Mixu,[1 2],uchan);
echo off
aMix= uoptim(aMix,aMixu,ufc,hor);

algr=zeros(1,ndat);

randn('seed',19);
rand('seed',29);
aMix=setsim(aMix);
for TIME=5:ndat,
aMix=setsim(aMix,{'table',table});
aMix= mixsimul(aMix);

DATA(3,TIME)=ACTIVE;
end

figure(2)
resizefig(50,50,40);
subplot(3,1,1)
plot(DATA(1,:));
title('Data after optimization');
ylabel('output')
axis(axoriy);
subplot(3,1,2);
plot(DATA(2,:));
axis(axoriu);
ylabel('iput')
%legend('Optim. Channel 2')
subplot(3,1,3);
plot(DATA(3,:));
legend('component used')
xlabel('time')
ylabel('component No.')
axis([0 1000 0 4])
drawnow
covd1=cov(DATA(1,:));
covd2=cov(DATA(2,:));
meand1=mean(DATA(1,:));

disp('original data covariance')
covd1or,covd2or,meand1or
disp('optimized data covariance')
covd1,covd2,meand1
dial2
%
end
