% banan.m
% STATIC MIXTURE INITIALIZATION: ``BANANA SHAPE" BENCHMARK
%
% Design : P. Nedoma
% Updated: January 2001, MK October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

prodini

clc
echo off
idef = [];

while 1 % ====================================================

if isempty(idef)
ncom = 30;   
diac  = 0.5;

ndat  = 1500;
seed  = 12345;

ncomi = 10;
niter = 3;
frg   = 1;
niteri = 10;
opt   = 'P';

seed  = 12345;
end

clc

% === dialog ==============================================
diabase;
section1=secconst('System',{vs1, vs3});
section2=secconst('Measurements',{vm1,vm2});
section3=secconst('Initialization',{vi1,vi2});
dia = diaconst('STATIC MIXTURE INITIALIZATION: ``BANANA SHAPE"',...
    {section1,section2,section3});
dialog;
% =========================================================

if seed, randn('seed', seed); end


LegendSize=12;

ychn     = [1  2];                     % modelled channel
str      = [0; 1];                     % factor structure
Com      = comarxls(ychn, str);        % build matrix ARX LS component
Com.cove = diac*eye(2);                % point estimate  of noise variance


% build upper half circle
NCOM = ncom/2;
r1   = 10;

dfi  = pi/NCOM;
fi   = 0;
for com = 1:NCOM+1
    y = r1 * sin(fi);
    x = r1 * cos(fi);
    Com.Eth = [x;y];
    Coms{com} = Com;
    fi = fi + dfi;
end

% build lower half circle
r2   = 5;
k = com + 1;
fi   = 0;
for com = 1:NCOM+1
    y = r2 * sin(fi) - 1;
    x = r2 * cos(fi);
    Com.Eth = [x;y];
    Coms{k} = Com;
    k       = k + 1;
    fi      = fi + dfi;
end

NCOM = length(Coms);
Sim = mixconst(Coms, ones(1,NCOM));    % mixture simulator


DATA = zeros(2,ndat);                  % data sample
mixsimul(Sim, ndat);                   % simulate mixture

clf
sub = 220;
sub = sub+1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15);
H=legend('Simulator',0); 
set(H, 'fontSize', LegendSize); grid on
xlabel('chn1'); ylabel('chn2'); title('pdf(chn1, chn2)');
drawnow; figure(1);

sub = sub+1; subplot(sub);
%plot(DATA(1,:),DATA(2,:),'.');
datascan;
xlabel('channel 1'); ylabel('channel 2'); 


                             % display data clusters
H=legend('Data clusters',0); 
set(H, 'fontSize', LegendSize); grid on
drawnow

Mix0  = genmixe(ncomi);              % more must be specified
fprintf('\n\n\n\n\n\n initialization in progress ... it will take some time\n');

Mix   = mixinit(Mix0, frg, ndat, niter); % mixture initialization

sub = sub+1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15);
H=legend('Initialized mixture',0); 
set(H, 'fontSize', LegendSize); grid on
drawnow


mixsimul(Mix, ndat);
sub = sub+1; subplot(sub);
datascan;
H   = legend('Simulated data',0); 
set(H, 'fontSize', LegendSize); grid on
drawnow
plt('banan_')

setaxis([221, 223])
figure(1);
dial2
end % ===========================================================
