% benchest.m
% case study: EFFICIENCY OF MIXTURE ESTIMATION ALGORITHMS
%
% Design : P. Nedoma
% Updated: January 2001, MK October 2004 
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%

prodini
echo off
idef = [];


while 1 % ==============================================
if isempty(idef)
ndat = 1000;                         % sample size 
nchn = 4;                            % number of channels     
ncom = 5;                            % component covariance
frg  = 1;                            % forgetting rate
diac = 0.1;                          % diagonal of covar. matrix
frga = 0.61;  
seed = 123;                          % seed of random generator
niter= 10;                           % No. of iterations
end

clc
% =====================================================================
diabase
section1=secconst('System',{vs2,vs1,vs3});
section2=secconst('Measurements',{vm1, vm2});
section3=secconst('Estimation',{vi3,ve2,ve1});
dia = diaconst('EFFICIENCY OF MIXTURE ESTIMATION ALGORITHMS',...
      {section1,section2,section3});
dialog;
% ======================================================================


if seed, randn('seed', seed); end
DATA  = zeros(nchn, ndat);           % data sample
str   = [0; 1];                      % static factor structure
ychns = 1:nchn;                      % modelled channels in component
Com   = comarxls(ychns, str);        % build matrix ARX LS component
Com.cove = ltdl( diac*eye(nchn) + 0.05*rand(nchn, nchn) ); % noise variance

Eth   = zeros(1,nchn);               % regression coefficients

Coms = [];
for com = 1:ncom                     % generate array of components
    Com.Eth   = Eth';
    Coms{com} = Com;
    Eth = Eth + ones(1,nchn) + randn(1,nchn);
end



Sim   = mixconst(Coms,ncom:-1:1);   % mixture simulator
tic
mixsimul(Sim, ndat);                % simulate mixture
ts=toc;
% ----------------------------------------------------------
sub  = 230;
LegendSize=10;

clf; figure(1);
sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
H=legend('simulator',0); 
xlabel('chn1'); ylabel('chn2');
title('pdf(chn1,chn2)');
set(H, 'fontSize', LegendSize); grid on
drawnow

Mix0 = genmixe(ncom);

method = 'q';                          % quai-Bayes estimation
tic
Mix = mixest(Mix0, frg, ndat, niter, method); % estimation
tq  = toc;
Mix = mixstats(Mix,ndat);
vll = Mix.states.mixll;
err = relep(Mix, ndat,1);

sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('QB',0); 
set(H, 'fontSize', LegendSize); grid on
drawnow

method = 'b';                          % batch quasi-Bayes
tic
Mix = mixest(Mix0, frg, ndat, niter, method); % estimation
tb = toc;
Mix = mixstats(Mix,ndat);
vll = [vll, Mix.states.mixll];
err    = [err, relep(Mix, ndat, 1)];

sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('BQB',0); 
set(H, 'fontSize', LegendSize); grid on
drawnow

method = 'f';                          % forgetting branching
tic
Mix = mixest(Mix0, frga, ndat, niter, method); % estimation
tf = toc;
err = [err, relep(Mix, ndat, 1)];
Mix = mixstats(Mix,ndat);
vll = [vll, Mix.states.mixll];

sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('BFRG',0); 
set(H, 'fontSize', LegendSize); grid on
drawnow

sub  = sub + 1; subplot(sub);
plot(1,vll(1), 'o');  hold on
plot(2,vll(2), 'd'); 
plot(3,vll(3), '*');

plot(vll,':');
ax = axis; ax(1)=0.5; ax(2)=3.5;
axis(ax);
title('v-log-likelihood')
xlabel('method');
H=legend('QB','BQB', 'BFRG',0); 
set(H, 'fontSize', LegendSize); grid on
drawnow

sub  = sub + 1; subplot(sub);
plot(1,err(1,1), 'o');  hold on
plot(2,err(1,2), 'd'); 
plot(3,err(1,3), '*')

plot(err(1,:),':');
ax = axis; ax(1)=0.5; ax(2)=3.5;
axis(ax);
title('Prediction-errors norm');
xlabel('method');
H=legend('QB','BQB', 'BFRG',0); 
set(H, 'fontSize', LegendSize); grid on


figure(1);
plt('benchest_');
dial2;
end % ====================================