% benchinit.m
% case study: COMPUTATIONAL EFFICIENCY OF STATIC MIXTURE INITIALIZATION
%
% Design : P. Nedoma
% Updated: January 2001, MK October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%

prodini
echo off
idef = [];



results = [];

while 1 % ==============================================
if isempty(idef)

nchn = 4;                            % number of channels
ncom = 6;                            % component covariance
diac = 0.1;                          % diagonal of covar. matrix

ndat = 1000;                         % sample size
seed = 123;                          % seed of random generator

niter = 3;                           % No. of iterations
ncomi = 1; frg   = 1;                % forgetting rate
frga  = 0.61;
niteri = 10;

ncomi = 1;
opt   = 'n';

nitere = 20;
scale = 1;
end

% ==========================================================
diabase;
section1=secconst('System',{vs2,vs1,vs3});
section2=secconst('Measurements',{vm1,vm2,vm3});
section3=secconst('Initialization',{vi2, vi3,   vi5,vi7, vi6});
dia = diaconst('COMPUTATIONAL EFFICIENCY OF STATIC MIXTURE INITIALIZATION',...      
      {section1,section2,section3});
dialog;
% ===========================================================


if opt(1)=='n', OPT = [];
else
   OPT = [opt,'n',int2str(niteri)];
end

DATA  = zeros(nchn, ndat);           % data sample
str   = [0; 1];                      % static factor structure
ychns = 1:nchn;                      % modelled channels in component
Com   = comarxls(ychns, str);        % build matrix ARX LS component
Com.cove = ltdl( diac*eye(nchn) + 0.05*rand(nchn, nchn) ); % noise variance

Eth   = zeros(1,nchn);               % regression coefficients

if seed, randn('seed', seed); end

Coms=[];
for com = 1:ncom                     % generate array of components
    Com.Eth   = Eth';
    Coms{com} = Com;
    Eth = Eth + ones(1,nchn) + randn(1,nchn);
end



Sim   = mixconst(Coms,ncom:-1:1);   % mixture simulator
mixsimul(Sim, ndat);                % simulate mixture

% ----------------------------------------------------------


if scale
   Pre=preproc({'scale',[]});
else
   Pre=[];
end

sub  = 220;
LegendSize=12;

clf; figure(1);
sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
H=legend('Simulator',0);
xlabel('chn1'); ylabel('chn 2'); title('pdf(chn1,chn2)');
set(H, 'fontSize', LegendSize); grid on
drawnow

sub  = sub + 1; subplot(sub);
plot(DATA(1,:),DATA(2,:),'.','MarkerSize',3);
grid on
H=legend('Scaled clusters',0);
set(H, 'fontSize', LegendSize); grid on
drawnow



% ----------------------------------------------------------

Mix0 = genmixe(ncomi);
disp('initialization in progress ...');

FRG = frg;
if ~isempty(opt)
   i = find(opt=='f');
   if ~isempty(i), FRG = frga; end
   i = find(opt=='p');
   if ~isempty(i),
       FRG = 1; warning('projection needs no forgetting');
   end

end

tic
Mix   = mixinit(Mix0, FRG, ndat, niter, OPT); % mixture initialization
t = toc;

pchns = 1;
pMix  = mix2pro(Mix, pchns);
[se, er] = relep(Mix, ndat, 1);

% ----------------------------------------------------------
sub = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('Initialized',0);
set(H, 'fontSize', LegendSize); grid on
drawnow



pMix = mixpro(Mix,[],[],[],Pre);
sub = sub + 1; subplot(sub);
[x,y,z] = mixgrid(pMix); contour(x,y,z,15); grid on
H=legend('re-scaled',0);
set(H, 'fontSize', LegendSize); grid on
drawnow

%setaxis([221,224]);
%setaxis([222,223]);

plt('benchinit_')
% ----------------------------------------------------------
dial2;
end % ====================================
