% bquasi.m
% case study: MIXTURE ESTIMATION BASED ON BATCH QUASI-BAYES ALGORITHM (BQB)
%
% Design : P. Nedoma
% Updated: January 2001, MK October 2004 
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%
prodini
idef = [];

echo off
clc
while 1 % ==============================================
if isempty(idef)
ndat = 300;                        % size of data sample
seed = 98;
diac = 0.1;
diam = 0.95;
frg  = 1;
niter = 10;                            % number of iterations
end


% =========================================================
diabase;
section1=secconst('System',{vs3,vs6});
section2=secconst('Measurements',{vm1,vm2});
section3=secconst('Estimation',{vi1,ve2});
dia = diaconst('MIXTURE ESTIMATION BASED ON BATCH QUASI-BAYES ALGORITHM (BQB)', ...     
      {section1,section2,section3});
dialog;
% ==========================================================

if seed, randn('seed', seed); end

LegendSize = 11;

DATA = zeros(2,ndat);                  % pre-allocated data

Com      = comarxls([1 2], [0;1]);     % ARX LS component
Com.cove = ltdl([diac diac*0.1; diac*0.1 diac]); % component noise covariance

Com.Eth  = [-1; 0];                    % 1st component mean
Coms{1}  = Com;                        % array of components

Com.Eth  = [1; 0];                     % 2nd component mean
Coms{2}  = Com;

Sim      = mixconst(Coms, [1 1]);      % mixture simulator

global CUMTAB ACTIVE                   % requirement on Markov component jumps
CUMTAB   = [diam 1-diam; 1-diam diam]; % Markov transition probability
actives=[];

for TIME=1:ndat                        % iterative estimation
    Sim = mixsimul(Sim);                     % get data sample
    actives(TIME)=ACTIVE;              % save active component
echo off
end



sub  = 230;
clf
sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
title('pdf(chn1, chn2)')
xlabel('chn1'); ylabel('chn2'); 
H=legend('simulator',0); 
set(H, 'fontSize', LegendSize); grid on

sub = sub + 1; subplot(sub);
datascan;
H=legend('data clusters',0); 
xlabel('chn1'); ylabel('chn2'); 
set(H, 'fontSize', LegendSize); grid on
drawnow

sub = sub + 1; subplot(sub);
plot(0,0);
plot(actives);                         % plot active components
H=legend('active', 'components',1); 
set(H, 'fontSize', LegendSize); grid on
ax=axis; ax(3)=0; ax(4)=3; axis(ax);
xlabel('time'); ylabel('active'); 
grid on; drawnow

Mix0  = genmixe(2);                    % initial mixture, 2 static components
Mix   = mixest(Mix0, frg, ndat, niter, 'b'); % batch quasi Bayes estimation
Mix   = mixstats(Mix, ndat);           % estimation statistics
vll1  = Mix.states.mixll               % v-log-ikelihood

sub = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('BQB',0);
set(H, 'fontSize', LegendSize); grid on
drawnow

Mix   = mixest(Mix0, frg, ndat, niter, 'q'); % quasi Bayes estimation
Mix   = mixstats(Mix, ndat);                 % estimation statistics
vll2  = Mix.states.mixll

sub = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H = legend('QB',0);

sub = sub + 1; subplot(sub);
plot(1,[vll1], 'o'); hold on
plot(2,[vll2], '*');
plot([vll1 vll2], ':'); grid on
ax=axis; ax(1)=0.5; ax(2)=2.5; axis(ax);
H=legend('BQB','OB',0);
title('v-log-likelihood');
set(H, 'fontSize', LegendSize); 
%xlabel('method 1:BQB 2:QB'); 

setaxis([231,234,235])

figure(1);
plt('bquasi_');
dial2;
end % ==============================
