% brafor.m
% case study: MIXTURE ESTIMATION BASED ON BRANCHING BY FORGETTING ALGORITHM (BFRG)
%
% Design : P. Nedoma
% Updated: January 2001, MK October 2004 
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%

prodini
echo off
idef = [];

while 1 % ==============================================

if isempty(idef)
ndat = 300;                            % size of data sample
ncom = 3;
seed = 98;
diac = 0.1;
frga = 0.8;
ro   = 3;
end



% ========================================================
diabase
section1=secconst('System',{vs1, vs3});
section2=secconst('Measurements',{vm1,vm2});
section3=secconst('Estimation',{ve1, vx1});
dia = diaconst(...
'MIXTURE ESTIMATION BASED ON THE BRANCHING BY FORGETTING ALGORITHM (BFRG)',...      
      {section1,section2,section3});
dialog
% =========================================================


DATA = zeros(2,ndat);                  % pre-allocated data


cove = ltdl([diac, 0.1*diac; 0.1*diac, diac]);   % component noise covariance
randn('seed', seed);
Sim  = statsim(ndat, ncom, cove);          % get data sample

clf


Mix = genmixe(ncom);
Mix = mix2mix(Mix, 21);
Mix0 = Mix;
flag = 1;
wgs = zeros(1,ndat);


for TIME=1:ndat                        % iterative estimation
    if flag 
       Mix1 = Mix;
       Mix2 = Mix; 
       MixA = Mix;
       vll1 = 0;
       vll2 = 0;
       flag = 0;
     end

    Mix1 = mixestim(Mix1, 1);
    vll1 = vll1 + Mix1.states.mixll;

    Mix2 = mixestim(Mix2, frga);
    vll2 = vll2 + Mix2.states.mixll;

% reduced forgetting with alternative
   for fac   = Mix2.states.facs
       Fac   = Mix2.Facs{fac};         % factor from Mix
       Fac0  = MixA.Facs{fac};         % factor from alternative MixA
       Fac.dfm        = Fac.dfm     + (1-frga)*Fac0.dfm;
       Fac.LD(1,1)    = Fac.LD(1,1) + (1-frga)*Fac0.LD(1,1);
       Mix2.Facs{fac} = Fac;           % in C in-place
   end
   Mix2.dfcs = Mix2.dfcs + (1-frga)*MixA.dfcs;

    dif  = abs(vll1-vll2);
    wgs(TIME)=dif;    
 
   if dif > ro | TIME==ndat
       wg1 = exp(vll1 - max(vll1,vll2) );
       wg2 = exp(vll2 - max(vll1,vll2) );
       wg  = wg1/(wg1+wg2);
       flag = 1;

if 1
% flatening   
      if vll1 > vll2, Mix = Mix1; 
      else            Mix = Mix2;
      end
end
% gmean
%    Mix = mixgmean(Mix1, Mix2, wg);
end
    
end

Mix1 = mixflat(Mix);
Mix1 = mixestim(Mix,  1, ndat, 30);
Mix2 = mixestim(Mix0, 1, ndat, 30);

LegendSize = 10;
sub = 220;

clf
sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
H=legend('simulator',0); 
set(H, 'fontSize', LegendSize); grid on
title('pdf(chn1, chn2)')
xlabel('chn1'); ylabel('chn2'); 
H=legend('simulator',0); 
drawnow 

sub = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('BFRG',0);
set(H, 'fontSize', LegendSize); grid on
drawnow

sub = sub + 1; subplot(sub);
M = mixestim(Mix0, 1, ndat);
[x,y,z] = mixgrid(M); contour(x,y,z,15); grid on
H=legend('QB',0);
set(H, 'fontSize', LegendSize); grid on
drawnow


sub = sub + 1; subplot(sub);
vll1 = Mix1.states.mixll;
vll2 = Mix2.states.mixll;

plot(1,vll1,'o'); hold on
plot(2,vll2,'d'); 
plot([vll1,vll2],':');
grid on
ax=axis; ax(1)=0.5; ax(2)=2.5; axis(ax);
H=legend('BFRG', 'QB',0);
set(H, 'fontSize', LegendSize); grid on
xlabel('method'); ylabel('v-log-likelihood');
title('Results');
figure(1);
plt('brafor_');
dial2;

end % ==============================
