% estcmpsta.m
% case study: COMPARISON OF MIXTURE ESTIMATION ALGORITHMS: STATIC CASE
%
% Design : P. Nedoma
% Updated: November 2002, MK October 2004
% Project: GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre


prodini
echo off
idef = [];


while 1 % ==============================================
if isempty(idef)
ndat = 1000;                         % sample size       
ncom = 3;                            % sample size
diac = 0.2;
frg  = 1;                            % forgetting rate
frga = 0.61;  
seed = 123;                          % seed of random generator
niter= 10;                           % No. of iterations
end

% ==========================================================
diabase;
section1=secconst('System',{vs1,vs3});
section2=secconst('Measurements',{vm1,vm2});
section3=secconst('Estimation',{vi3, ve2, ve1});
dia = diaconst('COMPARISON OF MIXTURE ESTIMATION ALGORITHMS: STATIC CASE',...      
      {section1,section2,section3});
dialog;
% ===========================================================

cove = ltdl([diac, 0.1*diac; 0.1*diac diac]); % common noise variance
if seed, randn('seed', seed);  end
Sim  = statsim(ndat, ncom, cove);    % create static mixture

% ----------------------------------------------------------
cove = ltdl([diac, 0.1*diac; 0.1*diac diac]); % common noise variance
randn('seed', seed); 
Sim  = statsim(ndat, ncom, cove);    % create static mixture

% ----------------------------------------------------------
sub  = 230;
LegendSize=10;
%fullscreen

clf
sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
H=legend('simulator',0); 
set(H, 'fontSize', LegendSize); grid on
title('pdf(chn1, chn2)')
xlabel('chn1'); ylabel('chn2'); 
drawnow


Mix0 = genmixe(ncom);

method = 'q';                          % quai-Bayes estimation
Mix = mixest(Mix0, frg, ndat, niter, method); % estimation
Mix = mixstats(Mix,ndat);
vll = Mix.states.mixll;
err = relep(Mix,ndat,1);
sub = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('QB',0); 
set(H, 'fontSize', LegendSize); grid on

method = 'b';                          % batch quasi-Bayes
Mix = mixest(Mix0, frg, ndat, niter, method); % estimation
Mix = mixstats(Mix,ndat);
vll = [vll, Mix.states.mixll];
err    = [err, relep(Mix,ndat,1)];

sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('BQB',0); 
set(H, 'fontSize', LegendSize); grid on


method = 'f';                          % forgetting branching
Mix = mixest(Mix0, frga, ndat, niter, method); % estimation
err = [err, relep(Mix,ndat,1)];
Mix = mixstats(Mix,ndat);
vll = [vll, Mix.states.mixll];

sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Mix); contour(x,y,z,15); grid on
H=legend('BFRG',0); 
set(H, 'fontSize', LegendSize); grid on

sub  = sub + 1; subplot(sub);
plot(1,vll(1), 'o');  hold on
plot(2,vll(2), 'd'); 
plot(3,vll(3), 'x')
%plot(4,vll(4), '*')
plot(vll,':');
ax = axis; ax(1)=0.5; ax(2)=4.5;
axis(ax);
title('data v-log-likelihood')
drawnow
H=legend('QB','BQB', 'BFRG',0); 
set(H, 'fontSize', LegendSize); grid on


sub  = sub + 1; subplot(sub);
plot(1,err(1,1), 'o');  hold on
plot(2,err(1,2), 'd'); 
plot(3,err(1,3), 'x')
%plot(4,err(1,4), '*')
plot(err(1,:),':');
ax = axis; ax(1)=0.5; ax(2)=4.5;
axis(ax);
title('Prediction-errors norm');

H=legend('QB','BQB', 'BFRG',0); 
set(H, 'fontSize', LegendSize); grid on


%setaxis([231:234]);
plt('estcmpsta_');
dial2
end % ====================================
