% factor.m
% case study: PARAMETER AND STRUCTURE ESTIMATION OF NORMAL FACTOR
%
% Design : P. Nedoma
% Updated: January 2001, MK October 2004 
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M


prodini;
clc
echo off
idef = [];


while 1 % ==============================================

if isempty(idef)
covy    = 0.01^2;
covu    = 1;

ndat    = 100;                            % size of data sample
seed    = 5;                              % seed of random generator

dfm     = 1;
cove    = 0.01;
diaCth  = 1e6;                         
frg     = 1;                              % forgetting rate
ord     = 4;
end

% ==========================================================
diabase;
section1=secconst('System',{vs4,vs5});
section2=secconst('Measurements',{vm1,vm2});
section3=secconst('Initial factor',{vi4,vs8, vx4, vx5});
section4=secconst('Estimation', {ve2});
dia = diaconst(...
'PARAMETER AND STRUCTURE ESTIMATION OF NORMAL FACTOR',...
      {section1,section2,section3});
dialog;
% ===========================================================

if seed, randn('seed', seed); end

clf

% ==========================================================
% simulation
% ==========================================================
ychn = 1;                              % output channel
uchn = 2;                              % input  channel

% model of output: dynamic factor 2nd order
str = [1 1 2 2; 1 2 0 1];              % factor structure
Eth = [1.81 -0.8187  0.00468 0.00438]; % regression coeficients
Fac = facarxls(ychn, str);             % output factor
Fac.Eth  = Eth;                        % setting factor fields
Fac.cove = covy;                       % noise covariance
Facs{1}  = Fac;                        % array of factors

% model for input: noise
Fac = facarxls(uchn,[]);               % model: noise
Fac.cove = covu;                       % noise covariance (sufficiently high)
Facs{2}  = Fac;

% simulator
Sim = mixconst(Facs, [1 2], 1);        % build simulator

% get data 
DATA = zeros(2, ndat);                 % pre-allocated data sample
mixsimul(Sim, ndat);                   % get data sample

disp(' ');

maxstr =[ [ones(1, ord), 1+ones(1,ord+1), 0];[1:ord, 0:ord, 1] ]

% model
Fac0      = facarxls(ychn, maxstr);
Fac0.Cth  = diag(0*diag(Fac0.Cth)+diaCth);
Fac0.cove = cove;
Fac0      = arx2arx(Fac0);

% estimation
Mix0 = mixconst(Fac0, 1, 1);
Mix  = mixestqb(Mix0, frg, ndat, 50);
Fac  = Mix.Facs{1};

% structure estimation
nbest = 5; nruns=500;
[optstr, lhs] = facstr(Fac, Fac0, [], nbest, nruns);  
pristrd(maxstr, lhs);

% initial factor for estimation
Fac0      = facarxls(ychn, optstr);

Fac0.Cth  = diag(0*diag(Fac0.Cth)+diaCth);
Fac0.cove = cove;
Fac0      = arx2arx(Fac0);
Fac       = Fac0;

parms=[];
for TIME  = 5:ndat
    Fac   = facupdt(Fac);
    Fac   = facfrg(Fac, frg);
    Fac1  = arx2arx(Fac);
    parms = [parms,Fac1.Eth'];
    Fac   = facfrg(Fac,frg);
end

Fac1 = arx2arx(Fac);

sub        = 220;
LegendSize = 12;
sub  = sub + 1; subplot(sub);
plot(parms(1,:),'r'); 
hold on; ax = axis; plot([ax(1) ax(2)], [Eth(1) Eth(1)]);
xlabel('time'); ylabel('coeff. value');
H = legend('a1',0);
set(H, 'fontSize', LegendSize); grid on

sub  = sub + 1; subplot(sub);
plot(parms(2,:),'r'); 
hold on; ax = axis; plot([ax(1) ax(2)], [Eth(2) Eth(2)]);
H = legend('a2',0);
set(H, 'fontSize', LegendSize); grid on


ii = find(optstr(1,:)==2);
if length(ii)==2 & optstr(2, ii(1))==0 & optstr(2, ii(2))==1
sub  = sub + 1; subplot(sub);
plot(parms(ii(1),:),'r'); hold on
ax = axis; plot([ax(1) ax(2)], [Eth(3), Eth(3)]);
H = legend('b0',0);
set(H, 'fontSize', LegendSize); grid on

sub  = sub + 1; subplot(sub);
plot(parms(ii(2),:),'r'); hold on
ax = axis; plot([ax(1) ax(2)], [Eth(4) Eth(4)]);
H = legend('b1',0);
set(H, 'fontSize', LegendSize); grid on
figure(1);

end %-----------------------------


subplot(111);
legend('structure estimation summary',...
'simulated model structure',...
num2str(str), ...
'richest model structure',...
num2str(maxstr),...
'estimated model structure',...
num2str(Fac.str), 1);
figure(1);




disp('True regression coefficients');
disp(Eth);
disp('Estimated parameters');
disp(Fac1.Eth);
figure(1);
plt('factor_');
dial2
end
