% zdata2.m
% case study: DATA USED IN CASE STUDIES (STATIC MIXTURES, ANY DIMENSION)
%
%
% Design : P. Nedoma
% Updated: November 2002, MK October 2004
% Project: GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%          MINERVA 110330-CP-1-2003-1-ES-MINERVA-M


prodini
echo off
idef = [];


while 1 % ==============================================
if isempty(idef)

nchn = 4;                            % number of channels     
ncom = 6;                            % component covariance
diac = 0.1;                          % diagonal of covar. matrix
diam = 0.5;
ndat = 500;                          % sample size 
seed = 0;                            % seed of random generator

end

% ==========================================================
diabase;
section1=secconst('System',{vs2, vs1, vs3 vs6});
section2=secconst('Measurements',{vm1,vm2,vs6});
dia = diaconst(...
'DATA USED IN CASE STUDIES (STATIC MIXTURES, ANY DIMENSION', ...
      {section1,section2});
dialog;
% ===========================================================

DATA  = zeros(nchn, ndat);           % data sample
str   = [0; 1];                      % static factor structure
ychns = 1:nchn;                      % modelled channels in component
Com   = comarxls(ychns, str);        % build matrix ARX LS component
Com.cove = ltdl( diac*eye(nchn) + 0.05*rand(nchn, nchn) ); % noise variance


% ----------------------------------------------------------

Eth   = zeros(1,nchn);               % regression coefficients
if seed==0, randn('seed', seed); rand('seed',seed); end


for com = 1:ncom                     % generate array of components
    Com.Eth   = Eth';
    Coms{com} = Com;
    Eth = Eth + ones(1,nchn) + randn(1,nchn);
end

Sim   = mixconst(Coms,ncom:-1:1);    % mixture simulator
maxtd = 0;
if diam==0
   CUMTAB=[];
   mixsimul(Sim, ndat);
else
   global CUMTAB ACTIVE
   CUMTAB = gentab(ncom, diam);
   actives = zeros(1,ndat);
   for TIME=maxtd+1:ndat
       Sim=mixsimul(Sim);
       actives(TIME)=ACTIVE;
   end
end


sub  = 220;
LegendSize=12;

clf; figure(1);
sub  = sub + 1; subplot(sub);
[x,y,z] = mixgrid(Sim); contour(x,y,z,15); grid on
xlabel('chn1'); ylabel('chn2'); title('pdf(chn1,chn2)');
H=legend('Simulator'); 
set(H, 'fontSize', LegendSize); grid on
drawnow

sub  = sub + 1; subplot(sub);
plot(DATA(1,:),DATA(2,:),'.','MarkerSize',3);
grid on
xlabel('channel 1'); ylabel('channel 2'); 
H=legend('Data clusters'); 
set(H, 'fontSize', LegendSize); grid on
drawnow

if diam~=0
%sub = sub + 1; subplot(sub);
subplot(212);
plot(actives(maxtd+1:ndat));
xlabel('time'); ylabel('active');
H = legend('active component');
set(H, 'fontSize', LegendSize); grid on
drawnow
end


dial2;
end % ====================================
