% zdatadyn.m
% case study: DATA USED IN CASE STUDIES (DYNAMIC MIXTURES)
%
% Design : P. Nedoma
% Updated: November 2002, MK October 2004
% Project: GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%          MINERVA 110330-CP-1-2003-1-ES-MINERVA-M


prodini
echo off
idef = [];



while 1 % ==============================================

if isempty(idef)
ndat  = 600;                          % sample size       
covu  = 0.1;
covy  = 0.4;  
seed  = 0;   
sys   = 2; 
diam  = 0.9;
end

% ==========================================================
diabase;
section1=secconst('System',{vx6,vx7,vx8, vx9,  vs4, vs5, vs6});
section2=secconst('Measurements',{vm1,vm2});
dia = diaconst(...
'DATA USED IN CASE STUDIES (DYNAMIC MIXTURES)', ...
      {section1,section2});
dialog;
% ===========================================================

ychn = 1;                              % output channel
uchn = 2;                              % input  channel

k = 1; % counter
coms = [];
for i=1:length(sys) % @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    out = sys(i);

switch out %###########################################

case 2 % ============================================== 
str = [1 1 2 2; 1 2 0 1];              % factor structure
Eth = [1.81 -0.8187  0.00468 0.00438]; % regression coeficients

case 3 % ============================================== 
str = [1 1 1 2 2 2; 1 2 3  0 1 2];
Eth = [2.7145  -2.4562  0.7408  0.0001547  0.000574  0.0001331];


case 4  % ============================================== 
str  = [1 1 1 1 2 2;  1 2 3 4 3 4]; % common structure
Eth  = [1.41833  -1.5894  1.3161  -0.88642  0.2826  0.50666];


case 5  % ============================================== 
str  = [1 1 1 1 2 2;  1 2 3 4 3 4]; % common structure
Eth  = [2.0968  -2.3196  1.9335  -0.8713  0.641  0.1041];


case 6 % ============================================== 
str  = [1 1 1 1 2 2;  1 2 3 4 3 4]; % common structure
Eth = [1.9919  -2.2026  1.8408  -0.8941  0.1028  0.1812];

end %################################################

Fac = facarxls(ychn, str);             % output factor
Fac.Eth  = Eth;                        % setting factor fields
Fac.cove = covy;                       % noise covariance
Facs{k}  = Fac;                        % array of factors


% model for input: noise
Fac        = facarxls(uchn,[]);          % model: noise
Fac.cove   = covu;                       % noise covariance (sufficiently high)
Facs{k+1}  = Fac;

coms       = [coms;[k, k+1]];
k          = k+2;
end %@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


% simulator
Sim = mixconst(Facs, coms, ones(1, length(sys)));        % build simulator


% get data sample
if seed, randn('seed', seed); rand('seed',seed); end


DATA   = zeros(2, ndat);                 % pre-allocated DATA
maxtd  = mixmaxtd(Sim);

sub121 = 0;
if length(sys)>1
   if diam==0,  CUMTAB=[]; 
                mixsimul(Sim, ndat);
   else
      global CUMTAB ACTIVE
      CUMTAB = [diam, 1-diam;1-diam, diam];
      actives = [];
      for TIME=maxtd+1:ndat
           mixsimul(Sim);
           actives = [actives, ACTIVE];
      end
   end
   sub121 = 1;
else
    mixsimul(Sim, ndat);
end

sub = 120; 
LegendSize = 11;

clf; figure(1);
sub = sub + 1; subplot(sub);
if sub121
   plot(actives(2:end)); 
   H = legend('active component', 0);
   set(H, 'fontSize', LegendSize); grid on
   drawnow
else
   plot(DATA(2,:));
   H = legend('input', 0);
   set(H, 'fontSize', LegendSize); grid on
   drawnow
end

sub = sub + 1; subplot(sub);
plot(DATA(1,:));
H = legend('output', ['system ',int2str(sys)], 0);
set(H, 'fontSize', LegendSize); grid on
drawnow

dial2

end % ====================================
