% zgain.m
% case study: PRIOR KNOWLEDGE IN STRUCTURE ESTIMATION
%
% Design : P. Nedoma
% Updated: November 2002, MK October 2004
% Project: GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre
%          MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

prodini
echo off
idef = [];

while 1 % ==============================================

if isempty(idef)
ndat  = 300;                          % sample size       
covu  = 1;
covy  = 0.001;  
seed  = 3;      
gain  = [0.9 1.1];
ord   = 6;
end

% ==========================================================
diabase;
section1=secconst('System',{vs4,vs5});
section2=secconst('Measurements',{vm1,vm2});
section3 =secconst('Structure estimation', {vx3});
section4 =secconst('Prior knowledge', {vx10});

dia = diaconst(...
'PRIOR KNOWLEDGE IN STRUCTURE ESTIMATION', ...
      {section1,section2, section3, section4});
dialog;
% ===========================================================

ychn = 1;                              % output channel
uchn = 2;                              % input  channel

% model for output: dynamic factor (model 1 from database of models)
str = [1 1 2 2; 1 2 0 1];              % factor structure
Eth = [1.81 -0.8187  0.00468 0.00438]; % regression coeficients
Fac = facarxls(ychn, str);             % output factor
Fac.Eth  = Eth;                        % setting factor fields
Fac.cove = covy;                       % noise covariance
Facs{1}  = Fac;                        % array of factors

% model for input: noise
Fac = facarxls(uchn,[]);               % model: noise
Fac.cove = covu;                       % noise covariance (sufficiently high)
Facs{2}  = Fac;

% simulator
Sim = mixconst(Facs, [1 2], 1);        % build simulator


% get data sample
if seed, randn('seed', seed); rand('seed',seed); end
DATA = zeros(2, ndat);                 % pre-allocated DATA

mixsimul(Sim, ndat);

LegendSize = 10;


clf
plot(DATA(1,:)); grid on
xlabel('time'); ylabel('output values')
title('System output');
drawnow


% select richest structure, build richest factor
maxstr = [ones(1,ord), 1+ones(1,ord+1), 0    % richest structure
            1:ord,     0:ord,         1];
Fac0   = facarx(ychn, maxstr);         % richest initial factor


% ==========================================================
% structure estimation with prior knowledge
% ==========================================================
GAIN = [uchn, gain];

pre  = preproc( {'scale' []} );       % data are preprocessed


pri  = {'gain' GAIN}; 


pri  = scalepri(pri, pre, ychn);      % preprocess prior knowledge


nbest = 5;                            % number of "best" regressors
nruns = 100;                          % number of estimation runs

[Fac, vll] = pristr(Fac0, pri, [], nbest, nruns);
disp('WITH PRIOR KNOWLEDGE');
pristrd(maxstr, vll);
disp(' ');


Mix0 = mixconst(Fac0, 1, 1);
Mix  = mixestqb(Mix0, 1, ndat, 50);
F    = Mix.Facs{1};

[optstr, lhs] = facstr(F, Fac0, [], nbest, nruns);    %, uchn, 0.9, ord);
disp('WITHOUT PRIOR KNOWLEDGE');
pristrd(maxstr, lhs);


legend('structure estimation summary',...
'simulated model structure',...
num2str(str), ...
'richest model structure',...
num2str(maxstr),...
'estimated model structure with prior knowledge',...
num2str(Fac.str),...
'estimated model structure without prior knowledge',...
num2str(optstr), 0 );
figure(1);




plt('zgain_');
dial2
end % ====================================
