% zverseg.m
% case study: MODEL CHECKING VIA BAYESIAN CROSS-VALIDATION
%
% Designed : PN
% Updated  : MK, October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

prodini;
echo off
idef = [];


while 1 % ==============================================

if isempty(idef)
covy    = 0.01^2;
covu    = 0.01;

ndat    = 300;                            % size of data sample
seed    = 1;                              % seed of random generator

ord     = 4;
ordi    = 2;
n       = 30;
end


% ==========================================================
diabase;
section1=secconst('System',{vs4,vs5,vs9});
section2=secconst('Measurements',{vm1,vm2});
section3=secconst('Initial factor',{vi3a});
section4=secconst('Test', {vx11});
dia = diaconst(...
'MODEL CHECKING VIA BAYESIAN CROSS-VALIDATION',...
      {section1,section2,section3,section4});
dialog;
% ===========================================================

if seed, randn('seed', seed); end

% ==========================================================
% simulation
% ==========================================================
ychn = 1;                              % output channel
uchn = 2;                              % input  channel

% model
if ord == 2
   str = [1 1 2 2; 1 2 0 1];              % factor structure
   Eth = [1.81 -0.8187  0.00468 0.00438]; % regression coeficients
else
   str = [1 1 1 1 2 2;  1 2 3 4 3 4];     % structure
   Eth = [1.41833  -1.5894  1.3161  -0.88642  0.2826  0.50666];
end


Fac = facarxls(ychn, str);             % simulation factor
Fac.Eth  = Eth;                        % setting factor fields
Fac.cove = covy;  
Facs{1}  = Fac;                        % array of factors

% model for input: noise
Fac = facarxls(uchn,[]);               % model: noise
Fac.cove = covu;                       % noise covariance (sufficiently high)
Facs{2}  = Fac;

% simulator
Sim = mixconst(Facs, [1 2], 1);        % build simulator

% get data 
DATA = zeros(2, ndat);                 % pre-allocated data sample
mixsimul(Sim, ndat);                   % get data sample


% ===================================================================

sub  = 120;
LegendSize=12;



% initial model =============================
if 0
stri = [ones(1,ordi), 2,  1+ones(1, ordi), 0];
stri = [stri; 1:ordi, 0,  1:ordi, 1];
end
stri = [ones(1,ordi),   1+ones(1, ordi), 0];
stri = [stri; 1:ordi,   1:ordi, 1];


Fac0 = arx2arx(facarxls(ychn, stri));                % initial factor
[Fac , Res, pH0s] = bisect(Fac0, n);

clf; figure(1);
d    = DATA(1,:);
plot(d); grid on; hold on
nn=floor(ndat/n);


maxtd  = mixmaxtd(Sim);
ndat0  = floor((ndat-maxtd)/n)+1;
tsec   = maxtd+1:ndat0:ndat;
if tsec(length(tsec))<ndat-1
    tsec = [tsec, ndat];
end


N=1:nn:ndat;
l=min([length(N), length(pH0s)]');
N = N(1:l);
P =  pH0s(1:l);

plot(N,P,'or') ; 
hold on; plot(N,P,':r'); grid on
ax=axis; ax(4)=1.2; axis(ax);
H=legend('data','pH0',0);
set(H, 'fontSize', LegendSize); grid on
xlabel('time');
ylabel('data and pH0');

plt('zverseg_');
dial2

end
