% Case study: SIMULTANEOUS DESIGN WITH MARKOV CHAIN MIXTURES
%
% Designed : LT, JaK
% Updated  : MK, October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

echo off; clear all; close all; clc; rand('seed', 123);
global TIME DATA;

F{1} = facmark1(1, [2 1; 0 1], [2 2]);
F{2} = facmark1(1, [2 1; 0 1], [2 2]);
F{3} = facmark1(2, [1; 1], [2 2]);
F{4} = facmark1(2, [1; 1], [2 2]);        
Fu{1} = facmark1(1, [2 1; 0 1], [2 2]);
Fu{2} = facmark1(2, [1; 1], [2, 2]);

idef = [];
while isempty(idef) | idef ~= 's' % ============================================
close all;
% initial values
if isempty(idef),
    % ***** system model ***** 
    % component 1:
    % probabilities of y_t=1
    %       u_t=1    u_t=2
    th1 = [0.85 0.9 0.05 0.1];   
    % component 2:
    %       u_1=1    u_t=2
    th2 = [0.1 0.95 0.8 0.1] ;       
    % first row of transition table for decision strategy
    % component 1:
    th3 = [0.6 0.5];
    % component 2:        
    th4 = [0.3 0.6];
    % component 1 weight
    alpha = 0.5
 
    % ***** user's ideal pdf ******
    % probabilities of y_t=1
    %       u_t=1    u_t=2
    Uth1 = [0.95 0.95  0.95 0.95];   
    % first row of transition table for decision strategy
    Uth2 = [0.5 0.5];
    % component 1 weight
    Ufc = 0.5;

    nhor = 10;             % time horizon length
    data  = [1;1];          % starting DATA
    ndat  = 50;             % number of simulated data
end

clc
while 1;
fprintf('\n SIMULTANEOUS DESIGN WITH MARKOV CHAIN MIXTURES\n');
fprintf('================================================\n');
fprintf('\n--- System -----------------------------------------------------------------------\n');
fprintf('probabilities of y(t) = 1 for [u(t),y(t-1)] =  [1,1]     [1,2]     [2,1]     [2,2]\n');
fprintf(' - component 1:                   ->  th1 =    '); displ(th1, '\n');
fprintf(' - component 2:                   ->  th2 =    '); displ(th2, '\n');
fprintf('probabilities of u(t) = 1 for y(t-1) =  1         2 \n');
fprintf(' - component 1:           ->  th3  =    '); displ(th3, '\n');
fprintf(' - component 2:           ->  th4  =    '); displ(th4, '\n');
fprintf('copmonent 1 weight        ->  alpha=    '); displ(alpha, '\n');  
fprintf('\n--- User''s ideal pdf -------------------------------------------------------------\n');
fprintf('probabilities of y(t) = 1 for [u(t),y(t-1)] =  [1,1]     [1,2]     [2,1]     [2,2]\n');
fprintf('                                 ->  Uth1 =    '); displ(Uth1, '\n');
fprintf('probabilities of u(t) = 1 given y(t-1) =  1         2 \n');
fprintf('                           ->  Uth2  =    '); displ(Uth2, '\n');
fprintf('copmonent 1 weight         ->  Ufc   =    '); displ(Ufc, '\n');  
fprintf('\n--- Design -----------------------------------------------------------------------\n');
fprintf('receding design horizon    ->  nhor  =    '); displ(nhor, '\n');  
fprintf('length of simulation       ->  ndat  =    '); displ(ndat, '\n');  
dial1
[t1,th1]  = test01(th1, 'th1',1,4);
[t2,th2]  = test01(th2, 'th2',1,4);
[t3,th3]  = test01(th3, 'th3',1,2);
[t4,th4]  = test01(th4, 'th4',1,2);
[t5,alpha]  = test01(alpha, 'alpha',1,1);
[t6,Uth1]  = test01(Uth1, 'Uth1',1,4);
[t7,Uth2]  = test01(Uth2, 'Uth2',1,2);
[t8,Ufc]  = test01(Ufc, 'Ufc',1,1);
t9  = (nhor>0)& ~(nhor - floor(nhor));
t10 = (ndat> 0)& ~(ndat  - floor(ndat));
if t1&t2&t3&t4&t5&t6&t7&t8&t9&t10;
   break;
end;
fprintf('\n\nEnter valid inputs:\n');
end;

% model pdf
F{1}.trt = [th1; 1-th1];         
F{2}.trt = [th2; 1-th2];         
F{3}.trt = [th3; 1-th3];           
F{4}.trt = [th4; 1-th4];      
Mix = markmixc(F, [1 3; 2 4], [alpha 1-alpha]);
Mix.dfcs = [alpha 1-alpha];
    
% user ideal pdf
Fu{1}.trt = [Uth1; 1-Uth1];
Fu{2}.trt = [Uth2; 1-Uth2];           
Mixu = markmixc(Fu, [1 2], [1]);

% simulation loop with original weights of components
TIME = size(data,2);
DATA = data;
marksim(Mix, ndat);
dorig = DATA;
figure(1);
subplot(2,1,1);
axis([1, ndat + size(data, 2), 0.9, 2.1]);
set(figure(1), 'Position', [100 300 300 250], 'MenuBar', 'none')
set(subplot(2,1,1), 'Position', [0.15 0.60 0.75 0.25], ...
    'YTick', [1; 2]);
title('Unguided system');
xlabel('time');
ylabel('output');
hold on;
plot(dorig(1,:),'b*');
subplot(2,1,2);
axis([1, ndat + size(data, 2), 0.9, 2.1]);
set(subplot(2,1,2), 'Position', [0.15 0.15 0.75 0.25], ...
    'YTick', [1; 2]);
xlabel('time');
ylabel('input');
hold on;
plot(dorig(2,:),'b*');

figure(2);
s1 = subplot(2,1,1);
axis([1, ndat + size(data, 2), 0.9, 2.1]);
hold on;
set(figure(2), 'Position', [500 300 300 250], 'MenuBar', 'none')
set(s1, 'Position', [0.15 0.60 0.75 0.25], ...
    'YTick', [1; 2]);
title('Guided system');
xlabel('time');
ylabel('output');
s2 = subplot(2,1,2);
axis([1, ndat + size(data, 2), 0.9, 2.1]);
hold on;
set(s2, 'Position', [0.15 0.15 0.75 0.25], ...
    'YTick', [1; 2]);
xlabel('time');
ylabel('input');

% simulation loop with optimized weights of components
% initial TIME and DATA
TIME = size(data,2);
DATA = data;
% mixture for simulaiton
Mixo = Mix;
for t = 1:ndat,
    % optimization of a control strategy
    ifca = mdessim(Mix, Mixu, [2], [Ufc, 1-Ufc], nhor);
    % optimal component weights
    ocw = sum(ifca');
    Mixo.dfcs = ocw;
    yprev = getdvect([1; 0]);
    Mixo.Facs{3}.trt(:, yprev) = ifca(1,:)'./ocw(1);
    Mixo.Facs{4}.trt(:, yprev) = ifca(2,:)'./ocw(2);
    marksim(Mixo,1);
    subplot(s1);
    plot(DATA(1,:),'r*');
    subplot(s2);
    plot(DATA(2,:),'r*');
    pause(0.001);
end 
dopt = DATA;
figure(3);
axis([1, ndat + size(data, 2), 0.9, 2.1]);
set(figure(3), 'Position', [350 100 450 200], 'MenuBar', 'none')
s31 = subplot(1,1,1);
set(s31, 'Position', [0.15 0.20 0.75 0.60]);
title('Time evolution of average of outputs');
xlabel('time');
ylabel('mean output');
hold on;
plot(cumsum(dorig(1,:))./(1:length(dorig)), 'b');
plot(cumsum(dopt(1,:))./(1:length(dopt)), 'r');
Mixup = mst2par(Mixu);
uyuy = Mixu.Facs{1}.trt * diag(Mixu.Facs{2}.trt([1 3 2 4]));
uyy = [uyuy(:,1)+uyuy(:,3) uyuy(:,2)+uyuy(:,3)];
[eve, eva] = eig(uyy);
% stationary distribution
st = eve(:, find(abs(sum(eva) - 1) <= eps))';
st = st./sum(st);
plot(st*[1; 2]*ones(length(dorig)), 'g:');
legend('original', 'optimal', 'from user ideal pdf' );


DATA = [1;1];
TIME = 1;
ifca1 = mdessim(Mix, Mixu, [2], [Ufc, 1-Ufc], nhor);
DATA = [2;1];
TIME = 1;
ifca2 = mdessim(Mix, Mixu, [2], [Ufc, 1-Ufc], nhor);

fprintf('--- optimal decision strategy -----------------------------------------------------\n');
fprintf('joint probabilities of pointers to components and inputs for given previous output\n');
fprintf('                y(t-1)=1  y(t-1)=2\n');
fprintf('c=1, u(t)=1     '); displ([ifca1(1) ifca2(1)], '\n');
fprintf('c=1, u(t)=2     '); displ([ifca1(3) ifca2(3)], '\n');
fprintf('c=2, u(t)=1     '); displ([ifca1(2) ifca2(2)], '\n');
fprintf('c=2, u(t)=2     '); displ([ifca1(4) ifca2(4)], '\n');


dproj(1:2, 1) = Mix.Facs{1}.trt(:,1)*ifca1(1) + Mix.Facs{2}.trt(:,1)*ifca1(2);
dproj(3:4, 1) = Mix.Facs{1}.trt(:,3)*ifca1(3) + Mix.Facs{2}.trt(:,3)*ifca1(4);
dproj(1:2, 2) = Mix.Facs{1}.trt(:,2)*ifca2(1) + Mix.Facs{2}.trt(:,2)*ifca2(2);
dproj(3:4, 2) = Mix.Facs{1}.trt(:,4)*ifca2(3) + Mix.Facs{2}.trt(:,4)*ifca2(4);

fprintf('\n--- projection on user data ------------------------------------------------------\n');
fprintf('joint probabilities of current input and output for a given previous output\n');
fprintf('                 y(t-1)=1  y(t-1)=2\n');
fprintf('u(t)=1, y(t)=1   '); displ(dproj(1,:), '\n');
fprintf('u(t)=1, y(t)=2   '); displ(dproj(2,:), '\n');
fprintf('u(t)=2, y(t)=1   '); displ(dproj(3,:), '\n');
fprintf('u(t)=2, y(t)=2   '); displ(dproj(4,:), '\n');
fprintf('----------------------------------------------------------------------------------\n');

dial2
end % ==========================================================
