% ESTIMATION OF MARKOV CHAIN MIXTURE PARAMETERS
% Rem: Two-valued data (1,2), coin model with memory 
%
% Designed : LT and JaK
% Updated  : MK, October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

echo off; 
clear all; 
close all;
rand('seed', 123456); 
clc; 

global TIME DATA;

F{1}     = facmark1(1,[1; 1 ],[2]);
F{2}     = facmark1(1,[1; 2 ],[2]);
F{1}.dfm = 1;
F{2}.dfm = 1;

idef = 'i';
while idef ~= 's' % ============================================
close all;
% initial values
if idef == 'i'
    % model parameters
    th1    = [.95 .1];                       % prob. of y=1, component 1
    th2    =  [.8  .3];                      % prob. of y=1, component 2
    alpha  = .7;                             % component 1 weight
    ndat   = 500;                            % number of data samples 
    % prior pdf
    th01   = [.5 .5];                        % prob. of y=1, component 1
    th02   = [.5 .5];                        % prob. of y=1, component 2
    alpha0 = .5;                             % component 1 weight
end

clc
while 1;
fprintf('\n ESTIMATION OF MARKOV CHAIN MIXTURE PARAMETERS\n');
fprintf('===============================================\n');
fprintf('\n--- System ------------------------------------------------------------\n');
fprintf('component 1: probabilities of y(t)=1   for y(t-1)=1, y(t-1)=2\n');   
fprintf('                          ->  th1   =      '); displ(th1, '\n');
fprintf('component 2: probabilities of y(t)=1   for y(t-2)=1, y(t-2)=2\n');   
fprintf('                          ->  th2   =      '); displ(th2, '\n');
fprintf('weight of component 1     ->  alpha =      '); displ(alpha, '\n');  
fprintf('\n--- Prior pdf ---------------------------------------------------------\n');
fprintf('component 1: probabilities of y(t)=1   for y(t-1)=1, y(t-1)=2\n');   
fprintf('                          ->  th01  =      '); displ(th01, '\n');
fprintf('component 2: probabilities of y(t)=1   for y(t-2)=1, y(t-2)=2\n');   
fprintf('                          ->  th02  =      '); displ(th02, '\n');
fprintf('weight of component 1     ->  alpha0=      '); displ(alpha0, '\n');  
fprintf('\n--- Estimation --------------------------------------------------------\n');
fprintf('number of data simulated  ->  ndat  =      '); displ(ndat, '\n');

dial1
[t1,th1]  = test01(th1, 'th1',1,2);
[t2,th2]  = test01(th2, 'th2',1,2);
[t3,th01] = test01(th01,'th01',1,2);
[t4,th02] = test01(th01,'th02',1,2);
[t5,alpha0] = test01(alpha0,'alpha0',1,1);
[t7,alpha]  = test01(alpha,'alpha',1,1);
t6 = (ndat>0)& ~(ndat-floor(ndat));
if t1&t2&t3&t4&t5&t6&t7;
   break;
end;
fprintf('\n\nEnter valid inputs:\n');
end;

% model pdf
F{1}.trt = [th1; 1-th1];         
F{2}.trt = [th2; 1-th2];         
cws = [alpha 1-alpha];
Mix=markmixc(F,[1; 2],cws);

% prior pdf
Mix0 = Mix;
Mix0.Facs{1}.trt = [th01; 1-th01];
Mix0.Facs{2}.trt = [th02; 1-th02];
Mix0.dfcs = [alpha0 1-alpha0];

% initial TIME and DATA
TIME = 2;
DATA = [1 2];

% data simulation
marksim(Mix,ndat);

% estimation
TIME = 2;
% Mix1  = markqb(Mix0,1,ndat);
Mix1 = Mix0;
Mix1p = mst2par(Mix1);
thdev1(1:2, 1) = Mix1p.Facs{1}.trt(1,:)';
thdev2(1:2, 1) = Mix1p.Facs{2}.trt(1,:)';
dfcdev(1) = Mix1p.dfcs(1);
for t = 1:ndat,
    Mix1  = markqb(Mix1, 1, 1);
    Mix1p = mst2par(Mix1);
    thdev1(1:2, t+1) = Mix1p.Facs{1}.trt(1,:)';
    thdev2(1:2, t+1) = Mix1p.Facs{2}.trt(1,:)';
    dfcdev(t+1) = Mix1p.dfcs(1);
    TIME = TIME + 1;
end

Mixp = mst2par(Mix);
Eth1 = Mix1p.Facs{1}.trt(1, :);
Eth2 = Mix1p.Facs{2}.trt(1, :);
Ealpha = Mix1p.dfcs(1);

fprintf('\n--- original system ---------------------------------------------------\n');
fprintf('component 1: probabilities of y(t)=1 for y(t-1)=1, y(t-1)=2\n');   
fprintf('                                 th1   = '); displ(th1, '\n');
fprintf('component 2: probabilities of y(t)=1 for y(t-2)=1, y(t-2)=2\n');   
fprintf('                                 th2   = '); displ(th2, '\n');
fprintf('weight of component 1            alpha = '); displ(alpha, '\n');  
fprintf('--- point estimates -----------------------------------------------------\n');
fprintf('component 1: probabilities of y(t)=1 for y(t-1)=1, y(t-1)=2\n');   
fprintf('                                 Eth1  = '); displ(Eth1, '\n');
fprintf('component 2: probabilities of y(t)=1 for y(t-2)=1, y(t-2)=2\n');   
fprintf('                                 Eth2  = '); displ(Eth2, '\n');
fprintf('weight of component 1            Ealpha= '); displ(Ealpha, '\n');  
fprintf('-------------------------------------------------------------------------\n');

fprintf('- probabilities of y(t)=1 for the systems described by one Markov chain -\n');
G{1} = facmark1(1,[1 1; 1 2],[2]);
T0 = mark2norm(G,Mixp);
T1 = mark2norm(G,Mix1p);
fprintf('\n');
fprintf('                   y(t-1)=1  y(t-1)=1  y(t-1)=2  y(t-1)=2\n');
fprintf('                   y(t-2)=1  y(t-2)=2  y(t-2)=1  y(t-2)=2\n');
fprintf('                   --------------------------------------\n');
fprintf('original system:   '); displ(T0(1,:), '\n');
fprintf('point estimates:   '); displ(T1(1,:), '\n');

figure(1);
set(figure(1), 'Position', [300 200 600 300])
axis([1, ndat + 2, 0, 1]);
title('Time evolution of point estimates');
xlabel('time');
hold on;
plot(thdev1(1,:), 'r');
plot(thdev1(2,:), 'b');
plot(thdev2(1,:), 'g');
plot(thdev2(2,:), 'y');
plot(dfcdev, 'k');
plot(th1(1) * ones(1, ndat+2), 'r:');
plot(th1(2) * ones(1, ndat+2), 'b:');
plot(th2(1) * ones(1, ndat+2), 'g:');
plot(th2(2) * ones(1, ndat+2), 'y:');
plot(alpha(1) * ones(1, ndat+2), 'k:');

legend('Eth1(1)','Eth1(2)','Eth2(1)','Eth2(2)','Ealpha',...
       'th1(1)','th1(2)','th2(1)','th2(2)','alpha')
dial2
end % ==========================================================
% quit
