% Designed : LP
% Updated  : MK, October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M
% ARX NORMAL MODEL - CONTROL WITH KNOWN PARAMETERS
%
% y(t) = a1*y(t-1) + b0*u(t) + e(t)
%
% parameters:
% a1,b0,cove
prodini
clc
echo off
idef = [];
while 1 %====================================================
% definitions and initial values
if isempty(idef)
ndat=100; 
nhor=ndat;                               % receding horizon
om=1; cove=.001; y=5;
a1=.95; b0=1;
st1=4; st2=-2;                           % step values
end
clc
fprintf('ARX NORMAL MODEL - CONTROL WITH KNOWN PARAMETERS\n');
fprintf('= = = = = = = = = = = = = = = = = = = = = = = = =\n');
fprintf('Number of data records           -> ndat  = %5i\n',ndat);
fprintf('--- system -----------------------------------------\n');
fprintf('y(t) = a1*y(t-1) + b0*u(t) + e(t)\n');
fprintf('\n');
fprintf('System (and model) parameters    ->   a1  = %8.3f\n',  a1);
fprintf('                                 ->   b0  = %8.3f\n',  b0);
fprintf('Noise dispersion                 -> cove  = %8.3f\n',   cove);
fprintf('--- required output value - step function ----------\n');
fprintf('First  step value               ->   st1  = %8.3f\n',  st1);
fprintf('Second step value               ->   st2  = %8.3f\n',  st2);
fprintf('--- input ------------------------------------------\n');
fprintf('Penalization                    ->    om  = %8.3f\n',  om);
fprintf('======================================================\n');

dial1
yy=y; uu=0;
%reguired value computation
w=zeros(1,ndat+nhor);
w(fix(ndat/3):fix(2*ndat/3))=st1;
w(fix(2*ndat/3)+1:ndat+nhor)=st2;

%simulation run 
%input signal computation

for t=1:ndat,
  [Rt,St]=regCL(nhor,a1,b0,cove,om,w(t:t+nhor-1));
  u=Rt(1)*y+St(1);
  e=sqrt(cove)*randn;
  y=a1*y+b0*u+e;
  yy=[yy y]; uu=[uu u];
end

figure(1),resizefig(70,15,15);
subplot(211),plot(uu,'-r'), grid
xlabel('time'),ylabel('input'), title('ARX normal model: Control with known parameters')
subplot(212),plot(2:ndat+1,w(1:ndat),'c',1:ndat+1,yy,'-b'), grid
legend('required value','output')
xlabel('time'),ylabel('output')

dial2
end
