% Designed : LP
% Updated  : MK, October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M
% ADAPTIVE CONTROL BASED ON CERTAINTY EQUIVALENCE STRATEGY
%
% y(t) = a1*y(t-1) + b0*u(t) + e(t)
%
% parameters:
% a1,b0,cove
prodini
clc
echo off
idef = [];
while 1 %====================================================
% definitions and initial values
if isempty(idef)
ndat=100;                               % size of data sample
nhor=15;                                   % control horizont 
om=1;                                   % input penalisation
cove=.01;                               % noise variance
y=0;
a1=0.95; b0=-0.5;                         % system parameters
st1=4; st2=-2;                          % step values

end
clc
fprintf('ADAPTIVE CONTROL BASED ON CERTAINTY EQUIVALENCE STRATEGY\n');
fprintf('= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =\n');
fprintf('Number of data records           ->   ndat  = %5i\n',  ndat);
fprintf('--- system -----------------------------------------\n');
fprintf('y(t) = a1*y(t-1) + b0*u(t) + e(t), e(t) ~ N(0,cove) \n');
fprintf('\n');
fprintf('System parameters                ->   a1   = %8.3f\n',  a1);
fprintf('                                 ->   b0   = %8.3f\n',  b0);
fprintf('Noise dispersion                 ->   cove = %8.3f\n',  cove);
fprintf('--- required output value - step function ----------\n');
fprintf('First  step value                ->   st1  = %8.3f\n',  st1);
fprintf('Second step value                ->   st2  = %8.3f\n',  st2);
fprintf('--- input ------------------------------------------\n');
fprintf('Input penalization               ->    om  = %8.3f\n',  om);
fprintf('--- control -----------------------------------------\n');
fprintf('Receding design horizon          ->   nhor = %5i\n',  nhor);
fprintf('======================================================\n');

dial1
C=eye(2)*1e5; th=[0.1 -0.1]'; Lam=0;
yy=y; uu=0; u=0; tt=[];
w=zeros(1,ndat+nhor);
w(5:fix(2*ndat/3))=st1;
w(fix(2*ndat/3)+1:ndat+nhor)=st2;
  
%simulation run 
%input signal computation + parameter estimation
for t=1:ndat,
  [Rt,St]=regCL(nhor,th(1),th(2),cove,om,w(t:t+nhor-1));  % control law computation
  eps=.0*randn;
  u=Rt(1)*y+St(1)+eps;                           % control input
  e=sqrt(cove)*randn;
  y=a1*y+b0*u+e;                                 % system output
  z=[yy(end); u];
  [th,C,Lam]=ideST(y,z,th,C,Lam);                % parameters estimation
  yy=[yy y]; uu=[uu u]; tt=[tt th];
end
figure(1),resizefig(70,15,15)
subplot(311),plot(uu,'g'), grid
xlabel('time'), ylabel('input') 
title('Adaptive control based on certainty equivalence strategy')
subplot(312),plot(2:ndat+1,w(1:ndat),'c',1:ndat+1,yy,'b'), grid
xlabel('time'), ylabel('output')
legend('required value','output')
subplot(313),plot(1:ndat,tt(1,:),'b',1:ndat,tt(2,:),'r',...
  [1,ndat],[a1 a1],':b',[1,ndat],[b0 b0],':r'), grid
axis([1,ndat,-3,3])
xlabel('time'), ylabel('parameter estimates')
legend('a1','b0')
dial2
end
