% Designed : LP
% Updated  : MK, October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M
% ARX NORMAL MODEL - PARAMETER ESTIMATION WITH FORGETTING
%
% y(t) = 
% a1*y(t-1) + a2*y(t-2) + b0*u(t) + b1*u(t-1) + b2*u(t-2) + c*v(t) + e(t)
%
% parameters:
% a1,a2,b0,b1,b2,c,cove
% known signal v_(t)
prodini
clc
echo off
idef = [];
while 1 %====================================================
warning off MATLAB:singularMatrix

% definitions and initial values
if isempty(idef)
  ndat = 300;                          % size of data sample
  y(1)=0; y(2)=0;                      % initial data
  a1 = 1.81;                           % model parameters
  a2 = -0.83;
  b0 = -0.3;
  b1 = 0.1;
  b2 = 0;
  c  = 0;
  cove  = 0.01;                        % noise variance
  rg=1;                                % range of random input signal (-rg,rg) 
  frg=0.98;                            % forgetting factor
end
clc
fprintf('ARX NORMAL SYSTEM - PARAMETER ESTIMATION WITH FORGETTING\n');
fprintf('= = = = = = = = = = = = = = = = = = = = = = = = = = = = =\n');
fprintf('Number of data records            -> ndat  = %g\n',  ndat);
fprintf('--- System ----------------------------------------------\n');
fprintf('y(t) = a1*y(t-1) + a2*y(t-2) + b0*u(t) + b1*u(t-1) + c*v(t) + e(t)\n');
fprintf('\n');
fprintf('System parameters                 ->   a1  = %8.3f\n',  a1);
fprintf('                                  ->   a2  = %8.3f\n',  a2);
fprintf('                                  ->   b0  = %8.3f\n',  b0);
fprintf('                                  ->   b1  = %8.3f\n',  b1);
fprintf('                                  ->   b2  = %8.3f\n',  b2);
fprintf('                                  ->    c  = %8.3f\n',   c);
fprintf('Noise variance                    -> cove  = %8.3f\n',   cove);
fprintf('--- Quantities ------------------------------------------\n');
fprintf('Noise input; uniform on (-rg,+rg) ->   rg  = %8.3f\n',  rg);
fprintf('\n');
fprintf('Unitary additional signal v(t)\n');
fprintf('--- Forgetting ------------------------------------------\n');
fprintf('Forgetting factor                 ->  frg  = %8.3f\n',  frg);
fprintf('=========================================================\n');


dial1
while ndat<100
    disp('data set is too small - choose ndat > 100')
    dial1
end

u  = zeros(1,ndat);
v  = ones(1,ndat);
y  = zeros(1,ndat);

theta = [a1 a2 b0 b1 b2 c];          % true parameters
Theta = [theta cove]; 
  
%simulation run 
%input signal computation
size_theta=max(size(theta));          % size of the parameters
psi   = zeros(size_theta,1);          % regression vector
Psi   = zeros(size_theta+1,1);        % extended regression vector
V0    = zeros(size_theta+1,size_theta+1); % initial statistics
ny0   = 0;

% estimated parameters
a1_ = zeros(1,ndat);  a2_ = zeros(1,ndat);
b0_ = zeros(1,ndat);  b1_ = zeros(1,ndat); b2_ = zeros(1,ndat);
c_  = zeros(1,ndat);  cove_  = zeros(1,ndat);

% statistic construction 
V=V0; ny=ny0;  % initial statistics
               % statistics dividing:
               % V = | V_y     V_y_psi |
               %     | V_y_psi V_psi   |

for i=1:ndat
   u(i)=2*rg*(rand-0.5);  %random input
end
y(1)=0; y(2)=0;
for i=3:ndat
    y(i)=theta*[y(i-1) y(i-2) u(i) u(i-1) u(i-2) v(i)]' + sqrt(cove)*randn;
    if ndat>250  
        err=100;                        % simulation of disturbance in output measurement    
    else
        err=round(ndat/2); 
    end
    if abs(i-err)<3, y(i)=2*max(y); end
    
    psi(1)=y(i-1);
    psi(2)=y(i-2);
    psi(3)=u(i);
    psi(4)=u(i-1);
    psi(5)=u(i-2);
    psi(6)=v(i);
    Psi=[y(i),psi']';
    V=frg*V+Psi*Psi';
    ny=ny+1;
    V_y=V(1,1);
    V_y_psi=V(2:7,1);
    V_psi=V(2:7,2:7);
    warning off;
    C= inv(V_psi);
    warning on;
    lambda=V_y - V_y_psi'*C*V_y_psi;
    if ny>10
        theta_estim=C*V_y_psi;       % ARX model parameters estimated  
        cove_estim=lambda/ny;        % estimated noise dispersion 
        a1_(i)= theta_estim(1,1);    % estimated model parameters + noise dispersion
        a2_(i)= theta_estim(2,1);
        b0_(i)= theta_estim(3,1);
        b1_(i)= theta_estim(4,1);
        b2_(i)= theta_estim(5,1);
        c_(i) = theta_estim(6,1);
        cove_(i) = cove_estim;
    end
end

sub=320;
figure(1)
resizefig(80, 10,10)
sub  = sub + 1; subplot(sub);
plot(1:ndat,a1,'g',1:ndat,a1_,'b'),grid, ylabel('a1'), xlabel('time'), 
title('Time evolution of parameter estimates')
sub  = sub + 1; subplot(sub);
plot(1:ndat,a2,'g',1:ndat,a2_,'b'),grid, ylabel('a2'), xlabel('time')
sub  = sub + 1; subplot(sub);
plot(1:ndat,b0,'g',1:ndat,b0_,'b'),grid, ylabel('b0'), xlabel('time')
sub  = sub + 1; subplot(sub);
plot(1:ndat,b1,'g',1:ndat,b1_,'b'),grid, ylabel('b1'), xlabel('time')
sub  = sub + 1; subplot(sub);
plot(1:ndat,b2,'g',1:ndat,b2_,'b'),grid, ylabel('b2'), xlabel('time')
sub  = sub + 1; subplot(sub);
plot(1:ndat,c,'g',1:ndat,c_,'b'),grid, ylabel('c'), xlabel('time')

warning on MATLAB:singularMatrix
dial2
end
