% Designed : LP
% Updated  : MK, October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M
% PREDICTION WITH ARX MODEL -- KNOWN PARAMETERS, FEEDFORWARD CONTROL 
%
% y(t) = a1*y(t-1) + a2*y(t-2) + b0*u(t) + b1*u(t-1) + b2*u(t-2) +
% + e(t),  e(t)~ N(0,cove), u(t) ~ U(0,covu)
%
% Optional parameters: a1,a2,b0,b1,cove,rg  
% b2=0;
prodini
clc
echo off
idef = [];
while 1 %====================================================
% definitions and initial values
if isempty(idef)
ns=3; 
nstep=5;                                 % nstep-step-ahead prediction
ndat = 250;                              % size of data sample
  a1   = 1.81;                           % model parameters
  a2   = -0.83;
  b0   = -0.3;
  b1   = 0.1;
  b2   = 0;
  c    = 0;
  cove = 0.01;                            % noise variance
  rg   = 1;                               % range of uniform random input signal (-rg,rg) 
end

clc
fprintf('PREDICTION WITH ARX MODEL -- KNOWN PARAMETERS, FEEDFORWARD CONTROL\n');
fprintf('= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =\n');
fprintf('\nNumber of data records         -> ndat  = %i\n',  ndat);
fprintf('--- System -----------------------------------------\n');
fprintf('y(t) = a1*y(t-1) + a2*y(t-2) + b0*u(t) + b1*u(t-1) + e(t)\n');
fprintf('\n');
fprintf('System parameters                ->   a1  = %6.3f\n',  a1);
fprintf('                                 ->   a2  = %6.3f\n',  a2);
fprintf('                                 ->   b0  = %6.3f\n',  b0);
fprintf('                                 ->   b1  = %6.3f\n',  b1);
fprintf('\n');
fprintf('Noise variance                   -> cove  = %6.3f\n',  cove);
fprintf('-----------------------------------------------------\n');
fprintf('Random input u(t), white uniform noise               \n');
fprintf('Input range: (-rg,+rg)           -> rg    = %g\n', rg);
fprintf('-----------------------------------------------------\n');
fprintf('nstep-ahead prediction           -> nstep = %g\n', nstep);
fprintf('============================================================\n');
% random measurable signal, signal from generator
% optional input signat range
% lower/upper bound

dial1

th=[b0 a1 b1 a2 b2]'; s=sqrt(cove);
y=zeros(1,ndat+nstep); y(1:2)=[5 1];
u  = zeros(1,ndat+nstep);
for i=1:(ndat+nstep)
     u(i)=2*rg*(rand-0.5);
end
yp=[]; yy=[];
for t=ns:ndat
  % prediction
  fpp=[u(t) y(t-1) u(t-1) y(t-2) u(t-2)]';
  ypp=th'*fpp;
  for i=1:nstep
    fpp=[u(t+i); ypp; fpp(1:end-2)];
    ypp=th'*fpp;
  end
  yp=[yp ypp];
  % simulation
  f=[u(t) y(t-1) u(t-1) y(t-2) u(t-2)]';
  y(t)=th'*f+s*randn;
end
d=[[zeros(ns+nstep-1,1); yp'] y'];
if ndat+nstep<=50
  disp('prediction, output')
  disp(d)
end
figure(1)
resizefig(50, 15,15)
plot(1:size(d,1),d(:,1),'b',1:size(d,1),d(:,2),'g'), grid
xlabel('time'), ylabel('output and its prediction')
s=[num2str(nstep), '-step-ahead prediction with ARX model'];
eval('title(s)');
legend('prediction','output')

dial2
end
