% Designed : LP
% Updated  : MK, October 2004
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M
% GENERALIZED PREDICTION WITH ARX MODEL -- KNOWN PARAMETERS, FEEDFORWARD CONTROL
%
% y(t) = a1*y(t-1) + b0*u(t) + e(t), 
% e(t)~ N(0,cove), u(t) ~ U(0,covu)
%
% Optional parameters: a1,b0,cove,rg  
prodini
clc
echo off
idef = [];
while 1 %====================================================
% definitions and initial values
if isempty(idef)
ndat = 100;                            % size of data sample
nstep=5;                               % nstep ahead prediction
a1=.95; b0=.5; cove=.01; 
y=0; dd=[];
pau =0.05;                             % pause between figures 
rg=1;                                  % range of random input signal (-rg,rg) 
end
clc
fprintf('GENERALIZED PREDICTION WITH ARX MODEL -- KNOWN PARAMETERS, FEEDFORWARD CONTROL\n');
fprintf('= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = \n');
fprintf('Number of data records                   ->  ndat  = %i\n',  ndat);
fprintf('--- System -----------------------------------------\n');
fprintf('y(t) = a1*y(t-1) + a2*y(t-2) + b0*u(t) + b1*u(t-1) + b2*u(t-2) + e(t)\n');
fprintf('\n');
fprintf('Model parameters                         ->    a1  = %6.3f\n',  a1);
fprintf('                                         ->    b0  = %6.3f\n',  b0);
fprintf('\n');
fprintf('Noise variance                           ->  cove  = %6.3f\n',   cove);
fprintf('--------------------------------------------------------\n');
fprintf('Random input u(t), white uniform noise               \n');
fprintf('Input range: (-rg,+rg)                   ->   rg   = %g\n', rg);
fprintf('--------------------------------------------------------\n');
fprintf('nstep-ahead prediction                   -> nstep  = %i\n', nstep);
fprintf('Figures of time evolution freeze for     -> pau[s] = %g\n', pau );
fprintf('==========================================================\n');

dial1
u  = zeros(1,ndat+nstep);
for i=1:(ndat+nstep)
     u(i)=2*rg*(rand-0.5);
end
% time loop
for t=2:ndat-nstep
% prediction coefficients
  yp1=y(t-1); yp2=y(t-1)^2;
  for i=1:nstep
    yp1=a1*yp1+b0*u(t+i-1);
    yp2=a1^2*yp2+2*a1*b0*u(t+i-1)*yp1+b0^2*u(t+i-1)^2+cove;
  end
  
% prediction
  D=yp2-yp1^2; dd=[dd D];
  yp(t+nstep-1)=yp1+sqrt(D)*randn*0;
  yd(t+nstep-1)=yp(t+nstep-1)-2*sqrt(D);
  yh(t+nstep-1)=yp(t+nstep-1)+2*sqrt(D);

% simulation
  y(t)=a1*y(t-1)+b0*u(t)+sqrt(cove)*randn;
  
% results - time evolution of predictive pdf
x=-4*(sqrt(cove)+rg):.01:4*(sqrt(cove)+rg);
g=gauss1(x,yp(t),D);
clf, figure(1), resizefig(75,10,10);
sub=120;
 sub  = sub + 1; subplot(sub);
if t>40
plot(x,g,y(t)*ones(2,1)',[1,0],'r'), grid
legend('predictive pdf','real output value')
s=['Predictive pdf - time: ',num2str(t)];
eval('title(s)');
xlabel('output'), ylabel('predictive pdf')
drawnow
pause(pau)
end
end
%results - output, prediction, confidence interval 
sub  = sub + 1; subplot(sub);
plot(1:length(yp),real(yd),'-c',1:length(yp),real(yh),'-c','markersize',3)
hold on
plot(1:length(y),y,'-r',1:length(yp),yp,'-b'), grid
hold off
legend('confidence interval','','output','prediction')
xlabel('time'), ylabel('output')
title('Output and its prediction')
ep=yp(2:ndat-nstep)-y(2:ndat-nstep);
%se=sqrt(ep*ep'/(length(ep)-1)/var(y))
dial2
end
