/*
 * Decompiled with CFR 0.152.
 */
package algebras;

import algebras.extensibleAlgebra;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.YIELDAlgebraParser;
import terms.symbol;
import terms.term;
import terms.variable;

public class YIELDAlgebra
extends extensibleAlgebra {
    private static String substitution = "subst";
    private static String projection = "proj-";
    private static String constant = "const-";

    protected Object apply(symbol symbol2, Object[] objectArray) {
        Object object = this.operationOf(symbol2);
        if (object == null) {
            term term2 = new term(symbol2);
            for (int i = 0; i < symbol2.rank(); ++i) {
                if (!(objectArray[i] instanceof term)) {
                    return null;
                }
                term2.defineSubterm(i, (term)objectArray[i]);
            }
            return term2;
        }
        if (object instanceof constant) {
            symbol symbol3 = ((constant)object).sym;
            term term3 = new term(symbol3);
            for (int i = 0; i < symbol3.rank(); ++i) {
                term3.defineSubterm(i, new term(new variable(i + 1)));
            }
            return term3;
        }
        if (object instanceof projectionConstant) {
            return new term(new variable(((projectionConstant)object).index));
        }
        if (object instanceof substitutionOperation) {
            if (!(objectArray[0] instanceof term)) {
                return null;
            }
            term term4 = (term)objectArray[0];
            term[] termArray = new term[objectArray.length];
            for (int i = 1; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof term)) {
                    return null;
                }
                termArray[i] = (term)objectArray[i];
            }
            return term4.substitute(termArray);
        }
        return null;
    }

    public Object extendBy(symbol symbol2) {
        if (symbol2.rank() > 0 && substitution.equals(symbol2.toString())) {
            return new substitutionOperation();
        }
        if (symbol2.rank() > 0) {
            return null;
        }
        if (symbol2.toString().startsWith(projection)) {
            int n;
            try {
                n = Integer.parseInt(symbol2.toString().substring(projection.length()));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n < 1) {
                return null;
            }
            return new projectionConstant(n);
        }
        if (symbol2.toString().startsWith(constant)) {
            int n;
            String string = symbol2.toString().substring(constant.length());
            int n2 = string.lastIndexOf(45);
            if (n2 < 0) {
                return null;
            }
            String string2 = string.substring(0, n2);
            try {
                n = Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n < 0) {
                return null;
            }
            return new constant(string2, n);
        }
        return null;
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        YIELDAlgebraParser yIELDAlgebraParser = new YIELDAlgebraParser(aSCII_CharStream);
        yIELDAlgebraParser.YIELDAlgebra(this);
    }

    private class constant {
        public symbol sym;

        public constant(String string, int n) {
            this.sym = new symbol(string, n);
        }
    }

    private class projectionConstant {
        public int index;

        public projectionConstant(int n) {
            this.index = n;
        }
    }

    private class substitutionOperation {
        private substitutionOperation() {
        }
    }
}

