/*
 * Decompiled with CFR 0.152.
 */
package algebras;

import algebras.extensibleAlgebra;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.booleanAlgebraParser;
import terms.symbol;

public class booleanAlgebra
extends extensibleAlgebra {
    private static Integer True = new Integer(0);
    private static Integer False = new Integer(1);
    private static Integer not = new Integer(2);
    private static Integer and = new Integer(3);
    private static Integer or = new Integer(4);
    private static Integer xor = new Integer(5);
    private static Integer impl = new Integer(6);
    private static Boolean t = new Boolean(true);
    private static Boolean f = new Boolean(false);

    public Object extendBy(symbol symbol2) {
        if ("true".equalsIgnoreCase(symbol2.toString()) && symbol2.rank() == 0) {
            return True;
        }
        if ("false".equalsIgnoreCase(symbol2.toString()) && symbol2.rank() == 0) {
            return False;
        }
        if ("not".equalsIgnoreCase(symbol2.toString()) && symbol2.rank() == 1) {
            return not;
        }
        if ("implies".equals(symbol2.toString()) && symbol2.rank() == 2) {
            return impl;
        }
        if ("and".equalsIgnoreCase(symbol2.toString())) {
            return and;
        }
        if ("or".equalsIgnoreCase(symbol2.toString())) {
            return or;
        }
        if ("xor".equalsIgnoreCase(symbol2.toString())) {
            return xor;
        }
        return null;
    }

    protected Object apply(symbol symbol2, Object[] objectArray) {
        int n;
        Object object = this.operationOf(symbol2);
        if (True.equals(object)) {
            return t;
        }
        if (False.equals(object)) {
            return f;
        }
        boolean[] blArray = new boolean[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            if (!(objectArray[n] instanceof Boolean)) {
                return null;
            }
            blArray[n] = (Boolean)objectArray[n];
        }
        if (not.equals(object)) {
            if (blArray[0]) {
                return f;
            }
            return t;
        }
        if (and.equals(object)) {
            for (n = 0; n < blArray.length; ++n) {
                if (blArray[n]) continue;
                return f;
            }
            return t;
        }
        if (or.equals(object)) {
            for (n = 0; n < blArray.length; ++n) {
                if (!blArray[n]) continue;
                return t;
            }
            return f;
        }
        if (xor.equals(object)) {
            n = 0;
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                n = n == 0 ? 1 : 0;
            }
            if (n != 0) {
                return t;
            }
            return f;
        }
        if (impl.equals(object)) {
            if (blArray[0] && !blArray[1]) {
                return f;
            }
            return t;
        }
        return null;
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        booleanAlgebraParser booleanAlgebraParser2 = new booleanAlgebraParser(aSCII_CharStream);
        booleanAlgebraParser2.booleanAlgebra(this);
    }
}

