/*
 * Decompiled with CFR 0.152.
 */
package applications.collages;

import applications.collages.collage;
import applications.collages.collageAlgebra;
import applications.collages.collageOperation;
import applications.collages.part;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.gridAlgebraParser;
import terms.symbol;

public class gridAlgebra
extends collageAlgebra {
    private int gridSize;
    private static float squareSize = 20.0f;
    public static String squareName = "sq";
    private static GeneralPath sqPath = new GeneralPath(new Rectangle2D.Float(-squareSize, -squareSize, 2.0f * squareSize, 2.0f * squareSize));
    private static part square = new part(0, sqPath);
    private static float dark = 0.39215687f;
    private static float light = 0.78431374f;
    private static collage greySquare = new collage();
    private static collage frame;
    private static collage unknownConstant;
    private static collage sq;

    public void setGridSize(int n) {
        this.gridSize = n;
    }

    protected Object extendBy(symbol symbol2) {
        Object object = this.decodeOp(symbol2.toString());
        int n = object == null || object instanceof collage ? 0 : ((collageOperation)object).arity();
        if (object == null || n != symbol2.rank()) {
            if (symbol2.rank() == 1) {
                Object[] objectArray = new AffineTransform[]{new AffineTransform()};
                return new collageOperation(objectArray);
            }
            if (symbol2.rank() == 0) {
                return unknownConstant;
            }
        }
        if (n != symbol2.rank()) {
            return null;
        }
        return object;
    }

    public Object decodeOp(String string) {
        Object object;
        if (squareName.equals(string)) {
            return sq;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') {
                bl = true;
                continue;
            }
            if (string.charAt(i) == '-') {
                bl = false;
                continue;
            }
            if (!bl) continue;
            stringBuffer.insert(i + 1, '-');
            bl = false;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(stringBuffer.toString()));
        streamTokenizer.resetSyntax();
        streamTokenizer.parseNumbers();
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.wordChars(97, 100);
        streamTokenizer.lowerCaseMode(true);
        streamTokenizer.whitespaceChars(45, 45);
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        try {
            while (streamTokenizer.nextToken() != -1) {
                object = null;
                if (streamTokenizer.ttype == -2) {
                    n = (int)streamTokenizer.nval;
                    if (streamTokenizer.nextToken() == -3) {
                        object = this.transformation(n, streamTokenizer.sval);
                    }
                }
                if (object == null || n >= this.gridSize * this.gridSize) {
                    return null;
                }
                vector.addElement((Object[])object);
            }
        }
        catch (IOException iOException) {
            throw new InternalError("something wrong in gridAlgebra.java");
        }
        object = new AffineTransform[vector.size()];
        vector.copyInto((Object[])object);
        return new collageOperation((Object[])object);
    }

    private AffineTransform transformation(int n, String string) {
        int n2;
        double d;
        if ("ab".equals(string) || "abc".equals(string)) {
            d = 0.0;
            n2 = 1;
        } else if ("bc".equals(string) || "bcd".equals(string)) {
            d = 1.5707963267948966;
            n2 = 1;
        } else if ("cd".equals(string) || "cda".equals(string)) {
            d = Math.PI;
            n2 = 1;
        } else if ("da".equals(string) || "dab".equals(string)) {
            d = 4.71238898038469;
            n2 = 1;
        } else if ("ad".equals(string) || "adc".equals(string)) {
            d = 4.71238898038469;
            n2 = -1;
        } else if ("dc".equals(string) || "dcb".equals(string)) {
            d = Math.PI;
            n2 = -1;
        } else if ("cb".equals(string) || "cba".equals(string)) {
            d = 1.5707963267948966;
            n2 = -1;
        } else if ("ba".equals(string) || "bad".equals(string)) {
            d = 0.0;
            n2 = -1;
        } else {
            return null;
        }
        int n3 = n % this.gridSize;
        int n4 = n / this.gridSize;
        double d2 = 2.0f * squareSize / (float)this.gridSize;
        double d3 = (double)(-squareSize) + (double)n3 * d2;
        double d4 = (double)(-squareSize) + (double)n4 * d2;
        AffineTransform affineTransform = AffineTransform.getScaleInstance((double)n2 / (double)this.gridSize, 1.0 / (double)this.gridSize);
        affineTransform.preConcatenate(AffineTransform.getRotateInstance(d));
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(d3 + d2 / 2.0, d4 + d2 / 2.0));
        return affineTransform;
    }

    public static collage greySquare() {
        return (collage)greySquare.clone();
    }

    public static collage frame() {
        return (collage)frame.clone();
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        gridAlgebraParser gridAlgebraParser2 = new gridAlgebraParser(aSCII_CharStream);
        gridAlgebraParser2.gridAlgebra(this);
    }

    static {
        Cloneable cloneable = new part(0, sqPath);
        ((part)cloneable).setColour(light, light, light);
        greySquare.add((part)cloneable);
        frame = new collage();
        cloneable = new part(1, sqPath);
        ((part)cloneable).setColour(dark, dark, dark);
        frame.add((part)cloneable);
        unknownConstant = gridAlgebra.greySquare();
        unknownConstant.unionWith(gridAlgebra.frame());
        cloneable = new GeneralPath();
        ((Path2D.Float)cloneable).moveTo(-0.8f * squareSize, -0.8f * squareSize);
        ((Path2D.Float)cloneable).lineTo(0.8f * squareSize, -0.8f * squareSize);
        ((Path2D.Float)cloneable).lineTo(0.8f * squareSize, 0.8f * squareSize);
        ((Path2D.Float)cloneable).lineTo(-0.8f * squareSize, 0.8f * squareSize);
        ((Path2D.Float)cloneable).lineTo(-0.8f * squareSize, -0.8f * squareSize + squareSize / 3.0f);
        unknownConstant.add(new part(1, (GeneralPath)cloneable));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-0.8f * squareSize, -0.8f * squareSize);
        generalPath.lineTo(-0.8f * squareSize + squareSize / 8.0f, -0.8f * squareSize + squareSize / 3.0f);
        generalPath.lineTo(-0.8f * squareSize - squareSize / 8.0f, -0.8f * squareSize + squareSize / 3.0f);
        generalPath.closePath();
        unknownConstant.add(new part(0, generalPath));
        sq = new collage();
        sq.add(square);
    }
}

