/*
 * Decompiled with CFR 0.152.
 */
package applications.collages;

import applications.collages.colourOperation;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class part
implements Cloneable {
    public static final int FILLED = 0;
    public static final int OUTLINE = 1;
    private int type;
    private GeneralPath outline;
    private Color colour = Color.black;
    private int[] rgb = null;
    private double[] attrValue = null;
    private double thickness = -1.0;
    private AffineTransform trans = new AffineTransform();

    public part(int n, GeneralPath generalPath) {
        this.type = n;
        this.outline = generalPath;
    }

    public synchronized GeneralPath getOutline() {
        if (this.trans != null) {
            this.outline = (GeneralPath)this.outline.clone();
            this.outline.transform(this.trans);
            this.trans = null;
        }
        return this.outline;
    }

    public void setOutline(GeneralPath generalPath) {
        this.trans = new AffineTransform();
        this.outline = generalPath;
    }

    public int type() {
        return this.type;
    }

    public void initAttribs(int n) {
        this.attrValue = new double[n];
        for (int i = 0; i < n; ++i) {
            this.attrValue[i] = 0.0;
        }
        this.rgb = new int[3];
    }

    public void setRgb(int n, int n2, int n3) {
        this.rgb[0] = n;
        this.rgb[1] = n2;
        this.rgb[2] = n3;
        this.colour = null;
    }

    public double[] getAllAttribs() {
        return this.attrValue;
    }

    public void setAttrib(int n, double d) {
        this.attrValue[n] = d;
    }

    public void setAllAttribs(double[] dArray) {
        this.attrValue = dArray;
    }

    public void setColour(float f, float f2, float f3) {
        this.colour = new Color(f, f2, f3);
    }

    public void setColour(float f) {
        this.colour = new Color(f, f, f);
    }

    public synchronized Color getColour() {
        if (this.colour == null) {
            try {
                this.colour = new Color(this.fold(this.rgb[0]), this.fold(this.rgb[1]), this.fold(this.rgb[2]));
                return this.colour;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.colour = new Color(0, 0, 0);
                return this.colour;
            }
        }
        return this.colour;
    }

    private float fold(int n) {
        return (float)colourOperation.fold(this.attrValue[n]);
    }

    public void setThickness(double d) {
        this.thickness = d;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void transform(AffineTransform affineTransform) {
        if (this.trans == null) {
            this.outline.transform(affineTransform);
        } else {
            this.trans.preConcatenate(affineTransform);
        }
    }

    public void changeColour(colourOperation colourOperation2) {
        if (this.attrValue != null) {
            colourOperation2.apply(this.attrValue);
            this.colour = null;
        }
    }

    public Rectangle2D.Double bounds() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        double_.setRect(this.getOutline().getBounds2D());
        return double_;
    }

    public double[] largeBounds() {
        double[] dArray = new double[4];
        dArray[1] = Double.POSITIVE_INFINITY;
        dArray[0] = Double.POSITIVE_INFINITY;
        dArray[3] = Double.NEGATIVE_INFINITY;
        dArray[2] = Double.NEGATIVE_INFINITY;
        PathIterator pathIterator = this.getOutline().getPathIterator(null);
        double[] dArray2 = new double[6];
        while (!pathIterator.isDone()) {
            int n;
            switch (pathIterator.currentSegment(dArray2)) {
                case 0: 
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            for (int i = 0; i < n; ++i) {
                if (dArray2[2 * i] < dArray[0]) {
                    dArray[0] = dArray2[2 * i];
                }
                if (dArray2[2 * i + 1] < dArray[1]) {
                    dArray[1] = dArray2[2 * i + 1];
                }
                if (dArray2[2 * i] > dArray[2]) {
                    dArray[2] = dArray2[2 * i];
                }
                if (!(dArray2[2 * i + 1] > dArray[3])) continue;
                dArray[3] = dArray2[2 * i + 1];
            }
            pathIterator.next();
        }
        return dArray;
    }

    public synchronized Object clone() {
        try {
            part part2 = (part)super.clone();
            if (this.rgb != null) {
                part2.rgb = (int[])this.rgb.clone();
                part2.attrValue = (double[])this.attrValue.clone();
            }
            if (this.trans == null) {
                this.trans = new AffineTransform();
            } else {
                part2.trans = (AffineTransform)this.trans.clone();
            }
            return part2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

