/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.nodeTypes.worksheetNode;
import gui.worksheet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.metal.MetalIconFactory;
import util.comp;
import util.list;

public class commandPanel
extends Box
implements ActionListener {
    private static final long serialVersionUID = 4041136588066740406L;
    private list currentCommands = new list();
    private worksheetNode notify;
    private JPanel cPanel = new JPanel(new GridLayout(0, 1, 0, 0));

    public commandPanel(worksheetNode notify) {
        super(1);
        this.setBorder(new EtchedBorder());
        JPanel nameBox = new JPanel(new BorderLayout());
        JLabel name = new JLabel(notify.getName(), 0);
        name.setBorder(new EtchedBorder());
        nameBox.add((Component)name, "West");
        JButton b = new JButton(new MetalIconFactory.PaletteCloseIcon());
        b.addActionListener(this);
        nameBox.add((Component)b, "East");
        this.add(nameBox);
        this.add(this.cPanel);
        this.notify = notify;
    }

    public void actionPerformed(ActionEvent e) {
        worksheet.tabs.removeTab(this);
    }

    public void setCommands(list commands) {
        if (!comp.compare(this.currentCommands, commands)) {
            this.currentCommands = (list)commands.clone();
            this.cPanel.removeAll();
            while (!commands.isEmpty()) {
                Panel row = new Panel();
                row.setLayout(new GridLayout(1, 0));
                this.cPanel.add(row);
                String[] command = (String[])commands.head();
                int i = 0;
                while (i < command.length) {
                    Button button = new Button(command[i]);
                    button.addActionListener(this.notify);
                    row.add(button);
                    ++i;
                }
                commands = commands.tail();
            }
            if (worksheet.tabs.isShowing() && worksheet.tabs.isShown(this)) {
                worksheet.tabs.pack();
            }
        }
    }

    public void dispose() {
        this.notify = null;
        worksheet.tabs.removeTab(this);
    }
}

