/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.componentGraph;
import gui.editor;
import gui.tbApplet;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class worksheet
extends JFrame
implements ActionListener,
MouseListener {
    public static commandTabs tabs;
    private static final long serialVersionUID = -6215999136996319169L;
    private static String versionNumber;
    private static String load;
    private static String add;
    private static String save;
    private static String deleteAll;
    private static String quit;
    private static String addComp;
    private static String createComp;
    private static String[] worksheetCommands;
    private static String[] componentCommands;
    private componentGraph graph;
    private PopupMenu popup = new PopupMenu();
    private Point popedUpAt;
    private worksheetPanel panel;
    private tbApplet parent;

    static {
        versionNumber = "1.6";
        load = "Load...";
        add = "Add...";
        save = "Save...";
        deleteAll = "clear";
        quit = "quit";
        addComp = "add component...";
        createComp = "create component...";
        String[] stringArray = new String[6];
        stringArray[0] = load;
        stringArray[1] = add;
        stringArray[2] = save;
        stringArray[3] = deleteAll;
        stringArray[5] = quit;
        worksheetCommands = stringArray;
        componentCommands = new String[]{addComp, createComp};
    }

    public worksheet(tbApplet app, String fileName) {
        super("TREEBAG " + versionNumber + " worksheet");
        this.parent = app;
        tabs = new commandTabs(this);
        this.setDefaultCloseOperation(0);
        this.enableEvents(64L);
        this.graph = new componentGraph();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridwidth = 0;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        layout.setConstraints(this.graph, constraints);
        constraints.fill = 2;
        constraints.weighty = 0.0;
        this.panel = new worksheetPanel();
        layout.setConstraints(this.panel, constraints);
        this.pane().setLayout(layout);
        this.pane().add(this.graph);
        this.pane().add(this.panel);
        this.pane().add(this.popup);
        this.graph.addMouseListener(this);
        this.initMenus();
        this.pack();
        this.setVisible(true);
        if (fileName != null) {
            this.graph.addConfig(true, this.absolutePath(fileName), this);
        }
    }

    private String absolutePath(String fileName) {
        if (this.parent != null) {
            return this.parent.absolutePath(fileName);
        }
        return new File(fileName).getAbsolutePath();
    }

    private Container pane() {
        return this.getContentPane();
    }

    private void initMenus() {
        JMenuItem item;
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("Worksheet", true);
        int i = 0;
        while (i < worksheetCommands.length) {
            if (worksheetCommands[i] == null) {
                menu.addSeparator();
                this.popup.addSeparator();
            } else {
                item = new JMenuItem(worksheetCommands[i]);
                item.addActionListener(this);
                menu.add(item);
                this.popup.add(new MenuItem(worksheetCommands[i]));
            }
            ++i;
        }
        bar.add(menu);
        this.popup.addSeparator();
        this.popup.addSeparator();
        menu = new JMenu("Component", true);
        i = 0;
        while (i < componentCommands.length) {
            if (worksheetCommands[i] == null) {
                menu.addSeparator();
                this.popup.addSeparator();
            } else {
                item = new JMenuItem(componentCommands[i]);
                item.addActionListener(this);
                menu.add(item);
                this.popup.add(new MenuItem(componentCommands[i]));
            }
            ++i;
        }
        bar.add(menu);
        this.setJMenuBar(bar);
        this.popup.addActionListener(this);
        bar.setVisible(true);
    }

    public void setReadMe(String text) {
        this.panel.setReadMe(text);
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && this.graph.confirm()) {
            this.exit();
        }
    }

    private void exit() {
        if (this.parent != null) {
            this.parent.destroy();
        } else {
            System.exit(0);
        }
    }

    public void dispose() {
        this.graph.clear();
        super.dispose();
        if (tabs != null) {
            tabs.dispose();
            tabs = null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if (quit.equals(com) && this.graph.confirm()) {
            this.exit();
        } else if (deleteAll.equals(com)) {
            this.graph.clear();
            this.panel.setReadMe(null);
        } else if (addComp.equals(com)) {
            if (e.getSource() == this.popup) {
                this.graph.newNode(this.popedUpAt);
            } else {
                this.graph.newNode(new Point(this.graph.getSize().width / 2, this.graph.getSize().height / 2));
            }
        } else if (createComp.equals(com)) {
            if (e.getSource() == this.popup) {
                new editor(this.popedUpAt, this.graph);
            } else {
                new editor(new Point(this.graph.getSize().width / 2, this.graph.getSize().height / 2), this.graph);
            }
        } else if (save.equals(com)) {
            this.graph.saveConfig();
        } else if (add.equals(com) || load.equals(com)) {
            this.graph.addConfig(load.equals(com), this);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.popedUpAt = e.getPoint();
        if (e.isAltDown() || e.isMetaDown()) {
            this.popup.show(this.graph, this.popedUpAt.x, this.popedUpAt.y);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            new worksheet(null, null);
        } else {
            new worksheet(null, args[0]);
        }
    }

    private class worksheetPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 4784246388249456854L;
        private JTextField progress;
        private GridBagLayout grid = new GridBagLayout();
        private GridBagConstraints constr = new GridBagConstraints();
        private Button readmeButton = new Button("ReadMe");
        private boolean readMeAvailable = false;
        private JFrame readMeFrame = null;
        private int cols;
        private int rows;

        public worksheetPanel() {
            this.setLayout(this.grid);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.progress = new JTextField();
            this.progress.setEditable(false);
            this.constr.insets = new Insets(6, 6, 6, 6);
            this.constr.weightx = 1.0;
            this.constr.anchor = 17;
            this.grid.setConstraints(this.progress, this.constr);
            this.add(this.progress);
            worksheet.this.graph.setProgressField(this.progress);
            this.constr.anchor = 13;
            this.grid.setConstraints(this.readmeButton, this.constr);
            this.readmeButton.addActionListener(this);
        }

        private void size(String s) {
            int tmpCols = 0;
            this.cols = 1;
            this.rows = 1;
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) != '\n') {
                    if (++tmpCols > this.cols) {
                        this.cols = tmpCols;
                    }
                } else {
                    ++this.rows;
                    tmpCols = 0;
                }
                ++i;
            }
        }

        public void setReadMe(String readMe) {
            if (this.readMeAvailable) {
                this.remove(this.readmeButton);
                this.readMeFrame.dispose();
            }
            boolean bl = this.readMeAvailable = readMe != null;
            if (this.readMeAvailable) {
                this.readMeFrame = new JFrame("ReadMe");
                this.size(readMe);
                JTextArea text = new JTextArea(readMe, this.rows + 1, this.cols * 2 / 3);
                text.setLineWrap(true);
                text.setWrapStyleWord(true);
                text.setEditable(false);
                text.setMargin(new Insets(5, 7, 5, 7));
                this.readMeFrame.getContentPane().add(new JScrollPane(text));
                this.readMeFrame.pack();
                this.add(this.readmeButton);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.readMeFrame.show();
        }

        public void dispose() {
            if (this.readMeAvailable) {
                this.readMeFrame.dispose();
            }
            worksheet.this.panel.dispose();
        }
    }

    public class commandTabs
    extends JFrame {
        private static final long serialVersionUID = 3239816098138206611L;
        private Vector shownComponents = new Vector(5);
        private boolean unused = true;
        private worksheet myWorksheet;

        public commandTabs(worksheet ws) {
            super("Control panes");
            this.myWorksheet = ws;
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        }

        public void addTab(String name, JComponent c) {
            this.getContentPane().add(Box.createVerticalStrut(10));
            this.shownComponents.add(c);
            this.getContentPane().add(c);
            if (this.shownComponents.size() == 1 && this.unused) {
                this.unused = false;
                Point loc = this.myWorksheet.getLocationOnScreen();
                Dimension size = this.myWorksheet.getSize();
                this.setLocation(loc.x + size.width, loc.y);
            }
            this.pack();
            this.setVisible(true);
        }

        public boolean isShown(JComponent c) {
            return this.shownComponents.contains(c);
        }

        public void removeTab(JComponent c) {
            int i = this.shownComponents.indexOf(c);
            if (i >= 0) {
                this.shownComponents.remove(i);
                this.getContentPane().remove(2 * i + 1);
                this.getContentPane().remove(2 * i);
                this.pack();
                if (this.shownComponents.size() == 0) {
                    this.setVisible(false);
                }
            }
        }
    }
}

