/*
 * Decompiled with CFR 0.152.
 */
package parsers;

import java.io.InputStream;
import java.io.Reader;
import java.util.BitSet;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.Token;
import parsers.nameParser;
import parsers.tTdTransducerParserConstants;
import parsers.tTdTransducerParserTokenManager;
import parsers.termParser;
import parsers.trsParser;
import terms.finiteSignature;
import terms.fixedRankSignature;
import terms.symbol;
import terms.term;
import terms.variable;

public class tTdTransducerParser
implements tTdTransducerParserConstants {
    private ASCII_CharStream inputStream = null;
    private termParser terms;
    protected rulesParser rules;
    public Vector tables = new Vector(5);
    public Vector weights = new Vector(5);
    public fixedRankSignature states;
    public finiteSignature in;
    public finiteSignature out;
    public symbol initial;
    public term exprTerm;
    public tTdTransducerParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[1];
    private final int[] jj_la1_0 = new int[]{1024};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public tTdTransducerParser(ASCII_CharStream aSCII_CharStream) {
        this(new tTdTransducerParserTokenManager(aSCII_CharStream));
        this.rules = new rulesParser(aSCII_CharStream);
        this.terms = new termParser(aSCII_CharStream);
        this.inputStream = aSCII_CharStream;
    }

    protected void verifyRule(term term2, term term3) throws ParseException {
        BitSet bitSet = new BitSet();
        if (!this.getVariables(term2, bitSet)) {
            throw new ParseException("Rule not left-linear");
        }
        this.verifyVariables(term3, bitSet);
        this.verifyLhs(term2);
        this.verifyRhs(term3);
    }

    private boolean getVariables(term term2, BitSet bitSet) {
        symbol symbol2 = term2.topSymbol();
        if (symbol2 instanceof variable) {
            if (bitSet.get(((variable)symbol2).index())) {
                return false;
            }
            bitSet.set(((variable)symbol2).index());
            return true;
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            if (this.getVariables(term2.subterm(i), bitSet)) continue;
            return false;
        }
        return true;
    }

    private void verifyVariables(term term2, BitSet bitSet) throws ParseException {
        symbol symbol2 = term2.topSymbol();
        if (symbol2 instanceof variable && !bitSet.get(((variable)symbol2).index())) {
            throw new ParseException("Variable " + symbol2.toString() + " appears in rhs but not in lhs");
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            this.verifyVariables(term2.subterm(i), bitSet);
        }
    }

    private void verifyLhs(term term2) throws ParseException {
        symbol symbol2 = term2.topSymbol();
        if (!this.states.contains(symbol2)) {
            throw new ParseException("Topmost symbol " + symbol2 + " of left-hand side not a state");
        }
        symbol2 = (term2 = term2.subterm(0)).topSymbol();
        if (!this.in.contains(symbol2)) {
            throw new ParseException("Symbol " + symbol2 + " of rank " + symbol2.rank() + " in left-hand side not in input signature");
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            symbol2 = term2.subterm(i).topSymbol();
            if (symbol2 instanceof variable) continue;
            throw new ParseException("Symbol " + symbol2.toString() + " in left-hand side not a variable");
        }
    }

    private void verifyRhs(term term2) throws ParseException {
        symbol symbol2 = term2.topSymbol();
        if (!this.out.contains(symbol2)) {
            if (this.states.contains(symbol2)) {
                symbol2 = term2.subterm(0).topSymbol();
                if (symbol2 instanceof variable) {
                    return;
                }
                throw new ParseException("Symbol " + symbol2 + " in right-hand side must be a variable");
            }
            throw new ParseException("Symbol " + symbol2 + " of rank " + symbol2.rank() + " in right-hand side is neither an output symbol nor a state");
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            this.verifyRhs(term2.subterm(i));
        }
    }

    public final void tTdTransducer() throws ParseException {
        this.jj_consume_token(6);
        this.in = new finiteSignature();
        this.in.parse(this.inputStream);
        this.jj_consume_token(10);
        this.out = new finiteSignature();
        this.out.parse(this.inputStream);
        this.jj_consume_token(10);
        this.states = new fixedRankSignature(1);
        this.states.parse(this.inputStream);
        if (!this.states.disjointWith(this.in) || !this.states.disjointWith(this.out)) {
            throw new ParseException("set of states must be disjoint with input and output signatures");
        }
        this.jj_consume_token(10);
        this.jj_consume_token(8);
        this.tables.addElement(new term[0][]);
        this.weights.addElement(new double[0]);
        this.rules.rules();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(10);
            this.tables.addElement(new term[0][]);
            this.weights.addElement(new double[0]);
            this.rules.rules();
        }
        this.jj_consume_token(9);
        this.jj_consume_token(10);
        this.exprTerm = this.terms.term();
        this.jj_consume_token(10);
        nameParser nameParser2 = new nameParser(this.inputStream);
        this.initial = new symbol(nameParser2.name(), 1);
        if (!this.states.contains(this.initial)) {
            throw new ParseException("initial state not an element of the state set");
        }
    }

    public tTdTransducerParser(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new tTdTransducerParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public tTdTransducerParser(Reader reader) {
        this.jj_input_stream = new ASCII_CharStream(reader, 1, 1);
        this.token_source = new tTdTransducerParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public tTdTransducerParser(tTdTransducerParserTokenManager tTdTransducerParserTokenManager2) {
        this.token_source = tTdTransducerParserTokenManager2;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(tTdTransducerParserTokenManager tTdTransducerParserTokenManager2) {
        this.token_source = tTdTransducerParserTokenManager2;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[11];
        for (n2 = 0; n2 < 11; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 1; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((this.jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 11; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tTdTransducerParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private class rulesParser
    extends trsParser {
        public rulesParser(ASCII_CharStream aSCII_CharStream) {
            super(aSCII_CharStream);
        }

        protected void insertRule(term term2, term term3, double d) throws ParseException {
            tTdTransducerParser.this.verifyRule(term2, term3);
            term[][] termArray = (term[][])tTdTransducerParser.this.tables.elementAt(tTdTransducerParser.this.tables.size() - 1);
            term[][] termArrayArray = new term[termArray.length + 1][];
            System.arraycopy(termArray, 0, termArrayArray, 0, termArray.length);
            termArrayArray[termArray.length] = new term[2];
            termArrayArray[termArray.length][0] = term2;
            termArrayArray[termArray.length][1] = term3;
            tTdTransducerParser.this.tables.setElementAt(termArrayArray, tTdTransducerParser.this.tables.size() - 1);
            double[] dArray = (double[])tTdTransducerParser.this.weights.elementAt(tTdTransducerParser.this.weights.size() - 1);
            double[] dArray2 = new double[dArray.length + 1];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            dArray2[dArray.length] = d;
            tTdTransducerParser.this.weights.setElementAt(dArray2, tTdTransducerParser.this.weights.size() - 1);
        }
    }
}

