/*
 * Decompiled with CFR 0.152.
 */
package displays;

import displays.display;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import parsers.ASCII_CharStream;
import parsers.PSDisplayParser;
import parsers.ParseException;
import util.list;

public abstract class PSDisplay
extends display {
    private static String stop = "no ps-output";
    private static String resume = "ps-output";
    private static String reset = "reset ps-output";
    private boolean outputRunning = false;
    private double currentRed;
    private double currentGreen;
    private double currentBlue;
    private int currentCap;
    private double currentWidth;
    protected double lineWidth;
    protected int lineCap = 1;
    protected int lineJoin = 0;
    private boolean PSOutput = false;
    private String dirName;
    private String[] fileName;
    private RandomAccessFile file = null;
    private int number = 0;
    private static int fileOffset = 160;
    private static byte[] blanks = new byte[fileOffset];

    public PSDisplay() {
        for (int i = 0; i < fileOffset; ++i) {
            PSDisplay.blanks[i] = 32;
        }
    }

    public list commands() {
        list list2 = new list();
        if (this.PSOutput) {
            String[] stringArray = new String[]{this.outputRunning ? stop : resume, reset};
            list2.append(stringArray);
        }
        return list2;
    }

    public void execute(String string) {
        if (stop.equals(string)) {
            this.outputRunning = false;
        } else if (resume.equals(string)) {
            this.outputRunning = true;
            this.writePSFile();
        } else if (reset.equals(string)) {
            this.number = 0;
        }
    }

    private String composeName() {
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i < this.fileName.length - 1; ++i) {
            stringBuffer.append(this.fileName[i]);
            stringBuffer.append(this.number);
        }
        stringBuffer.append(this.fileName[this.fileName.length - 1]);
        return stringBuffer.toString();
    }

    protected abstract void PSOutput();

    protected boolean PSOutputPossible() {
        return this.PSOutput;
    }

    private void writePSFile() {
        if (this.PSOutput && this.outputRunning && this.PSOutputPossible()) {
            try {
                ++this.number;
                File file = new File(this.dirName + File.separator + this.composeName());
                file.delete();
                this.file = new RandomAccessFile(file, "rw");
                this.file.write(blanks);
            }
            catch (IOException iOException) {
                System.err.println("Error: could not open file " + this.dirName + File.separator + this.composeName() + " (" + iOException + ")");
            }
            catch (SecurityException securityException) {
                System.err.println("Error: could not open file " + this.dirName + File.separator + this.composeName() + " (" + securityException + ")");
            }
            this.PSDefinitions();
            this.PSOutput();
            if (this.file != null) {
                try {
                    this.file.close();
                    this.file = null;
                }
                catch (IOException iOException) {
                    System.err.println("Error: could not close file " + this.dirName + File.separator + this.composeName() + " (" + iOException + ")");
                }
            }
        }
    }

    private final void PSDefinitions() {
        this.PSDouble(this.lineWidth);
        this.PSWrite(" setlinewidth 0 setcolor " + this.lineCap + " setlinecap " + this.lineJoin + " setlinejoin true setstrokeadjust\n");
        this.currentRed = 0.0;
        this.currentGreen = 0.0;
        this.currentBlue = 0.0;
        this.currentCap = this.lineCap;
        this.currentWidth = -1.0;
    }

    public final void PSSetColour(double d, double d2, double d3) {
        if (this.currentRed != d || this.currentGreen != d2 || this.currentBlue != d3) {
            this.currentRed = d;
            this.currentGreen = d2;
            this.currentBlue = d3;
            this.PSDouble(d);
            this.PSWrite(" ");
            this.PSDouble(d2);
            this.PSWrite(" ");
            this.PSDouble(d3);
            this.PSWrite(" setrgbcolor\n");
        }
    }

    private final void PSSetCap(int n) {
        if (this.currentCap != n) {
            this.currentCap = n;
            this.PSWrite(n + " setlinecap\n");
        }
    }

    private final void PSSetWidth(double d) {
        if (this.currentWidth != d) {
            this.currentWidth = d;
            if (d == -1.0) {
                this.PSDouble(this.lineWidth);
            } else {
                this.PSCoord(d);
            }
            this.PSWrite(" setlinewidth\n");
        }
    }

    public void PSSetbbox(double d, double d2, double d3, double d4) {
        this.PSWrite("{ ");
        this.PSCoords(d, d2);
        this.PSWrite(" ");
        this.PSCoords(d3, d4);
        this.PSWrite(" setbbox\n");
    }

    public void PSMoveto(double d, double d2) {
        this.PSWrite("  ");
        this.PSCoords(d, d2);
        this.PSWrite(" moveto\n");
    }

    public void PSStartLongPath() {
        this.PSWrite("newpath\n");
    }

    public void PSNextPointOfPath(double d, double d2) {
        this.PSWrite("  ");
        this.PSCoords(d, d2);
        this.PSWrite(" lineto\n");
    }

    public void PSNextBezierSegment(double d, double d2, double d3, double d4, double d5, double d6) {
        this.PSCoords(d, d2);
        this.PSWrite("  ");
        this.PSCoords(d3, d4);
        this.PSWrite("  ");
        this.PSCoords(d5, d6);
        this.PSWrite("  ");
        this.PSWrite(" curveto\n");
    }

    public void PSClosePath() {
        this.PSWrite("  closepath");
    }

    public void PSStrokePath() {
        this.PSWrite(" }\n");
        this.PSSetCap(1);
        this.PSSetWidth(-1.0);
        if (this.lineWidth == 0.0) {
            this.PSWrite("ustroke\n");
        } else {
            this.PSWrite("matrix defaultmatrix matrix currentmatrix matrix invertmatrix matrix concatmatrix ustroke\n");
        }
    }

    public void PSStrokeThickPath(double d) {
        this.PSWrite(" }\n");
        this.PSSetCap(0);
        this.PSSetWidth(d);
        this.PSWrite("ustroke\n");
    }

    public void PSFillPath() {
        this.PSWrite("} ueofill\n");
    }

    public void display(Object object) {
        super.display(object);
        if (object != null) {
            this.writePSFile();
        }
    }

    protected final void PSWrite(String string) {
        try {
            this.file.writeBytes(string);
        }
        catch (IOException iOException) {
            System.err.println("Error: could not write to file " + this.dirName + File.separator + this.composeName() + " (" + iOException + ")");
        }
    }

    protected final void PSCoords(double d, double d2) {
        this.PSCoord(d);
        this.PSWrite(" ");
        this.PSCoord(d2);
    }

    protected final void PSCoord(double d) {
        this.PSDouble(this.makeCoord(d));
    }

    private final double makeCoord(double d) {
        return 28.346456692913385 * d;
    }

    protected final void PSDouble(double d) {
        this.PSDouble(d, false);
    }

    private final void PSDouble(double d, boolean bl) {
        try {
            if (!bl) {
                if (d > 3.4028234663852886E38) {
                    this.file.writeBytes(Float.toString(Float.MAX_VALUE));
                } else if (d < -3.4028234663852886E38) {
                    this.file.writeBytes(Float.toString(-3.4028235E38f));
                } else {
                    this.file.writeBytes(Float.toString((float)d));
                }
            } else {
                if (d < 0.0) {
                    this.file.writeByte(45);
                }
                long l = Math.round(Math.abs(d * 10000.0));
                this.file.writeBytes(Long.toString(l / 10000L));
                String string = Long.toString(l %= 10000L);
                while (string.length() < 4) {
                    string = "0" + string;
                }
                int n = 4;
                while (--n >= 0 && string.charAt(n) == '0') {
                }
                if (n >= 0) {
                    this.file.writeByte(46);
                    for (int i = 0; i <= n; ++i) {
                        this.file.writeByte(string.charAt(i));
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Error: could not write to file " + this.dirName + File.separator + this.composeName() + " (" + iOException + ")");
        }
    }

    protected final void PSLine(double d, double d2, double d3, double d4) {
        try {
            this.PSCoords(d, d2);
            this.file.writeByte(32);
            this.PSCoords(d3, d4);
            this.file.writeBytes(" line\n");
        }
        catch (IOException iOException) {
            System.err.println("Error: could not write to file " + this.dirName + File.separator + this.composeName() + " (" + iOException + ")");
        }
    }

    protected final void PSPreamble(double d, double d2, double d3, double d4) {
        try {
            this.file.seek(0L);
            this.file.writeBytes("%!PS-Adobe-2.0\n");
            this.file.writeBytes("%%Creator: TREEBAG\n");
            this.file.writeBytes("%%BoundingBox: ");
            this.PSDouble(this.makeCoord(d), true);
            this.file.writeByte(32);
            this.PSDouble(this.makeCoord(d2), true);
            this.file.writeByte(32);
            this.PSDouble(this.makeCoord(d3), true);
            this.file.writeByte(32);
            this.PSDouble(this.makeCoord(d4), true);
            this.file.writeBytes("\n%%EndComments");
            this.file.seek(fileOffset - 1);
            this.file.writeByte(10);
        }
        catch (IOException iOException) {
            System.err.println("Error: could not write to file " + this.dirName + File.separator + this.composeName() + " (" + iOException + ")");
        }
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        PSDisplayParser pSDisplayParser = new PSDisplayParser(aSCII_CharStream);
        this.PSOutput = pSDisplayParser.initialize();
        if (pSDisplayParser.background != null) {
            this.visualizer().setBackground(pSDisplayParser.background);
        }
        if (this.PSOutput) {
            this.lineWidth = pSDisplayParser.lineWidth;
            this.dirName = pSDisplayParser.dirName.toString();
            this.fileName = new String[pSDisplayParser.fileName.length];
            for (int i = 0; i < pSDisplayParser.fileName.length; ++i) {
                this.fileName[i] = pSDisplayParser.fileName[i].toString();
            }
        }
    }
}

