/*
 * Decompiled with CFR 0.152.
 */
package generators;

import generators.SuperTable;
import generators.SyncedRule;
import generators.YIELDTransduction;
import generators.regularTreeGrammar;
import generators.rexp;
import generators.tdTransducer;
import generators.treeGrammar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.BSTGrammarParser;
import parsers.ParseException;
import parsers.objectParser;
import terms.finiteSignature;
import terms.fixedRankSignature;
import terms.symbol;
import terms.synchronizedSymbol;
import terms.term;
import util.ExitException;
import util.list;

public class BSTGrammar
extends treeGrammar {
    regularTreeGrammar gram;
    tdTransducer[] trans;
    tdTransducer lastTransWhenUsingYield;
    private YIELDTransduction yieldTransducer;
    private static String nontermSuffix = "";
    private static boolean debugGiveSyncTreesAsOutputToo = false;
    private boolean useImplicitRule = false;
    private int translationType;
    private boolean useYieldTransducer = false;
    private static String enumerate = "table enumeration";
    private static String advance = "advance";
    private static String single = "derive stepwise";
    private static String complete = "results only";
    private static String step = "derivation step";
    private static String random = "random tables";
    private static String refine = "refine";
    private static String back = "back";
    private static String reset = "reset";
    private static String[][] eCommands = new String[][]{{advance, reset}, {random}};
    private static String[][] rCommands = new String[][]{{refine, back, reset}, {enumerate}};
    private static String[][] sCommands = new String[][]{{step, back}, {complete}};
    private static String[][] cCommands = new String[][]{{single}};
    private static String showSync = "show sync info";
    private static String hideSync = "hide sync info";
    private finiteSignature bstTermSig;
    private fixedRankSignature bstNontermSig;
    private fixedRankSignature bstSyncSymbolSig;
    private fixedRankSignature regTreeGrammarNontermSig = new fixedRankSignature(0);
    private term axiom;
    private SuperTable superTables;
    private int bstDValue;
    private int bstNValue;
    private Vector regularRules = new Vector();
    private Vector chainRules = new Vector();
    private rexp regulation = null;
    boolean nondisjoint;
    private symbol bottom = new symbol("bot", 0);
    private String initName = "init";
    private symbol init = new symbol(this.initName, 1);
    private String qname = "q__";
    private String Sname = "S__";
    private String S0name = "S0__";
    private String newAxiomName = "NEW_AXIOM";
    private String newAxiomTableName = "TBL_axiom_table_";
    private SuperTable axiomTable = null;
    private term current = null;
    private boolean recompute = true;

    private String levelCommand(int n) {
        if (n == this.bstNValue - 1) {
            return "choose new rules";
        }
        if (this.regulation == null && this.nondisjoint) {
            return "choose new supertables at depth " + (n + 1);
        }
        return "choose new supertables at depth " + (n + 2);
    }

    private int extractLevel(String string) {
        for (int i = 0; i < this.bstNValue; ++i) {
            if (!this.levelCommand(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public list commands() {
        int n;
        list list2 = super.commands();
        if (this.gram.isEnumerate) {
            for (n = 0; n < eCommands.length; ++n) {
                list2.append(eCommands[n]);
            }
            if (this.gram.isStepwise) {
                n = sCommands.length;
                while (n > 0) {
                    list2.tail().prepend(sCommands[--n]);
                }
            } else {
                n = cCommands.length;
                while (n > 0) {
                    list2.tail().prepend(cCommands[--n]);
                }
            }
        } else {
            for (n = 0; n < rCommands.length; ++n) {
                list2.append(rCommands[n]);
            }
        }
        for (n = 0; n < this.bstNValue; ++n) {
            if (n >= this.trans.length - 1 && this.trans[n].isDeterministic()) continue;
            String[] stringArray = new String[]{this.levelCommand(n)};
            list2.append(stringArray);
        }
        if (!this.useYieldTransducer) {
            String[] stringArray = new String[]{showSync};
            list2.append(stringArray);
        } else {
            String[] stringArray = new String[]{hideSync};
            list2.append(stringArray);
        }
        return list2;
    }

    public void execute(String string) {
        this.recompute = true;
        if (enumerate.equals(string)) {
            this.gram.execute("enumeration");
        } else if (advance.equals(string)) {
            this.gram.execute("advance");
            this.gram.execute("single step");
        } else if (single.equals(string)) {
            this.gram.execute("derive stepwise");
            this.gram.execute("single step");
        } else if (complete.equals(string)) {
            this.gram.execute("results only");
        } else if (step.equals(string)) {
            this.gram.execute("single step");
        } else if (random.equals(string)) {
            this.gram.execute("random generation");
            this.gram.execute("back");
            this.checkAdvance();
        } else if (refine.equals(string)) {
            this.gram.execute("refine");
        } else if (back.equals(string)) {
            this.gram.execute("back");
            this.checkAdvance();
        } else if (reset.equals(string)) {
            this.gram.execute("reset");
            if (!this.gram.isEnumerate || this.gram.isStepwise) {
                this.checkAdvance();
            }
        } else if (showSync.equals(string) || hideSync.equals(string)) {
            int n;
            this.useYieldTransducer = !this.useYieldTransducer;
            for (int i = n = this.bstNValue; i < this.trans.length; ++i) {
                this.trans[i].execute("new random seed");
            }
            this.lastTransWhenUsingYield.execute("new random seed");
        } else {
            int n = this.extractLevel(string);
            if (n != -1) {
                try {
                    for (int i = n; i < this.trans.length; ++i) {
                        this.trans[i].execute("new random seed");
                    }
                    this.lastTransWhenUsingYield.execute("new random seed");
                }
                catch (Exception exception) {
                    throw new RuntimeException("Could not execute transducers. Probably a bug in the BST implementation\n" + exception.toString());
                }
            } else {
                super.execute(string);
            }
        }
    }

    private void checkAdvance() {
        term term2 = this.gram.currentTerm();
        if (term2 != null && !term2.topSymbol().equals(this.init)) {
            if (!this.gram.isEnumerate) {
                this.gram.execute("refine");
            } else {
                this.gram.execute("single step");
            }
        }
    }

    public boolean requestsExit(String string) {
        return string.equals(advance) || string.equals(refine) || string.equals(reset);
    }

    public synchronized term currentTerm() {
        term[] termArray = new term[this.trans.length];
        if (this.recompute) {
            try {
                int n;
                this.current = this.gram.currentTerm();
                if (!this.useYieldTransducer) {
                    for (n = 0; n < this.trans.length; ++n) {
                        termArray[n] = this.current;
                        this.current = this.trans[n].apply(this.current);
                    }
                } else {
                    for (n = 0; n < this.trans.length - 1; ++n) {
                        termArray[n] = this.current;
                        this.current = this.trans[n].apply(this.current);
                    }
                    this.current = this.lastTransWhenUsingYield.apply(this.current);
                    this.current = this.yieldTransducer.apply(this.current);
                }
            }
            catch (ExitException exitException) {
                this.current = null;
                return null;
            }
            this.recompute = false;
        }
        if (debugGiveSyncTreesAsOutputToo) {
            int n;
            term term2 = this.current;
            symbol symbol2 = new symbol("Debug - All trees", this.trans.length + 1);
            this.current = new term(symbol2);
            for (n = 0; n < this.trans.length; ++n) {
                this.current.defineSubterm(n, termArray[n]);
            }
            this.current.defineSubterm(n, term2);
        }
        return this.current;
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        Object object;
        Object object2;
        BSTGrammarParser bSTGrammarParser = new BSTGrammarParser(aSCII_CharStream);
        bSTGrammarParser.BSTGrammar();
        this.bstTermSig = bSTGrammarParser.sig;
        this.bstNontermSig = bSTGrammarParser.nonterminals;
        this.bstSyncSymbolSig = bSTGrammarParser.syncSymbols;
        this.axiom = bSTGrammarParser.axiom;
        this.regulation = bSTGrammarParser.regulation;
        this.superTables = bSTGrammarParser.tables;
        this.bstDValue = bSTGrammarParser.syncSymbols.size();
        this.bstNValue = bSTGrammarParser.depth;
        this.useImplicitRule = bSTGrammarParser.implicitRules;
        this.findUniqueNames();
        if (this.useImplicitRule) {
            this.superTables.addImplicitRules(this.bstNontermSig, this.bstDValue);
        }
        if (this.axiom.topSymbol().rank() > 0 || this.bstTermSig.contains(this.axiom.topSymbol())) {
            int n;
            object2 = new synchronizedSymbol(this.newAxiomName, 0);
            object = new SyncedRule((symbol)object2, this.axiom);
            this.bstNontermSig.addSymbol((symbol)object2);
            this.axiom = new term((symbol)object2);
            if (this.bstNValue == 0) {
                this.superTables.addRule((SyncedRule)object);
            } else {
                this.axiomTable = new SuperTable();
                this.axiomTable.setName(this.newAxiomTableName);
                this.axiomTable.addRule((SyncedRule)object);
                for (n = 1; n < this.bstNValue; ++n) {
                    SuperTable superTable = new SuperTable();
                    superTable.setName(this.newAxiomTableName + "_" + n);
                    superTable.addSubTable(this.axiomTable);
                    this.axiomTable = superTable;
                }
                this.superTables.addSubTable(this.axiomTable);
            }
            if (this.regulation != null) {
                n = this.superTables.getNumTables() - 1;
                this.regulation = rexp.conc(rexp.num(n + 1), this.regulation);
            }
        }
        try {
            object2 = new finiteSignature();
            this.nondisjoint = false;
            object = this.bstTermSig.elements();
            while (object.hasMoreElements()) {
                symbol symbol2 = (symbol)object.nextElement();
                if (!this.bstNontermSig.contains(new symbol(symbol2.toString(), 0))) continue;
                this.nondisjoint = true;
                ((finiteSignature)object2).addSymbol(symbol2);
            }
            if (this.nondisjoint) {
                Object object3;
                if (this.bstNValue == 0) {
                    throw new ParseException("Currently no support for zero depth grammar with nondisjoin nonterminals and terminals.");
                }
                SuperTable superTable = this.superTables;
                if (this.regulation == null) {
                    int n = 0;
                    this.superTables = this.increaseDepthWithOneByPuttingAllInSame(this.superTables, n);
                    ++this.bstNValue;
                } else {
                    throw new ParseException("Currently no support for both regulation and nondisjoint nonterminal and terminal sets is implemented");
                }
                Object object4 = new SuperTable();
                String string = "TBL_REMOVE_SYNCINFO";
                ((SuperTable)object4).setName(string);
                Enumeration enumeration2 = ((finiteSignature)object2).elements();
                while (enumeration2.hasMoreElements()) {
                    symbol symbol3 = (symbol)enumeration2.nextElement();
                    object3 = symbol3;
                    if (!nontermSuffix.equals("")) {
                        object3 = new synchronizedSymbol(symbol3.toString() + nontermSuffix, 1);
                        this.bstNontermSig.removeSymbol(symbol3);
                        this.bstNontermSig.addSymbol((symbol)object3);
                        superTable.relabelSymbol(symbol3, (symbol)object3);
                        if (this.axiom.topSymbol().equals(symbol3)) {
                            this.axiom.relabel((symbol)object3);
                        }
                    }
                    ((SuperTable)object4).addRule(new SyncedRule((symbol)object3, new term(symbol3)));
                }
                for (int i = 1; i < this.bstNValue; ++i) {
                    object3 = new SuperTable();
                    ((SuperTable)object3).setName(string + "_" + i);
                    ((SuperTable)object3).addSubTable((SuperTable)object4);
                    object4 = object3;
                }
                this.superTables.addSubTable((SuperTable)object4);
                if (this.regulation != null) {
                    int n = this.superTables.getNumTables() - 1;
                    this.regulation = rexp.conc(this.regulation, rexp.num(n + 1));
                } else if (this.axiomTable != null) {
                    superTable.removeSubTable(this.axiomTable);
                    object4 = new SuperTable();
                    ((SuperTable)object4).setName(this.newAxiomTableName + "_" + this.bstNValue);
                    ((SuperTable)object4).addSubTable(this.axiomTable);
                    this.superTables.addSubTable((SuperTable)object4);
                    this.axiomTable = object4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Error in implementation. Unhandled exption during parsing.");
        }
        this.translationType = bSTGrammarParser.translationType;
    }

    private SuperTable increaseDepthWithOneByPuttingAllInSame(SuperTable superTable, int n) {
        SuperTable superTable2 = new SuperTable();
        superTable2.setName(superTable + "_NEW");
        superTable2.addSubTable(superTable);
        superTable.increaseLengthOfSyncSymbolTuplesWithOne(n);
        return superTable2;
    }

    private void findUniqueNames() {
        int n;
        for (n = 0; n < 10000; ++n) {
            this.qname = "q" + n;
            if (!this.bstNontermSig.contains(new symbol(this.qname, 0)) && !this.bstTermSig.contains(new symbol(this.qname, 1))) break;
        }
        for (n = 0; n < 10000; ++n) {
            this.S0name = "S" + n;
            if (!this.bstTermSig.contains(new symbol(this.S0name, 1))) break;
        }
        for (n = 0; n < 10000; ++n) {
            this.Sname = "Start" + n;
            if (!this.bstTermSig.contains(new symbol(this.Sname, 1))) break;
        }
        for (n = 0; n < 10000; ++n) {
            if (n != 0) {
                this.newAxiomName = this.newAxiomName + n;
            }
            if (!this.bstNontermSig.contains(new symbol(this.newAxiomName, 0)) && !this.bstTermSig.contains(new symbol(this.newAxiomName, 0))) break;
        }
    }

    public void translate(String string) throws ParseException {
        Object object;
        File file = new File(string + ".1");
        boolean bl = false;
        try {
            if (this.bstNValue == 0) {
                new RegularTreeGrammarGenerator().generateSolitaryTreeGrammar(this.openOutFile(file));
            } else {
                boolean bl2 = true;
                if (this.translationType == BSTGrammarParser.TYPE_PLAIN) {
                    bl2 = false;
                }
                if (this.regulation == null) {
                    new RegularTreeGrammarGenerator().generateDefaultGrammar(this.openOutFile(file), bl2);
                } else {
                    new RegularTreeGrammarGenerator().generateGrammar(this.openOutFile(file), bl2, this.regulation);
                }
                IntermediateTransducerGenerator intermediateTransducerGenerator = new IntermediateTransducerGenerator();
                for (int i = 1; i < this.bstNValue; ++i) {
                    File file2 = new File(string + "." + (i + 1));
                    if (this.translationType == BSTGrammarParser.TYPE_PLAIN) {
                        intermediateTransducerGenerator.generateIntermediateTransducerUsingPlainTranslation(this.openOutFile(file2), i);
                    }
                    if (this.translationType == BSTGrammarParser.TYPE_NORMAL) {
                        intermediateTransducerGenerator.generateIntermediateTransducerUsingNormalTranslation(this.openOutFile(file2), i);
                    }
                    if (this.translationType != BSTGrammarParser.TYPE_EXTENDED) continue;
                    intermediateTransducerGenerator.generateIntermediateTransducerUsingExtendedTranslation(this.openOutFile(file2), i);
                }
                object = new File(string + "." + (1 + this.bstNValue));
                new FinalTransducerGenerator().generateFinalTransducer(this.openOutFile((File)object), false);
                new FinalTransducerGenerator().generateFinalTransducer(this.openOutFile(new File(string + ".Y")), true);
            }
            bl = true;
        }
        catch (IOException iOException) {
            for (int i = 0; i < this.bstNValue + 1; ++i) {
                object = new File(string + "." + (i + 1));
                if (!((File)object).exists()) {
                    throw new ParseException("Could not write to output file:\n" + iOException.getMessage());
                }
                if (new File(string + ".Y").exists()) continue;
                throw new ParseException("Could not write to output file:\n" + iOException.getMessage());
            }
        }
        catch (AccessControlException accessControlException) {
            for (int i = 0; i < this.bstNValue + 1; ++i) {
                object = new File(string + "." + (i + 1));
                if (!((File)object).exists()) {
                    throw new ParseException("Could not write to output file:\n" + accessControlException.getMessage());
                }
                if (new File(string + ".Y").exists()) continue;
                throw new ParseException("Could not write to output file:\n" + accessControlException.getMessage());
            }
        }
        catch (Exception exception) {
            throw new ParseException("Error. \n" + exception.getMessage());
        }
        try {
            objectParser objectParser2 = new objectParser(new ASCII_CharStream(new FileInputStream(file), 1, 1));
            this.gram = (regularTreeGrammar)objectParser2.parse();
            this.trans = new tdTransducer[this.bstNValue];
            for (int i = 0; i < this.bstNValue; ++i) {
                object = string + "." + (i + 2);
                objectParser2 = new objectParser(new ASCII_CharStream(new FileInputStream((String)object), 1, 1));
                this.trans[i] = (tdTransducer)objectParser2.parse();
            }
            objectParser2 = new objectParser(new ASCII_CharStream(new FileInputStream(string + ".Y"), 1, 1));
            this.lastTransWhenUsingYield = (tdTransducer)objectParser2.parse();
            this.yieldTransducer = new YIELDTransduction();
        }
        catch (ParseException parseException) {
            if (bl) {
                throw new ParseException("Could not parse generated file:\n" + parseException.getMessage() + "\n[This should not happen. There must be one of those " + "small insects in the implementation 8-( ]");
            }
            throw new ParseException("Could not parse previously existing file:\n" + parseException.getMessage() + "\nPlease make sure that the file is writable to enable " + "generation of new file");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParseException("Could not open file:\n" + fileNotFoundException.getMessage());
        }
    }

    private FileWriter openOutFile(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    class FinalTransducerGenerator {
        FinalTransducerGenerator() {
        }

        private void generateFinalTransducer(FileWriter fileWriter, boolean bl) throws IOException {
            int n;
            Object object;
            Object object2;
            Vector vector;
            int n2;
            int n3 = BSTGrammar.this.bstNValue;
            Vector vector2 = BSTGrammar.this.superTables.getTablesAtDepth(n3);
            symbol symbol2 = new symbol("syncinfo", n3 + 1);
            symbol symbol3 = new symbol("-", 0);
            fileWriter.write("generators.tdTransducer:\n");
            fileWriter.write("  (\n");
            int n4 = BSTGrammar.this.bstDValue;
            int n5 = 1;
            for (int i = 0; i < n3; ++i) {
                n5 *= n4;
            }
            finiteSignature finiteSignature2 = new finiteSignature();
            finiteSignature2.addSymbol(BSTGrammar.this.bottom);
            finiteSignature2.addSymbol(BSTGrammar.this.init);
            finiteSignature finiteSignature3 = new finiteSignature();
            Object object3 = BSTGrammar.this.bstTermSig.elements();
            while (object3.hasMoreElements()) {
                finiteSignature3.addSymbol((symbol)object3.nextElement());
            }
            object3 = new fixedRankSignature(1);
            Enumeration enumeration2 = BSTGrammar.this.bstNontermSig.elements();
            while (enumeration2.hasMoreElements()) {
                ((fixedRankSignature)object3).addSymbol(((symbol)enumeration2.nextElement()).toString());
            }
            enumeration2 = BSTGrammar.this.regTreeGrammarNontermSig.elements();
            while (enumeration2.hasMoreElements()) {
                finiteSignature2.addSymbol((symbol)enumeration2.nextElement());
            }
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                vector = (SuperTable)vector2.elementAt(n2);
                finiteSignature2.addSymbol(new symbol(((SuperTable)((Object)vector)).getName(), n5));
            }
            fileWriter.write("    " + finiteSignature2 + ",\n");
            if (!bl) {
                finiteSignature3.unionWith(BSTGrammar.this.bstNontermSig);
            } else {
                Enumeration enumeration3 = BSTGrammar.this.bstNontermSig.elements();
                while (enumeration3.hasMoreElements()) {
                    finiteSignature3.addSymbol(new symbol(enumeration3.nextElement().toString(), 0));
                }
                finiteSignature3.addSymbol(symbol2);
            }
            n2 = 0;
            if (n2 != 0) {
                finiteSignature3.addSymbol(new symbol("error_no_init", 0));
            }
            if (bl) {
                vector = BSTGrammar.this.bstSyncSymbolSig.elements();
                while (vector.hasMoreElements()) {
                    finiteSignature3.addSymbol(new symbol(vector.nextElement().toString(), 1));
                }
                finiteSignature3.addSymbol(symbol3);
                finiteSignature3.addSymbol(new symbol("subst", n3 + 1));
                for (int i = 0; i < n3; ++i) {
                    finiteSignature3.addSymbol(new symbol("proj-" + (i + 1), 0));
                }
            }
            fileWriter.write("    " + finiteSignature3 + ",\n");
            ((fixedRankSignature)object3).addSymbol(BSTGrammar.this.qname);
            fileWriter.write("    " + object3 + ",\n");
            fileWriter.write("    {\n");
            vector = new Vector();
            if (bl) {
                object2 = new Vector<String>();
                object = BSTGrammar.this.bstSyncSymbolSig.elements();
                while (object.hasMoreElements()) {
                    ((Vector)object2).addElement(object.nextElement().toString());
                }
                for (int i = ((Vector)object2).size() - 1; i >= 0; --i) {
                    vector.addElement(((Vector)object2).elementAt(i));
                }
                String string = BSTGrammar.this.qname + "[" + BSTGrammar.this.init + "[x1]] -> subst[" + BSTGrammar.this.axiom + "[x1] ";
                for (n = 0; n < n3; ++n) {
                    string = string + ", -";
                }
                string = string + "]";
                fileWriter.write("      " + string + "\n    ");
            } else {
                object2 = BSTGrammar.this.qname + "[" + BSTGrammar.this.init + "[x1]] -> " + BSTGrammar.this.axiom + "[x1]";
                fileWriter.write("      " + (String)object2 + "\n    ");
            }
            for (int i = 0; i < vector2.size(); ++i) {
                object = (SuperTable)vector2.elementAt(i);
                for (int j = 0; j < ((SuperTable)object).getNumRules(); ++j) {
                    SyncedRule syncedRule = ((SuperTable)object).getRule(j);
                    fileWriter.write(",\n    ");
                    String string = bl ? syncedRule.getFinalTDRuleWithYield((SuperTable)object, n5, n4, vector) : syncedRule.getFinalTDRule((SuperTable)object, n5, n4);
                    fileWriter.write("  " + string + " weight " + syncedRule.getWeight());
                }
                fileWriter.write("\n      ");
            }
            Enumeration enumeration4 = BSTGrammar.this.bstNontermSig.elements();
            while (enumeration4.hasMoreElements()) {
                Object object4;
                fileWriter.write("\n      ");
                object = enumeration4.nextElement().toString();
                if (!bl) {
                    object4 = BSTGrammar.this.regTreeGrammarNontermSig.elements();
                    while (object4.hasMoreElements()) {
                        fileWriter.write(",\n      " + (String)object + "[" + object4.nextElement() + "] -> " + (String)object);
                    }
                    continue;
                }
                object4 = "";
                for (n = 0; n < n3; ++n) {
                    object4 = (String)object4 + "proj-" + (n + 1);
                    if (n + 1 >= n3) continue;
                    object4 = (String)object4 + ",";
                }
                Enumeration enumeration5 = BSTGrammar.this.regTreeGrammarNontermSig.elements();
                while (enumeration5.hasMoreElements()) {
                    fileWriter.write(",\n      " + (String)object + "[" + enumeration5.nextElement() + "] -> " + symbol2 + "[" + (String)object + ", " + (String)object4 + "]");
                }
            }
            if (n2 != 0) {
                try {
                    object = BSTGrammar.this.regTreeGrammarNontermSig.elements().nextElement().toString();
                    fileWriter.write(",\n   " + BSTGrammar.this.qname + "[" + (String)object + "] -> error_no_init \n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            fileWriter.write("},\n");
            fileWriter.write("    " + BSTGrammar.this.qname + "\n");
            fileWriter.write("  )");
            fileWriter.close();
        }
    }

    class IntermediateTransducerGenerator {
        IntermediateTransducerGenerator() {
        }

        protected void generateIntermediateTransducerUsingNormalTranslation(FileWriter fileWriter, int n) throws IOException {
            this.generateTransducer(fileWriter, n, true);
        }

        protected void generateIntermediateTransducerUsingPlainTranslation(FileWriter fileWriter, int n) throws IOException {
            this.generateTransducer(fileWriter, n, false);
        }

        private void generateTransducer(FileWriter fileWriter, int n, boolean bl) throws IOException {
            Object object;
            int n2;
            Object object2;
            int n3 = n;
            Vector vector = BSTGrammar.this.superTables.getTablesAtDepth(n3);
            Vector vector2 = BSTGrammar.this.superTables.getTablesAtDepth(n3 + 1);
            fileWriter.write("generators.tdTransducer:\n");
            fileWriter.write("  (\n");
            int n4 = BSTGrammar.this.bstDValue;
            int n5 = 1;
            for (int i = 0; i < n3; ++i) {
                n5 *= n4;
            }
            finiteSignature finiteSignature2 = new finiteSignature();
            finiteSignature2.addSymbol(BSTGrammar.this.bottom);
            finiteSignature2.addSymbol(BSTGrammar.this.init);
            Enumeration enumeration2 = BSTGrammar.this.regTreeGrammarNontermSig.elements();
            while (enumeration2.hasMoreElements()) {
                finiteSignature2.addSymbol(new symbol(enumeration2.nextElement().toString(), 0));
            }
            for (int i = 0; i < vector.size(); ++i) {
                object2 = (SuperTable)vector.elementAt(i);
                finiteSignature2.addSymbol(new symbol(((SuperTable)object2).getName(), n5));
            }
            fileWriter.write("    " + finiteSignature2 + ",\n");
            finiteSignature finiteSignature3 = new finiteSignature();
            finiteSignature3.addSymbol(BSTGrammar.this.bottom);
            finiteSignature3.addSymbol(BSTGrammar.this.init);
            object2 = BSTGrammar.this.regTreeGrammarNontermSig.elements();
            while (object2.hasMoreElements()) {
                finiteSignature3.addSymbol(new symbol(object2.nextElement().toString(), 0));
            }
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                SuperTable superTable = (SuperTable)vector2.elementAt(n2);
                finiteSignature3.addSymbol(new symbol(superTable.getName(), n5 * n4));
            }
            fileWriter.write("    " + finiteSignature3 + ",\n");
            fileWriter.write("    {" + BSTGrammar.this.qname + "}" + ",\n");
            fileWriter.write("    {\n");
            fileWriter.write("      " + BSTGrammar.this.qname + "[init[x1]] -> init[" + BSTGrammar.this.qname + "[x1]],\n");
            n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                object = (SuperTable)vector.elementAt(i);
                for (int j = 0; j < ((SuperTable)object).getNumTables(); ++j) {
                    int n6;
                    SuperTable superTable = ((SuperTable)object).getSubTable(j);
                    String string = "";
                    String string2 = "";
                    Vector vector3 = superTable.getUsedSyncBranchNumbersForSyncLevel(n4, n3 + 1);
                    for (n6 = 0; n6 < n5; ++n6) {
                        string2 = string2 + "x" + (n6 + 1);
                        if (n6 + 1 >= n5) continue;
                        string2 = string2 + ",";
                    }
                    if (BSTGrammar.this.translationType == BSTGrammarParser.TYPE_PLAIN) {
                        n2 = 1;
                    } else if (vector3.size() > 0 && superTable.isTerminable(BSTGrammar.this.bstTermSig, BSTGrammar.this.bstNontermSig)) {
                        n2 = 1;
                    }
                    for (n6 = 0; n6 < n5 * n4; ++n6) {
                        string = !bl || vector3.contains(new Integer(n6)) ? string + BSTGrammar.this.qname + "[x" + (1 + n6 / n4) + "]" : string + BSTGrammar.this.bottom;
                        if (n6 >= n5 * n4 - 1) continue;
                        string = string + ",";
                    }
                    String string3 = string2;
                    String string4 = string;
                    fileWriter.write("      " + BSTGrammar.this.qname + "[" + ((SuperTable)object).getName() + "[" + string3 + "]] -> " + superTable.getName() + "[" + string4 + "] weight " + superTable.getWeight());
                    if (j + 1 < ((SuperTable)object).getNumTables()) {
                        fileWriter.write(",\n");
                        continue;
                    }
                    fileWriter.write("\n");
                }
                if (i + 1 < vector.size()) {
                    fileWriter.write(",\n");
                    continue;
                }
                fileWriter.write("\n");
            }
            fileWriter.write("    ,\n");
            if (n2 != 0) {
                fileWriter.write("    " + BSTGrammar.this.qname + "[" + BSTGrammar.this.bottom + "] -> " + BSTGrammar.this.bottom + ",\n");
            }
            Enumeration enumeration3 = BSTGrammar.this.regTreeGrammarNontermSig.elements();
            while (enumeration3.hasMoreElements()) {
                object = enumeration3.nextElement().toString();
                fileWriter.write("    " + BSTGrammar.this.qname + "[" + (String)object + "] -> " + (String)object + ",\n");
            }
            fileWriter.write("      " + BSTGrammar.this.qname + "[init[x1]] -> init[" + BSTGrammar.this.qname + "[x1]]\n");
            fileWriter.write("    },\n");
            fileWriter.write("    " + BSTGrammar.this.qname + "\n");
            fileWriter.write("  )");
            fileWriter.close();
        }

        public Vector powerSet(finiteSignature finiteSignature2) {
            Enumeration enumeration2 = finiteSignature2.elements();
            Vector<Object> vector = new Vector<Object>();
            if (!enumeration2.hasMoreElements()) {
                vector.add(new finiteSignature());
                return vector;
            }
            Object e = enumeration2.nextElement();
            finiteSignature finiteSignature3 = new finiteSignature();
            while (enumeration2.hasMoreElements()) {
                finiteSignature3.addSymbol((symbol)enumeration2.nextElement());
            }
            Vector vector2 = this.powerSet(finiteSignature3);
            Iterator iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                finiteSignature finiteSignature4 = (finiteSignature)iterator2.next();
                Object object = finiteSignature4.clone();
                finiteSignature4.addSymbol((symbol)e);
                vector.add(finiteSignature4);
                vector.add(object);
            }
            return vector;
        }

        public Vector findSmartSubsetForStateSignature(Vector vector, String string, Vector vector2, Vector vector3, int n) {
            int n2 = BSTGrammar.this.bstDValue;
            int n3 = 1;
            for (int i = 0; i < n; ++i) {
                n3 *= n2;
            }
            Enumeration enumeration2 = vector.elements();
            fixedRankSignature fixedRankSignature2 = new fixedRankSignature(0);
            Vector<fixedRankSignature> vector4 = new Vector<fixedRankSignature>();
            finiteSignature finiteSignature2 = new fixedRankSignature(0);
            finiteSignature2.addSymbol(string);
            fixedRankSignature2.addSymbol(BSTGrammar.this.qname + "__" + this.sigToState(finiteSignature2));
            vector4.addElement((fixedRankSignature)finiteSignature2);
            while (enumeration2.hasMoreElements()) {
                finiteSignature2 = (finiteSignature)enumeration2.nextElement();
                for (int i = 0; i < vector2.size(); ++i) {
                    SuperTable superTable = (SuperTable)vector2.elementAt(i);
                    for (int j = 0; j < superTable.getNumTables(); ++j) {
                        SuperTable superTable2 = superTable.getSubTable(j);
                        Vector vector5 = superTable2.getUsedSyncBranchNumbersForSyncLevel(n2, n + 1);
                        for (int k = 0; k < n3 * n2; ++k) {
                            if (!vector5.contains(new Integer(k))) continue;
                            fixedRankSignature fixedRankSignature3 = superTable2.nonterminalslnRhsThatUseGivenSyncNumber(finiteSignature2, k, n2, n);
                            String string2 = BSTGrammar.this.qname + "__" + this.sigToState(fixedRankSignature3);
                            if (fixedRankSignature2.contains(new symbol(string2, 0))) continue;
                            fixedRankSignature2.addSymbol(BSTGrammar.this.qname + "__" + this.sigToState(fixedRankSignature3));
                            vector4.addElement(fixedRankSignature3);
                        }
                    }
                }
            }
            return vector4;
        }

        private String sigToState(finiteSignature finiteSignature2) {
            String string = new String();
            Vector vector = new Vector();
            Enumeration enumeration2 = finiteSignature2.elements();
            while (enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
            Collections.sort(vector, new SymbolComparator());
            for (int i = 0; i < vector.size(); ++i) {
                string = string + "_" + vector.elementAt(i);
            }
            return string;
        }

        protected void generateIntermediateTransducerUsingExtendedTranslation(FileWriter fileWriter, int n) throws IOException {
            Object object;
            Object object2;
            Cloneable cloneable;
            Object object3;
            Object object4;
            int n2 = n;
            Vector vector = BSTGrammar.this.superTables.getTablesAtDepth(n2);
            Vector vector2 = BSTGrammar.this.superTables.getTablesAtDepth(n2 + 1);
            fileWriter.write("generators.tdTransducer:\n");
            fileWriter.write("  (\n");
            int n3 = BSTGrammar.this.bstDValue;
            int n4 = 1;
            for (int i = 0; i < n2; ++i) {
                n4 *= n3;
            }
            finiteSignature finiteSignature2 = new finiteSignature();
            finiteSignature2.addSymbol(BSTGrammar.this.bottom);
            finiteSignature2.addSymbol(BSTGrammar.this.init);
            Enumeration enumeration2 = BSTGrammar.this.regTreeGrammarNontermSig.elements();
            while (enumeration2.hasMoreElements()) {
                finiteSignature2.addSymbol(new symbol(enumeration2.nextElement().toString(), 0));
            }
            for (int i = 0; i < vector.size(); ++i) {
                object4 = (SuperTable)vector.elementAt(i);
                finiteSignature2.addSymbol(new symbol(((SuperTable)object4).getName(), n4));
            }
            fileWriter.write("    " + finiteSignature2 + ",\n");
            finiteSignature finiteSignature3 = new finiteSignature();
            finiteSignature3.addSymbol(BSTGrammar.this.bottom);
            finiteSignature3.addSymbol(BSTGrammar.this.init);
            object4 = BSTGrammar.this.regTreeGrammarNontermSig.elements();
            while (object4.hasMoreElements()) {
                finiteSignature3.addSymbol(new symbol(object4.nextElement().toString(), 0));
            }
            for (int i = 0; i < vector2.size(); ++i) {
                object3 = (SuperTable)vector2.elementAt(i);
                finiteSignature3.addSymbol(new symbol(((SuperTable)object3).getName(), n4 * n3));
            }
            fileWriter.write("    " + finiteSignature3 + ",\n");
            fixedRankSignature fixedRankSignature2 = new fixedRankSignature(1);
            object3 = new fixedRankSignature(1);
            try {
                Object object5;
                Object object6;
                Object object7;
                cloneable = this.powerSet(BSTGrammar.this.bstNontermSig);
                object2 = new Vector();
                object2 = this.findSmartSubsetForStateSignature((Vector)cloneable, BSTGrammar.this.axiom.toString(), vector, vector2, n2);
                if (!((Vector)object2).contains(null)) {
                    ((Vector)object2).addElement(null);
                }
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    object7 = (finiteSignature)object.nextElement();
                    object6 = object7 == null ? BSTGrammar.this.qname : BSTGrammar.this.qname + "__" + this.sigToState((finiteSignature)object7);
                    fixedRankSignature2.addSymbol((String)object6);
                }
                object7 = ((Vector)object2).elements();
                while (object7.hasMoreElements()) {
                    object6 = (finiteSignature)object7.nextElement();
                    object5 = object6 == null ? BSTGrammar.this.qname : BSTGrammar.this.qname + "__" + this.sigToState((finiteSignature)object6);
                    ((fixedRankSignature)object3).addSymbol((String)object5);
                }
                fileWriter.write("    " + fixedRankSignature2 + ",\n");
                fileWriter.write("    {\n");
                object6 = ((Vector)object2).elements();
                while (object6.hasMoreElements()) {
                    Object object8;
                    object5 = (finiteSignature)object6.nextElement();
                    if (object5 != null) {
                        fileWriter.write("    %Rules for when the possible BST-nonterminals are:" + object5 + "\n");
                    } else {
                        fileWriter.write("    %Rules for when the possible BST-nonterminals are unknown:\n");
                    }
                    String string = object5 == null ? BSTGrammar.this.qname : BSTGrammar.this.qname + "__" + this.sigToState((finiteSignature)object5);
                    for (int i = 0; i < vector.size(); ++i) {
                        object8 = (SuperTable)vector.elementAt(i);
                        for (int j = 0; j < ((SuperTable)object8).getNumTables(); ++j) {
                            String string2;
                            int n5;
                            SuperTable superTable = ((SuperTable)object8).getSubTable(j);
                            String string3 = "";
                            String string4 = "";
                            Vector vector3 = superTable.getUsedSyncBranchNumbersForSyncLevel(n3, n2 + 1);
                            for (n5 = 0; n5 < n4; ++n5) {
                                string4 = string4 + "x" + (n5 + 1);
                                if (n5 + 1 >= n4) continue;
                                string4 = string4 + ",";
                            }
                            for (n5 = 0; n5 < n4 * n3; ++n5) {
                                if (vector3.contains(new Integer(n5))) {
                                    fixedRankSignature fixedRankSignature3 = superTable.nonterminalslnRhsThatUseGivenSyncNumber((finiteSignature)object5, n5, n3, n2);
                                    String string5 = BSTGrammar.this.qname + "__" + this.sigToState(fixedRankSignature3);
                                    if (fixedRankSignature3.size() == 0) {
                                        string3 = string3 + BSTGrammar.this.bottom;
                                    } else {
                                        string2 = fixedRankSignature2.contains(new symbol(string5, 1)) ? string5 : BSTGrammar.this.qname;
                                        string3 = string3 + string2 + "[x" + (1 + n5 / n3) + "]";
                                    }
                                } else {
                                    string3 = string3 + BSTGrammar.this.bottom;
                                }
                                if (n5 >= n4 * n3 - 1) continue;
                                string3 = string3 + ",";
                            }
                            String string6 = string4;
                            string2 = string3;
                            fileWriter.write("      " + string + "[" + ((SuperTable)object8).getName() + "[" + string6 + "]] -> " + superTable.getName() + "[" + string2 + "] weight " + superTable.getWeight() + ",");
                            fileWriter.write("\n");
                        }
                    }
                    fileWriter.write("    " + string + "[" + BSTGrammar.this.bottom + "] -> " + BSTGrammar.this.bottom + ",\n");
                    Enumeration enumeration3 = BSTGrammar.this.regTreeGrammarNontermSig.elements();
                    while (enumeration3.hasMoreElements()) {
                        object8 = enumeration3.nextElement().toString();
                        fileWriter.write("    " + string + "[" + (String)object8 + "] -> " + (String)object8 + ",\n");
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Error in implementation. Unhandled exception.\n" + exception.getClass().getName() + " line " + exception.getStackTrace()[0] + "  ");
            }
            cloneable = new fixedRankSignature(1);
            ((fixedRankSignature)cloneable).addSymbol(BSTGrammar.this.axiom.toString());
            object2 = BSTGrammar.this.qname + "__" + this.sigToState((finiteSignature)cloneable);
            object = fixedRankSignature2.contains(new symbol((String)object2, 1)) ? object2 : BSTGrammar.this.qname;
            fileWriter.write("      " + BSTGrammar.this.qname + "[init[x1]] -> init[" + (String)object + "[x1]]\n");
            fileWriter.write("    },\n");
            fileWriter.write("    " + BSTGrammar.this.qname + "\n");
            fileWriter.write("  )");
            fileWriter.close();
        }

        protected class SymbolComparator
        implements Comparator {
            protected SymbolComparator() {
            }

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        }
    }

    class RegularTreeGrammarGenerator {
        boolean loopFlag = false;

        RegularTreeGrammarGenerator() {
        }

        private void generateDefaultGrammar(FileWriter fileWriter, boolean bl) throws IOException {
            int n = BSTGrammar.this.bstDValue;
            BSTGrammar.this.regTreeGrammarNontermSig.addSymbol(BSTGrammar.this.Sname);
            BSTGrammar.this.regTreeGrammarNontermSig.addSymbol(BSTGrammar.this.S0name);
            fileWriter.write("generators.stubbornRegularTreeGrammar:  ");
            fileWriter.write("  (\n");
            fileWriter.write("    " + BSTGrammar.this.regTreeGrammarNontermSig + ",\n");
            finiteSignature finiteSignature2 = new finiteSignature();
            finiteSignature2.addSymbol(BSTGrammar.this.bottom);
            finiteSignature2.addSymbol(BSTGrammar.this.init);
            for (int i = 0; i < BSTGrammar.this.superTables.getNumTables(); ++i) {
                SuperTable superTable = BSTGrammar.this.superTables.getSubTable(i);
                finiteSignature2.addSymbol(new symbol(superTable.getName(), n));
            }
            fileWriter.write("    " + finiteSignature2 + ",\n");
            fileWriter.write("    {\n");
            this.tableEnumerationRules(fileWriter, bl, BSTGrammar.this.Sname, BSTGrammar.this.S0name);
            fileWriter.write("    },\n");
            fileWriter.write("    " + BSTGrammar.this.Sname + "\n");
            fileWriter.write("  )");
            fileWriter.close();
        }

        private SuperTable findTableWithName(SuperTable superTable, String string) {
            for (int i = 0; i < superTable.getNumTables(); ++i) {
                SuperTable superTable2 = superTable.getSubTable(i);
                if (!superTable2.getName().equals(string)) continue;
                return superTable2;
            }
            return null;
        }

        private boolean isSynctreeSubtreeUseful(SuperTable superTable, int n, int n2, int n3) {
            Vector vector = superTable.getUsedSyncBranchNumbersForSyncLevel(n3, n2);
            return vector.contains(new Integer(n));
        }

        private void tableEnumerationRules(FileWriter fileWriter, boolean bl, String string, String string2) throws IOException {
            int n = BSTGrammar.this.bstDValue;
            if (BSTGrammar.this.axiomTable == null) {
                String string3 = string + " -> " + BSTGrammar.this.initName + "[" + string2 + "]";
                fileWriter.write("      " + string3);
                fileWriter.write(",\n      ");
            }
            for (int i = 0; i < BSTGrammar.this.superTables.getNumTables(); ++i) {
                int n2;
                SuperTable superTable = BSTGrammar.this.superTables.getSubTable(i);
                Vector vector = superTable.getUsedSyncBranchNumbersForSyncLevel(n, 1);
                String string4 = "";
                for (n2 = 0; n2 < n; ++n2) {
                    string4 = !bl || vector.contains(new Integer(n2)) ? string4 + string2 : string4 + BSTGrammar.this.bottom;
                    if (n2 >= n - 1) continue;
                    string4 = string4 + ",";
                }
                if (BSTGrammar.this.axiomTable != null && superTable == BSTGrammar.this.axiomTable) {
                    fileWriter.write(string + " -> " + BSTGrammar.this.initName + "[" + superTable.getName() + "[" + string4 + "]]");
                } else {
                    fileWriter.write(string2 + " -> " + superTable.getName() + "[" + string4 + "] weight " + superTable.getWeight());
                }
                if (vector.size() > 0 && superTable.isTerminable(BSTGrammar.this.bstTermSig, BSTGrammar.this.bstNontermSig)) {
                    fileWriter.write(",\n      ");
                    string4 = "";
                    for (n2 = 0; n2 < n; ++n2) {
                        string4 = string4 + BSTGrammar.this.bottom;
                        if (n2 >= n - 1) continue;
                        string4 = string4 + ",";
                    }
                    if (BSTGrammar.this.axiomTable != null && superTable == BSTGrammar.this.axiomTable) {
                        fileWriter.write(string + " -> " + BSTGrammar.this.initName + "[" + superTable.getName() + "[" + string4 + "]]");
                    } else {
                        fileWriter.write(string2 + " -> " + superTable.getName() + "[" + string4 + "] weight 0");
                    }
                }
                if (i + 1 < BSTGrammar.this.superTables.getNumTables()) {
                    fileWriter.write(",\n");
                    continue;
                }
                fileWriter.write("\n");
            }
            if (!bl) {
                fileWriter.write(",\n      " + string2 + " -> " + BSTGrammar.this.bottom + " weight 0.2");
            }
            fileWriter.write("\n");
        }

        private void generateGrammar(FileWriter fileWriter, boolean bl, rexp rexp2) throws IOException {
            int n;
            int n2;
            finiteSignature finiteSignature2 = new finiteSignature();
            for (n2 = 0; n2 < BSTGrammar.this.superTables.getNumTables(); ++n2) {
                SuperTable superTable = BSTGrammar.this.superTables.getSubTable(n2);
                finiteSignature2.addSymbol(new symbol(superTable.getName(), BSTGrammar.this.bstDValue));
            }
            finiteSignature2.addSymbol(BSTGrammar.this.init);
            finiteSignature2.addSymbol(BSTGrammar.this.bottom);
            n2 = this.generateRules(rexp2, 0);
            for (n = BSTGrammar.this.chainRules.size(); n <= n2; ++n) {
                BSTGrammar.this.chainRules.addElement(new Vector());
            }
            for (n = BSTGrammar.this.regularRules.size(); n <= n2; ++n) {
                BSTGrammar.this.regularRules.addElement(new Vector());
            }
            this.addRegularRule(n2, BSTGrammar.this.bottom + " weight 0");
            this.applyClosure();
            BSTGrammar.this.regTreeGrammarNontermSig.addSymbol("S");
            for (n = 0; n <= n2; ++n) {
                BSTGrammar.this.regTreeGrammarNontermSig.addSymbol("S" + n);
            }
            n2 = this.removeUnreachable(n2);
            fileWriter.write("generators.stubbornRegularTreeGrammar:\n");
            fileWriter.write("  (\n");
            fileWriter.write("    " + BSTGrammar.this.regTreeGrammarNontermSig + ",\n");
            fileWriter.write("    " + finiteSignature2 + ",\n");
            fileWriter.write("    {\n");
            fileWriter.write("      S -> " + BSTGrammar.this.init + "[" + "S0" + "],\n");
            for (n = 0; n < BSTGrammar.this.regularRules.size(); ++n) {
                Vector vector = (Vector)BSTGrammar.this.regularRules.elementAt(n);
                for (int i = 0; i < vector.size(); ++i) {
                    fileWriter.write("      S" + n + " -> ");
                    String string = "";
                    String string2 = "";
                    try {
                        StringTokenizer stringTokenizer = new StringTokenizer(vector.elementAt(i).toString(), "[]");
                        string = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                    }
                    catch (Exception exception) {
                        string2 = null;
                    }
                    int n3 = 0;
                    try {
                        n3 = Integer.parseInt(string.substring(1));
                        string = BSTGrammar.this.superTables.getSubTable(n3 - 1).getName();
                        fileWriter.write(string);
                    }
                    catch (Exception exception) {
                        fileWriter.write(string);
                    }
                    if (string2 != null) {
                        boolean bl2 = true;
                        fileWriter.write("[");
                        for (int j = 0; j < BSTGrammar.this.bstDValue; ++j) {
                            SuperTable superTable = this.findTableWithName(BSTGrammar.this.superTables, string);
                            if (superTable == null) {
                                throw new RuntimeException("This should not happen. Could not find table " + string);
                            }
                            if (this.isSynctreeSubtreeUseful(superTable, j, 1, BSTGrammar.this.bstDValue)) {
                                fileWriter.write(string2);
                                bl2 = false;
                            } else {
                                fileWriter.write(BSTGrammar.this.bottom.toString());
                            }
                            if (j + 1 >= BSTGrammar.this.bstDValue) continue;
                            fileWriter.write(",");
                        }
                        fileWriter.write("]");
                        if (bl2) {
                            fileWriter.write(" weight 0");
                        }
                    }
                    if (n < n2 || i + 1 < vector.size()) {
                        fileWriter.write(",\n");
                        continue;
                    }
                    fileWriter.write("\n");
                }
            }
            fileWriter.write("    },\n");
            fileWriter.write("    S\n");
            fileWriter.write("  )");
            fileWriter.close();
        }

        private int generateRules(rexp rexp2, int n) {
            switch (rexp2.type) {
                case -4: {
                    boolean bl = this.loopFlag;
                    this.loopFlag = rexp2.subexp[1].containsLoop();
                    int n2 = this.generateRules(rexp2.subexp[0], n);
                    this.loopFlag = bl;
                    return this.generateRules(rexp2.subexp[1], n2);
                }
                case -3: {
                    boolean bl = this.loopFlag;
                    int n3 = this.generateRules(rexp2.subexp[0], n + 1);
                    boolean bl2 = this.loopFlag;
                    this.loopFlag = bl;
                    int n4 = this.generateRules(rexp2.subexp[1], n3 + 1);
                    this.loopFlag = this.loopFlag || bl2;
                    this.addChainRule(n, n + 1);
                    this.addChainRule(n, n3 + 1);
                    this.addChainRule(n3, n4);
                    return n4;
                }
                case -2: {
                    this.loopFlag = true;
                    int n5 = this.generateRules(rexp2.subexp[0], n);
                    this.addChainRule(n5, n5 + 1);
                    this.addChainRule(n5, n);
                    return n5 + 1;
                }
                case -1: {
                    this.loopFlag = true;
                }
                case -5: {
                    int n6 = this.generateRules(rexp2.subexp[0], n + 1);
                    this.addChainRule(n, n6 + 1);
                    this.addChainRule(n6, n6 + 1);
                    this.addChainRule(n, n + 1);
                    if (rexp2.type == -1) {
                        this.addChainRule(n6, n + 1);
                    }
                    return n6 + 1;
                }
            }
            if (this.loopFlag) {
                this.addRegularRule(n, "t" + rexp2.type + "[S" + (n + 1) + "]");
            } else {
                this.addRegularRule(n, "t" + rexp2.type + "[S" + (n + 1) + "] weight 0");
            }
            return n + 1;
        }

        private void addChainRule(int n, int n2) {
            for (int i = BSTGrammar.this.chainRules.size(); i <= n; ++i) {
                BSTGrammar.this.chainRules.addElement(new Vector());
            }
            ((Vector)BSTGrammar.this.chainRules.elementAt(n)).addElement(new Integer(n2));
        }

        private void addRegularRule(int n, String string) {
            for (int i = BSTGrammar.this.regularRules.size(); i <= n; ++i) {
                BSTGrammar.this.regularRules.addElement(new Vector());
            }
            ((Vector)BSTGrammar.this.regularRules.elementAt(n)).addElement(string);
        }

        private void applyClosure() {
            this.closure();
            Vector vector = new Vector(BSTGrammar.this.regularRules.size());
            for (int i = 0; i < BSTGrammar.this.chainRules.size(); ++i) {
                Vector vector2 = new Vector();
                vector.addElement(vector2);
                Vector vector3 = (Vector)BSTGrammar.this.chainRules.elementAt(i);
                for (int j = 0; j < vector3.size(); ++j) {
                    int n = (Integer)vector3.elementAt(j);
                    vector2.addAll((Vector)BSTGrammar.this.regularRules.elementAt(n));
                }
            }
            BSTGrammar.this.regularRules = vector;
        }

        private void closure() {
            int n;
            for (n = 0; n < BSTGrammar.this.chainRules.size(); ++n) {
                Vector vector = (Vector)BSTGrammar.this.chainRules.elementAt(n);
                vector.addElement(new Integer(n));
            }
            do {
                n = 0;
                for (int i = 0; i < BSTGrammar.this.chainRules.size(); ++i) {
                    Vector vector = (Vector)BSTGrammar.this.chainRules.elementAt(i);
                    for (int j = 0; j < vector.size(); ++j) {
                        int n2 = (Integer)vector.elementAt(j);
                        Vector vector2 = (Vector)BSTGrammar.this.chainRules.elementAt(n2);
                        for (int k = 0; k < vector2.size(); ++k) {
                            if (vector.contains(vector2.elementAt(k))) continue;
                            vector.addElement(vector2.elementAt(k));
                            n = 1;
                        }
                    }
                }
            } while (n != 0);
        }

        private int removeUnreachable(int n) {
            int n2;
            Vector vector = new Vector(n + 1);
            for (int i = 0; i <= n; ++i) {
                Vector vector2 = (Vector)BSTGrammar.this.regularRules.elementAt(i);
                Vector<Integer> vector3 = new Vector<Integer>();
                vector.add(vector3);
                for (int j = 0; j < vector2.size(); ++j) {
                    String string = (String)vector2.elementAt(j);
                    n2 = string.indexOf(83);
                    if (n2 < 0) continue;
                    try {
                        vector3.add(new Integer(string.substring(n2 + 1, string.indexOf(93))));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InternalError();
                    }
                }
            }
            BitSet bitSet = new BitSet(n + 1);
            bitSet.set(0);
            boolean bl = true;
            while (bl) {
                bl = false;
                for (int i = 0; i <= n; ++i) {
                    if (!bitSet.get(i)) continue;
                    Vector vector4 = (Vector)vector.elementAt(i);
                    for (int j = 0; j < vector4.size(); ++j) {
                        n2 = (Integer)vector4.elementAt(j);
                        if (bitSet.get(n2)) continue;
                        bitSet.set(n2);
                        bl = true;
                    }
                }
            }
            for (int i = n; i > 0; --i) {
                if (bitSet.get(i)) continue;
                if (i == n) {
                    --n;
                }
                BSTGrammar.this.regTreeGrammarNontermSig.removeSymbol(new symbol("S" + i, 0));
                BSTGrammar.this.regularRules.setElementAt(new Vector(0), i);
            }
            return n;
        }

        private void generateSolitaryTreeGrammar(FileWriter fileWriter) throws IOException {
            fileWriter.write("generators.stubbornRegularTreeGrammar:\n");
            fileWriter.write("  (\n");
            fileWriter.write("    " + BSTGrammar.this.bstNontermSig + ",\n");
            fileWriter.write("    " + BSTGrammar.this.bstTermSig + ",\n");
            fileWriter.write("    {\n");
            for (int i = 0; i < BSTGrammar.this.superTables.getNumRules(); ++i) {
                SyncedRule syncedRule = BSTGrammar.this.superTables.getRule(i);
                String string = "    " + syncedRule.getLhs() + " -> " + syncedRule.getRhs();
                fileWriter.write(string);
                if (i + 1 < BSTGrammar.this.superTables.getNumRules()) {
                    fileWriter.write(",\n");
                    continue;
                }
                fileWriter.write("\n");
            }
            fileWriter.write("    },\n");
            fileWriter.write("    " + BSTGrammar.this.axiom + "\n");
            fileWriter.write("    )\n");
            fileWriter.write("  }\n");
            fileWriter.close();
        }
    }
}

