/*
 * Decompiled with CFR 0.152.
 */
package generators;

import generators.regularTreeGrammar;
import generators.rexp;
import generators.tdTransducer;
import generators.treeGrammar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.ET0LTreeGrammarParser;
import parsers.ParseException;
import parsers.nameParser;
import parsers.objectParser;
import parsers.termParser;
import terms.finiteSignature;
import terms.fixedRankSignature;
import terms.symbol;
import terms.term;
import terms.variable;
import util.ExitException;
import util.list;

public class ET0LTreeGrammar
extends treeGrammar {
    regularTreeGrammar gram;
    tdTransducer trans;
    private static String enumerate = "table enumeration";
    private static String advance = "advance";
    private static String single = "derive stepwise";
    private static String complete = "results only";
    private static String step = "derivation step";
    private static String random = "random tables";
    private static String refine = "refine";
    private static String back = "back";
    private static String reset = "reset";
    private static String newSeed = "new derivation";
    private static String[][] eCommands = new String[][]{{advance, reset}, {random}};
    private static String[][] rCommands = new String[][]{{refine, back, reset}, {enumerate}};
    private static String[][] sCommands = new String[][]{{step, back}, {complete}};
    private static String[][] cCommands = new String[][]{{single}};
    private static String[] tCommands = new String[]{newSeed};
    private static String grammarExtension = ".1";
    private static String transducerExtension = ".2";
    private finiteSignature outputSig;
    private finiteSignature tableSig = new finiteSignature();
    private fixedRankSignature nontermSig;
    private fixedRankSignature origNontermSig;
    private fixedRankSignature grammarNonterminals = new fixedRankSignature(0);
    private term axiom;
    private Vector tableNames;
    private Vector tables;
    private Vector regularRules = new Vector();
    private Vector chainRules = new Vector();
    private rexp regulation = null;
    private BitSet terminatingTable;
    private BitSet nonterminatingTable;
    private symbol bottom = new symbol("bot", 0);
    private symbol init = new symbol("init", 1);
    private symbol startState = new symbol("q0", 1);
    private term current = null;
    private boolean recompute = true;
    boolean loopFlag = false;

    public list commands() {
        list list2 = super.commands();
        if (this.gram.isEnumerate) {
            int n;
            for (n = 0; n < eCommands.length; ++n) {
                list2.append(eCommands[n]);
            }
            if (this.gram.isStepwise) {
                n = sCommands.length;
                while (n > 0) {
                    list2.tail().prepend(sCommands[--n]);
                }
            } else {
                n = cCommands.length;
                while (n > 0) {
                    list2.tail().prepend(cCommands[--n]);
                }
            }
        } else {
            for (int i = 0; i < rCommands.length; ++i) {
                list2.append(rCommands[i]);
            }
        }
        if (!this.trans.isDeterministic()) {
            list2.append(tCommands);
        }
        return list2;
    }

    public void execute(String string) {
        this.recompute = true;
        if (enumerate.equals(string)) {
            this.gram.execute("enumeration");
        } else if (advance.equals(string)) {
            this.gram.execute("advance");
        } else if (single.equals(string)) {
            this.gram.execute("derive stepwise");
            this.gram.execute("single step");
        } else if (complete.equals(string)) {
            this.gram.execute("results only");
        } else if (step.equals(string)) {
            this.gram.execute("single step");
        } else if (random.equals(string)) {
            this.gram.execute("random generation");
            this.gram.execute("back");
            this.checkAdvance();
        } else if (refine.equals(string)) {
            this.gram.execute("refine");
        } else if (back.equals(string)) {
            this.gram.execute("back");
            this.checkAdvance();
        } else if (reset.equals(string)) {
            this.gram.execute("reset");
            if (!this.gram.isEnumerate || this.gram.isStepwise) {
                this.checkAdvance();
            }
        } else if (newSeed.equals(string)) {
            this.trans.execute("new random seed");
        } else {
            super.execute(string);
        }
    }

    private void checkAdvance() {
        term term2 = this.gram.currentTerm();
        if (term2 != null && !term2.topSymbol().equals(this.init)) {
            if (!this.gram.isEnumerate) {
                this.gram.execute("refine");
            } else {
                this.gram.execute("single step");
            }
        }
    }

    public boolean requestsExit(String string) {
        return string.equals(advance) || string.equals(refine) || string.equals(reset);
    }

    public synchronized term currentTerm() {
        if (this.recompute) {
            try {
                this.current = this.trans.apply(this.gram.currentTerm());
            }
            catch (ExitException exitException) {
                this.current = null;
                return null;
            }
            this.recompute = false;
        }
        return this.current;
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        ET0LTreeGrammarParser eT0LTreeGrammarParser = new ET0LTreeGrammarParser(aSCII_CharStream);
        eT0LTreeGrammarParser.ET0LTreeGrammar();
        this.outputSig = eT0LTreeGrammarParser.sig;
        this.nontermSig = new fixedRankSignature(1);
        this.origNontermSig = eT0LTreeGrammarParser.nonterminals;
        Enumeration enumeration2 = this.origNontermSig.elements();
        while (enumeration2.hasMoreElements()) {
            this.nontermSig.addSymbol(((symbol)enumeration2.nextElement()).toString());
        }
        this.axiom = eT0LTreeGrammarParser.axiom;
        this.tableNames = eT0LTreeGrammarParser.tableNames;
        this.tables = eT0LTreeGrammarParser.tables;
        this.regulation = eT0LTreeGrammarParser.regulation;
        this.addImplicitRules();
        this.determineTermination();
        this.computeTableSig();
    }

    private void addImplicitRules() {
        for (int i = 0; i < this.tables.size(); ++i) {
            int n;
            Object object;
            Vector<Object> vector = new Vector<Object>();
            Vector vector2 = (Vector)this.tables.elementAt(i);
            Enumeration enumeration2 = this.nontermSig.elements();
            block1: while (enumeration2.hasMoreElements()) {
                object = (symbol)enumeration2.nextElement();
                for (n = 0; n < vector2.size(); ++n) {
                    if (((symbol)object).equals(this.lhsSymbol(vector2, n))) continue block1;
                }
                vector.addElement(object);
            }
            object = (String)this.tableNames.elementAt(i);
            for (n = 0; n < vector.size(); ++n) {
                Object[] objectArray = new Object[3];
                vector2.addElement(objectArray);
                symbol symbol2 = new variable(1);
                term term2 = new term(symbol2);
                symbol2 = new symbol((String)object, 1);
                term term3 = new term(symbol2);
                term3.defineSubterm(0, term2);
                term2 = term3;
                term3 = new term((symbol)vector.elementAt(n));
                term3.defineSubterm(0, term2);
                objectArray[0] = term3;
                symbol2 = new variable(1);
                term2 = new term(symbol2);
                term3 = new term((symbol)vector.elementAt(n));
                term3.defineSubterm(0, term2);
                objectArray[1] = term3;
                objectArray[2] = new Double(1.0);
            }
        }
    }

    private void determineTermination() {
        this.terminatingTable = new BitSet(this.tables.size());
        this.nonterminatingTable = new BitSet(this.tables.size());
        for (int i = 0; i < this.tables.size(); ++i) {
            boolean bl = false;
            boolean bl2 = false;
            Vector vector = (Vector)this.tables.elementAt(i);
            Enumeration enumeration2 = this.nontermSig.elements();
            while (enumeration2.hasMoreElements()) {
                symbol symbol2 = (symbol)enumeration2.nextElement();
                boolean bl3 = false;
                for (int j = 0; j < vector.size(); ++j) {
                    if (!symbol2.equals(this.lhsSymbol(vector, j))) continue;
                    if (this.isTerminal(this.rhsTerm(vector, j))) {
                        bl3 = true;
                    }
                    if (!this.isNonterminal(this.rhsTerm(vector, j))) continue;
                    bl2 = true;
                }
                if (bl3) continue;
                bl = true;
            }
            if (!bl) {
                this.terminatingTable.set(i);
            }
            if (!bl2) continue;
            this.nonterminatingTable.set(i);
        }
    }

    private symbol lhsSymbol(Vector vector, int n) {
        Object[] objectArray = (Object[])vector.elementAt(n);
        term term2 = (term)objectArray[0];
        return term2.topSymbol();
    }

    private term lhsTerm(Vector vector, int n) {
        Object[] objectArray = (Object[])vector.elementAt(n);
        return (term)objectArray[0];
    }

    private term rhsTerm(Vector vector, int n) {
        Object[] objectArray = (Object[])vector.elementAt(n);
        return (term)objectArray[1];
    }

    private double weight(Vector vector, int n) {
        Object[] objectArray = (Object[])vector.elementAt(n);
        return (Double)objectArray[2];
    }

    private boolean isTerminal(term term2) {
        symbol symbol2 = term2.topSymbol();
        if (this.nontermSig.contains(symbol2)) {
            return this.outputSig.contains(new symbol(symbol2.toString(), 0));
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            if (this.isTerminal(term2.subterm(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isNonterminal(term term2) {
        symbol symbol2 = term2.topSymbol();
        if (this.nontermSig.contains(symbol2)) {
            return true;
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            if (!this.isNonterminal(term2.subterm(i))) continue;
            return true;
        }
        return false;
    }

    private void computeTableSig() {
        this.tableSig.addSymbol(this.init);
        for (int i = 0; i < this.tables.size(); ++i) {
            String string = (String)this.tableNames.elementAt(i);
            this.tableSig.addSymbol(new symbol(string, 1));
        }
        this.tableSig.addSymbol(this.bottom);
    }

    public void translate(String string) throws ParseException {
        boolean bl;
        File file;
        File file2;
        block10: {
            file2 = new File(string + grammarExtension);
            file = new File(string + transducerExtension);
            bl = false;
            try {
                if (this.regulation == null) {
                    this.generateDefaultGrammar(this.openOutFile(file2));
                } else {
                    this.generateGrammar(this.openOutFile(file2), this.regulation);
                }
                this.generateTransducer(this.openOutFile(file));
                bl = true;
            }
            catch (IOException iOException) {
                if (!file2.exists() || !file.exists()) {
                    throw new ParseException("Could not write to output file:\n" + iOException.getMessage());
                }
            }
            catch (AccessControlException accessControlException) {
                if (file2.exists() && file.exists()) break block10;
                throw new ParseException("Could not write to output file:\n" + accessControlException.getMessage());
            }
        }
        try {
            objectParser objectParser2 = new objectParser(new ASCII_CharStream(new FileInputStream(file2), 1, 1));
            this.gram = (regularTreeGrammar)objectParser2.parse();
            objectParser2 = new objectParser(new ASCII_CharStream(new FileInputStream(file), 1, 1));
            this.trans = (tdTransducer)objectParser2.parse();
        }
        catch (ParseException parseException) {
            if (bl) {
                throw new ParseException("Could not parse generated file:\n" + parseException.getMessage() + "\n[This should not happen. There must be one of those " + "small insects in the implementation 8-( ]");
            }
            throw new ParseException("Could not parse previously existing file:\n" + parseException.getMessage() + "\nPlease make sure that the file is writable to enable " + "generation of new file");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParseException("Could not open file:\n" + fileNotFoundException.getMessage());
        }
    }

    private FileWriter openOutFile(File file) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private symbol grammarSymbol(int n) {
        return new symbol("S" + n, 0);
    }

    private void generateDefaultGrammar(FileWriter fileWriter) throws IOException {
        this.grammarNonterminals.addSymbol("S");
        this.grammarNonterminals.addSymbol("S0");
        fileWriter.write("generators.stubbornRegularTreeGrammar:\n");
        fileWriter.write("  (\n");
        fileWriter.write("    " + this.grammarNonterminals + ",\n");
        fileWriter.write("    " + this.tableSig + ",\n");
        fileWriter.write("    {\n");
        this.tableEnumerationRules(fileWriter);
        fileWriter.write("    },\n");
        fileWriter.write("    S\n");
        fileWriter.write("  )");
        fileWriter.close();
    }

    private void tableEnumerationRules(FileWriter fileWriter) throws IOException {
        if (this.isTerminal(this.axiom)) {
            fileWriter.write("      S -> " + this.init + "[" + this.bottom + "] weight 0,\n");
        }
        fileWriter.write("      S -> " + this.init + "[" + this.grammarSymbol(0) + "],\n");
        for (int i = 0; i < this.tables.size(); ++i) {
            if (this.terminatingTable.get(i)) {
                fileWriter.write("      " + this.grammarSymbol(0) + " -> " + this.tableNames.elementAt(i) + "[" + this.bottom + "] weight 0");
                if (this.nonterminatingTable.get(i)) {
                    fileWriter.write(",\n");
                }
            }
            if (this.nonterminatingTable.get(i)) {
                fileWriter.write("      " + this.grammarSymbol(0) + " -> " + this.tableNames.elementAt(i) + "[" + this.grammarSymbol(0) + "]");
            }
            if (i + 1 < this.tables.size()) {
                fileWriter.write(",\n");
                continue;
            }
            fileWriter.write("\n");
        }
    }

    private void generateGrammar(FileWriter fileWriter, rexp rexp2) throws IOException {
        int n;
        int n2 = this.generateRules(rexp2, 0);
        for (n = this.chainRules.size(); n <= n2; ++n) {
            this.chainRules.addElement(new Vector());
        }
        for (n = this.regularRules.size(); n <= n2; ++n) {
            this.regularRules.addElement(new Vector());
        }
        this.addRegularRule(n2, this.bottom + " weight 0");
        this.applyClosure();
        this.grammarNonterminals.addSymbol("S");
        for (n = 0; n <= n2; ++n) {
            this.grammarNonterminals.addSymbol("S" + n);
        }
        n2 = this.removeUnreachable(n2);
        fileWriter.write("generators.stubbornRegularTreeGrammar:\n");
        fileWriter.write("  (\n");
        fileWriter.write("    " + this.grammarNonterminals + ",\n");
        fileWriter.write("    " + this.tableSig + ",\n");
        fileWriter.write("    {\n");
        fileWriter.write("      S -> " + this.init + "[" + this.grammarSymbol(0) + "],\n");
        for (n = 0; n < this.regularRules.size(); ++n) {
            Vector vector = (Vector)this.regularRules.elementAt(n);
            for (int i = 0; i < vector.size(); ++i) {
                fileWriter.write("      S" + n + " -> " + vector.elementAt(i));
                if (n < n2 || i + 1 < vector.size()) {
                    fileWriter.write(",\n");
                    continue;
                }
                fileWriter.write("\n");
            }
        }
        fileWriter.write("    },\n");
        fileWriter.write("    S\n");
        fileWriter.write("  )");
        fileWriter.close();
    }

    private int generateRules(rexp rexp2, int n) {
        switch (rexp2.type) {
            case -4: {
                boolean bl = this.loopFlag;
                this.loopFlag = this.loopFlag || rexp2.subexp[1].containsLoop();
                int n2 = this.generateRules(rexp2.subexp[0], n);
                this.loopFlag = bl;
                return this.generateRules(rexp2.subexp[1], n2);
            }
            case -3: {
                boolean bl = this.loopFlag;
                int n3 = this.generateRules(rexp2.subexp[0], n + 1);
                boolean bl2 = this.loopFlag;
                this.loopFlag = bl;
                int n4 = this.generateRules(rexp2.subexp[1], n3 + 1);
                this.loopFlag = this.loopFlag || bl2;
                this.addChainRule(n, n + 1);
                this.addChainRule(n, n3 + 1);
                this.addChainRule(n3, n4);
                return n4;
            }
            case -2: {
                this.loopFlag = true;
                int n5 = this.generateRules(rexp2.subexp[0], n);
                this.addChainRule(n5, n5 + 1);
                this.addChainRule(n5, n);
                return n5 + 1;
            }
            case -1: {
                this.loopFlag = true;
            }
            case -5: {
                int n6 = this.generateRules(rexp2.subexp[0], n + 1);
                this.addChainRule(n, n6 + 1);
                this.addChainRule(n6, n6 + 1);
                this.addChainRule(n, n + 1);
                if (rexp2.type == -1) {
                    this.addChainRule(n6, n + 1);
                }
                return n6 + 1;
            }
        }
        if (this.loopFlag) {
            this.addRegularRule(n, "t" + rexp2.type + "[S" + (n + 1) + "]");
        } else {
            this.addRegularRule(n, "t" + rexp2.type + "[S" + (n + 1) + "] weight 0");
        }
        return n + 1;
    }

    private void addChainRule(int n, int n2) {
        for (int i = this.chainRules.size(); i <= n; ++i) {
            this.chainRules.addElement(new Vector());
        }
        ((Vector)this.chainRules.elementAt(n)).addElement(new Integer(n2));
    }

    private void addRegularRule(int n, String string) {
        for (int i = this.regularRules.size(); i <= n; ++i) {
            this.regularRules.addElement(new Vector());
        }
        ((Vector)this.regularRules.elementAt(n)).addElement(string);
    }

    private void applyClosure() {
        this.closure();
        Vector vector = new Vector(this.regularRules.size());
        for (int i = 0; i < this.chainRules.size(); ++i) {
            Vector vector2 = new Vector();
            vector.addElement(vector2);
            Vector vector3 = (Vector)this.chainRules.elementAt(i);
            for (int j = 0; j < vector3.size(); ++j) {
                int n = (Integer)vector3.elementAt(j);
                vector2.addAll((Vector)this.regularRules.elementAt(n));
            }
        }
        this.regularRules = vector;
    }

    private void closure() {
        int n;
        for (n = 0; n < this.chainRules.size(); ++n) {
            Vector vector = (Vector)this.chainRules.elementAt(n);
            vector.addElement(new Integer(n));
        }
        do {
            n = 0;
            for (int i = 0; i < this.chainRules.size(); ++i) {
                Vector vector = (Vector)this.chainRules.elementAt(i);
                for (int j = 0; j < vector.size(); ++j) {
                    int n2 = (Integer)vector.elementAt(j);
                    Vector vector2 = (Vector)this.chainRules.elementAt(n2);
                    for (int k = 0; k < vector2.size(); ++k) {
                        if (vector.contains(vector2.elementAt(k))) continue;
                        vector.addElement(vector2.elementAt(k));
                        n = 1;
                    }
                }
            }
        } while (n != 0);
    }

    private int removeUnreachable(int n) {
        int n2;
        Vector vector = new Vector(n + 1);
        for (int i = 0; i <= n; ++i) {
            Vector vector2 = (Vector)this.regularRules.elementAt(i);
            Vector<Integer> vector3 = new Vector<Integer>();
            vector.add(vector3);
            for (int j = 0; j < vector2.size(); ++j) {
                String string = (String)vector2.elementAt(j);
                n2 = string.indexOf(83);
                if (n2 < 0) continue;
                try {
                    vector3.add(new Integer(string.substring(n2 + 1, string.indexOf(93))));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InternalError();
                }
            }
        }
        BitSet bitSet = new BitSet(n + 1);
        bitSet.set(0);
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i <= n; ++i) {
                if (!bitSet.get(i)) continue;
                Vector vector4 = (Vector)vector.elementAt(i);
                for (int j = 0; j < vector4.size(); ++j) {
                    n2 = (Integer)vector4.elementAt(j);
                    if (bitSet.get(n2)) continue;
                    bitSet.set(n2);
                    bl = true;
                }
            }
        }
        for (int i = n; i > 0; --i) {
            if (bitSet.get(i)) continue;
            if (i == n) {
                --n;
            }
            this.grammarNonterminals.removeSymbol(new symbol("S" + i, 0));
            this.regularRules.setElementAt(new Vector(0), i);
        }
        return n;
    }

    private void generateTransducer(FileWriter fileWriter) throws IOException {
        fileWriter.write("generators.tdTransducer:\n");
        fileWriter.write("  (\n");
        finiteSignature finiteSignature2 = new finiteSignature();
        finiteSignature2.unionWith(this.tableSig);
        finiteSignature2.unionWith(this.grammarNonterminals);
        fileWriter.write("    " + finiteSignature2 + ",\n");
        finiteSignature finiteSignature3 = new finiteSignature();
        finiteSignature3.unionWith(this.origNontermSig);
        finiteSignature3.unionWith(this.outputSig);
        fileWriter.write("    " + finiteSignature3 + ",\n");
        fixedRankSignature fixedRankSignature2 = new fixedRankSignature(1);
        fixedRankSignature2.unionWith(this.nontermSig);
        fixedRankSignature2.addSymbol(this.startState);
        fileWriter.write("    " + fixedRankSignature2 + ",\n");
        fileWriter.write("    {\n");
        this.tableImplementationRules(fileWriter);
        fileWriter.write("    },\n");
        fileWriter.write("    " + nameParser.unparse(this.startState.toString()) + "\n");
        fileWriter.write("  )");
        fileWriter.close();
    }

    private void tableImplementationRules(FileWriter fileWriter) throws IOException {
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        vector.addElement(nameParser.unparse(this.startState.toString()) + "[" + this.init + "[x1]] -> " + termParser.unparse(this.axiom));
        for (int i = 0; i < this.tables.size(); ++i) {
            object2 = (Vector)this.tables.elementAt(i);
            for (int j = 0; j < ((Vector)object2).size(); ++j) {
                object = this.lhsTerm((Vector)object2, j);
                term term2 = this.rhsTerm((Vector)object2, j);
                double d = this.weight((Vector)object2, j);
                if (d == 1.0) {
                    vector.addElement(termParser.unparse((term)object) + " -> " + termParser.unparse(term2));
                    continue;
                }
                vector.addElement(termParser.unparse((term)object) + " -> " + termParser.unparse(term2) + " weight " + d);
            }
        }
        Enumeration enumeration2 = this.nontermSig.elements();
        while (enumeration2.hasMoreElements()) {
            object2 = enumeration2.nextElement().toString();
            if (this.outputSig.contains(new symbol((String)object2, 0))) {
                vector.addElement(nameParser.unparse((String)object2) + "[" + this.bottom + "] -> " + nameParser.unparse((String)object2));
            }
            Enumeration enumeration3 = this.grammarNonterminals.elements();
            while (enumeration3.hasMoreElements()) {
                object = enumeration3.nextElement().toString();
                vector.addElement(nameParser.unparse((String)object2) + "[" + (String)object + "] -> " + nameParser.unparse((String)object2));
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            fileWriter.write("      " + (String)vector.elementAt(i));
            if (i + 1 < vector.size()) {
                fileWriter.write(", \n");
                continue;
            }
            fileWriter.write("\n");
        }
    }
}

