/*
 * Decompiled with CFR 0.152.
 */
package generators;

import generators.SuperTable;
import java.util.Vector;
import terms.fixedRankSignature;
import terms.symbol;
import terms.synchronizedSymbol;
import terms.term;

public class SyncedRule {
    public symbol lhs;
    public term rhs;
    public double weight;
    private Vector syncStrings = null;

    public SyncedRule(symbol symbol2, term term2) {
        this(symbol2, term2, 1.0);
    }

    public SyncedRule(symbol symbol2, term term2, double d) {
        this.lhs = symbol2;
        this.rhs = term2;
        this.weight = d;
        this.updateSyncStringVector();
    }

    private Vector checkRhs(term term2, Vector vector) {
        symbol symbol2 = term2.topSymbol();
        if (symbol2 instanceof synchronizedSymbol) {
            vector.addElement(((synchronizedSymbol)symbol2).getSync());
        } else {
            for (int i = 0; i < symbol2.rank(); ++i) {
                this.checkRhs(term2.subterm(i), vector);
            }
        }
        return vector;
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    public double getWeight() {
        return this.weight;
    }

    public symbol getLhs() {
        return this.lhs;
    }

    public term getRhs() {
        return this.rhs;
    }

    public Vector getSyncStrings() {
        if (this.syncStrings == null) {
            this.updateSyncStringVector();
        }
        return this.syncStrings;
    }

    private void updateSyncStringVector() {
        this.syncStrings = new Vector();
        this.checkRhs(this.getRhs(), this.syncStrings);
    }

    public Vector getUsedSyncBranchNumbers(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.syncStrings.size(); ++i) {
            int[] nArray = (int[])this.syncStrings.elementAt(i);
            int n2 = 0;
            for (int j = 0; j < nArray.length; ++j) {
                n2 = n2 * n + nArray[j];
            }
            vector.addElement(new Integer(n2));
        }
        return vector;
    }

    public Vector getUsedSyncBranchNumbersForSyncLevel(int n, int n2) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.syncStrings.size(); ++i) {
            int[] nArray = (int[])this.syncStrings.elementAt(i);
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                n3 = n3 * n + nArray[j];
            }
            vector.addElement(new Integer(n3));
        }
        return vector;
    }

    public static int syncStringToNumberOfBaseD(int[] nArray, int n) {
        int n2 = 1;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n3 += n2 * nArray[nArray.length - i - 1];
            n2 *= n;
        }
        return n3;
    }

    public static int syncStringFirstNToNumberOfBaseD(int[] nArray, int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        for (int i = 0; i < nArray.length && i < n; ++i) {
            n4 += n3 * nArray[n - i - 1];
            n3 *= n2;
        }
        return n4;
    }

    public String getFinalTDRule(SuperTable superTable, int n, int n2) {
        String string = this.lhs + "[" + superTable.getName() + "[";
        for (int i = 0; i < n; ++i) {
            string = string + "x" + (i + 1);
            if (i + 1 >= n) continue;
            string = string + ",";
        }
        string = string + "]] -> ";
        string = string + this.transformOriginalRhsToFinalTransducerRhs(this.rhs, n2);
        return string;
    }

    private String transformOriginalRhsToFinalTransducerRhs(term term2, int n) {
        String string = "";
        string = string + term2.topSymbol();
        if (term2.topSymbol() instanceof synchronizedSymbol) {
            synchronizedSymbol synchronizedSymbol2 = (synchronizedSymbol)term2.topSymbol();
            int[] nArray = synchronizedSymbol2.getSync();
            int n2 = SyncedRule.syncStringToNumberOfBaseD(nArray, n);
            string = string + "[x" + (1 + n2) + "]";
            return string;
        }
        if (term2.topSymbol().rank() != 0) {
            string = string + "[";
            for (int i = 0; i < term2.topSymbol().rank(); ++i) {
                string = string + this.transformOriginalRhsToFinalTransducerRhs(term2.subterm(i), n);
                if (i + 1 >= term2.topSymbol().rank()) continue;
                string = string + ",";
            }
            string = string + "]";
        }
        return string;
    }

    public String getFinalTDRuleWithYield(SuperTable superTable, int n, int n2, Vector vector) {
        String string = this.lhs + "[" + superTable.getName() + "[";
        for (int i = 0; i < n; ++i) {
            string = string + "x" + (i + 1);
            if (i + 1 >= n) continue;
            string = string + ",";
        }
        string = string + "]] -> ";
        string = string + this.transformOriginalRhsToFinalTransducerRhsWithYield(this.rhs, n2, vector);
        return string;
    }

    private String transformOriginalRhsToFinalTransducerRhsWithYield(term term2, int n, Vector vector) {
        String string = "";
        if (term2.topSymbol() instanceof synchronizedSymbol) {
            synchronizedSymbol synchronizedSymbol2 = (synchronizedSymbol)term2.topSymbol();
            int[] nArray = synchronizedSymbol2.getSync();
            int n2 = SyncedRule.syncStringToNumberOfBaseD(nArray, n);
            string = string + "subst[";
            string = string + term2.topSymbol();
            string = string + "[x" + (1 + n2) + "]";
            for (int i = 0; i < nArray.length; ++i) {
                string = string + ", " + vector.elementAt(nArray[i]) + "[proj-" + (i + 1) + "]";
            }
            string = string + "]";
            return string;
        }
        string = string + term2.topSymbol();
        if (term2.topSymbol().rank() != 0) {
            string = string + "[";
            for (int i = 0; i < term2.topSymbol().rank(); ++i) {
                string = string + this.transformOriginalRhsToFinalTransducerRhsWithYield(term2.subterm(i), n, vector);
                if (i + 1 >= term2.topSymbol().rank()) continue;
                string = string + ",";
            }
            string = string + "]";
        }
        return string;
    }

    public fixedRankSignature nonterminalsThatUseGivenSyncNumber(term term2, int n, int n2, int n3) {
        fixedRankSignature fixedRankSignature2 = new fixedRankSignature(0);
        symbol symbol2 = term2.topSymbol();
        if (symbol2 instanceof synchronizedSymbol) {
            int[] nArray = ((synchronizedSymbol)symbol2).getSync();
            if (SyncedRule.syncStringFirstNToNumberOfBaseD(nArray, n3 + 1, n2) == n) {
                fixedRankSignature2.addSymbol(symbol2.toString());
            }
        } else {
            for (int i = 0; i < symbol2.rank(); ++i) {
                fixedRankSignature fixedRankSignature3 = this.nonterminalsThatUseGivenSyncNumber(term2.subterm(i), n, n2, n3);
                fixedRankSignature2.unionWith(fixedRankSignature3);
            }
        }
        return fixedRankSignature2;
    }

    public void increaseLengthOfSyncSymbolTuplesWithOne(int n) {
        this.increaseTuplesInTerm(n, this.getRhs());
        this.updateSyncStringVector();
    }

    private void increaseTuplesInTerm(int n, term term2) {
        symbol symbol2 = term2.topSymbol();
        if (symbol2 instanceof synchronizedSymbol) {
            synchronizedSymbol synchronizedSymbol2 = (synchronizedSymbol)symbol2;
            int[] nArray = synchronizedSymbol2.getSync();
            int n2 = nArray.length + 1;
            int[] nArray2 = new int[n2];
            nArray2[0] = n;
            for (int i = 1; i < n2; ++i) {
                nArray2[i] = nArray[i - 1];
            }
            synchronizedSymbol2.setSync(nArray2);
        } else {
            for (int i = 0; i < symbol2.rank(); ++i) {
                this.increaseTuplesInTerm(n, term2.subterm(i));
            }
        }
    }

    public void relabelSymbol(symbol symbol2, symbol symbol3) {
        if (this.lhs.toString().equals(symbol2.toString())) {
            this.lhs = new synchronizedSymbol(symbol3.toString(), 0);
        }
        this.relabelSymbolInRhs(symbol2.toString(), symbol3.toString(), this.getRhs());
    }

    private void relabelSymbolInRhs(String string, String string2, term term2) {
        symbol symbol2 = term2.topSymbol();
        if (symbol2.toString().equals(string) && symbol2 instanceof synchronizedSymbol) {
            synchronizedSymbol synchronizedSymbol2 = (synchronizedSymbol)symbol2;
            int[] nArray = synchronizedSymbol2.getSync();
            term2.relabel(new synchronizedSymbol(string2, nArray.length));
            synchronizedSymbol2 = (synchronizedSymbol)term2.topSymbol();
            synchronizedSymbol2.setSync(nArray);
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            this.relabelSymbolInRhs(string, string2, term2.subterm(i));
        }
    }
}

