/*
 * Decompiled with CFR 0.152.
 */
package generators;

import generators.treeGrammar;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.pdtGrammarParser;
import terms.symbol;
import terms.term;
import terms.variable;
import util.list;

public class pdtGrammar
extends treeGrammar {
    private static String advance = "advance";
    private static String back = "back";
    private static String reset = "reset";
    private static String ntCom = "nonterminal results";
    private static String tCom = "terminal results";
    private static String[] basicCommands = new String[]{advance, back, reset};
    private static int terminal = 0;
    private static int nonterminal = 1;
    private term[][] rules;
    private int main;
    private Vector levels = new Vector();
    private int currLevel = 0;
    private int currKind = terminal;

    public list commands() {
        list list2 = new list();
        list2.append(basicCommands);
        String[] stringArray = new String[1];
        list2.append(stringArray);
        stringArray[0] = this.currKind == terminal ? ntCom : tCom;
        return list2;
    }

    public void execute(String string) {
        if (advance.equals(string)) {
            this.advance();
        } else if (back.equals(string)) {
            this.back();
        } else if (reset.equals(string)) {
            this.reset();
        } else if (ntCom.equals(string) || tCom.equals(string)) {
            this.currKind = 1 - this.currKind;
        }
    }

    private term[][] level(int n) {
        return (term[][])this.levels.elementAt(n);
    }

    public term currentTerm() {
        return this.level(this.currLevel)[this.currKind][this.main];
    }

    public void reset() {
        this.currLevel = 0;
    }

    public void advance() {
        if (++this.currLevel == this.levels.size()) {
            term[][] termArray = this.level(this.currLevel - 1);
            term[][] termArray2 = new term[2][this.rules.length];
            for (int i = 0; i < this.rules.length; ++i) {
                termArray2[pdtGrammar.terminal][i] = this.newLevel(termArray[terminal], this.rules[i][0]);
                termArray2[pdtGrammar.nonterminal][i] = this.newLevel(termArray[nonterminal], this.rules[i][0]);
            }
            this.levels.addElement(termArray2);
        }
    }

    public void back() {
        this.currLevel = Math.max(this.currLevel - 1, 0);
    }

    private term newLevel(term[] termArray, term term2) {
        symbol symbol2 = term2.topSymbol();
        if (symbol2 instanceof variable) {
            return termArray[((variable)symbol2).index()];
        }
        term term3 = new term(symbol2);
        for (int i = 0; i < symbol2.rank(); ++i) {
            term3.defineSubterm(i, this.newLevel(termArray, term2.subterm(i)));
        }
        return term3;
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        pdtGrammarParser pdtGrammarParser2 = new pdtGrammarParser(aSCII_CharStream);
        pdtGrammarParser2.pdtGrammar();
        this.rules = pdtGrammarParser2.rules;
        this.main = pdtGrammarParser2.startIndex;
        Vector vector = pdtGrammarParser2.nonterminals;
        term[][] termArray = new term[2][this.rules.length];
        for (int i = 0; i < this.rules.length; ++i) {
            termArray[pdtGrammar.terminal][i] = this.rules[i][1];
            termArray[pdtGrammar.nonterminal][i] = new term(new symbol((String)vector.elementAt(i), 0));
        }
        this.levels.addElement(termArray);
    }
}

