/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.edge;
import gui.errorDisplay;
import gui.fileChooser;
import gui.invisibleNode;
import gui.node;
import gui.nodeTypes.worksheetNode;
import gui.worksheet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.TokenMgrError;
import parsers.configParser;
import parsers.configParserTokenManager;
import parsers.objectParser;
import util.includer;
import util.list;

public class componentGraph
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 3046505008622990455L;
    private list nodes = new list();
    private list edges = new list();
    private int defaultWidth = 500;
    private int defaultHeight = 500;
    private Dimension preferredSize = new Dimension(this.defaultWidth, this.defaultHeight);
    private invisibleNode invisible = new invisibleNode();
    private edge newEdge = null;
    private int activeCount = 0;
    private JTextField progressField = null;

    public componentGraph() {
        this.setPreferredSize(this.preferredSize);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setLayout(null);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.add(this.invisible);
    }

    public synchronized boolean confirm() {
        list l = this.nodes;
        while (true) {
            if (l.isEmpty()) {
                return true;
            }
            if (((worksheetNode)l.head()).isUnsaved()) break;
            l = l.tail();
        }
        int choice = JOptionPane.showConfirmDialog(null, "Unsaved file(s). Proceed anyway?", "Unsaved file(s)!", 0, 3);
        return choice == 0;
    }

    public synchronized void setProgressField(JTextField t) {
        this.progressField = t;
        this.updateProgress();
    }

    public synchronized void addToActiveCount(int c) {
        this.activeCount += c;
        if (this.progressField != null && (this.activeCount == 0 || this.activeCount == c)) {
            this.updateProgress();
        }
    }

    private synchronized void updateProgress() {
        if (this.activeCount == 0) {
            this.progressField.setBackground(null);
            this.progressField.setText("ready");
        } else if (this.activeCount > 0) {
            this.progressField.setBackground(Color.orange);
            this.progressField.setText("busy");
        } else {
            throw new InternalError("Negative number of busy components");
        }
        this.progressField.setSize(this.progressField.getPreferredSize());
    }

    public void addNode(worksheetNode n, Point position) {
        this.nodes.append(n);
        super.add(n);
        n.setPosition(position);
        this.addComponentListener(n);
        this.invalidate();
        this.repaint();
    }

    public void deleteNode(worksheetNode n) {
        list l = this.edges;
        while (!l.isEmpty()) {
            edge e = (edge)l.head();
            if (n == e.source || n == e.target) {
                this.deleteEdge(e);
                continue;
            }
            l = l.tail();
        }
        l = this.nodes;
        while (n != l.head()) {
            l = l.tail();
        }
        l.removeFirst();
        super.remove(n);
        this.invalidate();
        this.repaint();
    }

    public void clear() {
        if (this.confirm()) {
            this.deleteAllNodes();
        }
    }

    private void deleteAllNodes() {
        while (!this.nodes.isEmpty()) {
            worksheetNode n = (worksheetNode)this.nodes.head();
            n.delete(true);
        }
    }

    public worksheetNode getNodeAt(int x, int y) {
        list l = this.nodes;
        while (!l.isEmpty()) {
            worksheetNode n = (worksheetNode)l.head();
            if (n.contains(x - n.getLocation().x, y - n.getLocation().y)) {
                return n;
            }
            l = l.tail();
        }
        return null;
    }

    public worksheetNode newNode(Point pos, String file) {
        worksheetNode n = null;
        if (file != null && (n = this.parseNode(file)) != null) {
            this.addNode(n, pos);
        }
        return n;
    }

    public void newNode(Point pos) {
        this.newNode(pos, fileChooser.selectFile("Load TREEBAG component", 0));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private worksheetNode parseNode(String fileName) {
        try {
            block22: {
                this.addToActiveCount(1);
                parsed = null;
                stream = null;
                ok = false;
                try {
                    try {
                        stream = new includer(new File(fileName));
                        parser = new objectParser(new ASCII_CharStream(stream, 1, 1));
                        parsed = parser.parse();
                        ok = true;
                    }
                    catch (ParseException e) {
                        errorDisplay.show("Parsing of `" + fileName + "' failed:\n" + e.getMessage());
                    }
                    catch (TokenMgrError e) {
                        errorDisplay.show("Parsing of `" + fileName + "' failed:\n" + e.getMessage());
                    }
                    catch (includer.IncludeFileNotFoundException e) {
                        errorDisplay.show("Parsing of `" + fileName + "' failed:\n" + e.getMessage());
                    }
                }
                catch (Throwable var7_9) {
                    var6_11 = null;
                    if (stream == null) throw var7_9;
                    try {
                        stream.close();
                        throw var7_9;
                    }
                    catch (IOException var8_13) {
                        // empty catch block
                    }
                    throw var7_9;
                }
                {
                    var6_12 = null;
                    if (stream == null) break block22;
                }
                ** try [egrp 3[TRYBLOCK] [5 : 190->197)] { 
lbl35:
                // 1 sources

                stream.close();
                break block22;
lbl37:
                // 1 sources

                catch (IOException var8_14) {
                    // empty catch block
                }
            }
            if (!ok) {
                var13_20 = null;
                var11_23 = null;
                this.addToActiveCount(-1);
                return var13_20;
            }
            if (parsed.getName() == null) {
                name = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1);
                parsed.setName("file " + name);
            }
            cl = parsed.getClass();
            args = new Object[]{parsed, fileName};
            result = null;
            while (true) {
                try {
                    className = String.valueOf(cl.getName()) + "Node";
                    className = className.substring(className.lastIndexOf(46) + 1);
                    nodeClass = Class.forName("gui.nodeTypes." + className);
                    constr = nodeClass.getConstructors()[0];
                    result = (worksheetNode)constr.newInstance(args);
                }
                catch (ClassNotFoundException e) {
                    cl = cl.getSuperclass();
                    if (cl != null) continue;
                    result = new worksheetNode(parsed, fileName);
                }
                catch (IllegalAccessException e) {
                    throw new InternalError(e.toString());
                }
                catch (InvocationTargetException e) {
                    throw new InternalError(e.getTargetException().toString());
                }
                catch (InstantiationException e) {
                    throw new InternalError(e.toString());
                }
                break;
            }
            try {
                result.initialize();
            }
            catch (ParseException e) {
                errorDisplay.show(e.getMessage());
                var13_21 = null;
                var11_24 = null;
                this.addToActiveCount(-1);
                return var13_21;
            }
            result.start();
            var13_22 = result;
        }
        catch (Throwable var12_29) {
            var11_26 = null;
            this.addToActiveCount(-1);
            throw var12_29;
        }
        var11_25 = null;
        this.addToActiveCount(-1);
        return var13_22;
    }

    public void deleteEdge(edge e) {
        e.target.inputEdgeDeleted(e);
        list l = this.edges;
        while (e != l.head()) {
            l = l.tail();
        }
        l.removeFirst();
        e.source.deleteMotionObserver(e);
        e.target.deleteMotionObserver(e);
        ((worksheetNode)e.source).deleteObservingEdge(e);
        super.remove(e);
        this.invalidate();
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        Component c = this.getComponentAt(e.getPoint());
        if (c != null && c instanceof edge) {
            node source = ((edge)c).source;
            this.deleteEdge((edge)c);
            this.createDanglingEdge(source, e.getPoint());
        } else if (e.getClickCount() > 1) {
            this.newNode(e.getPoint());
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void createDanglingEdge(node source, Point target) {
        this.newEdge = new edge(source, this.invisible);
        this.add(this.newEdge);
        this.invisible.activateAtWith(target.x, target.y, this.newEdge);
    }

    public void setTarget(Point p) {
        worksheetNode source = (worksheetNode)this.newEdge.source;
        this.remove(this.newEdge);
        this.newEdge = null;
        this.invalidate();
        worksheetNode target = this.getNodeAt(p.x, p.y);
        this.addEdge(source, target);
        this.repaint();
    }

    private void addEdge(worksheetNode source, worksheetNode target) {
        if (target != null && target.acceptsSource(source)) {
            edge e = new edge(source, target);
            source.addObservingEdge(e);
            this.edges.append(e);
            super.add(e);
            this.invalidate();
            this.repaint();
            target.inputEdgeEstablished(e);
        }
    }

    public boolean existsPath(worksheetNode from, worksheetNode to) {
        if (from == to) {
            return true;
        }
        list frontier = new list();
        frontier.append(from);
        list unused = (list)this.edges.clone();
        while (!frontier.isEmpty()) {
            node n = (node)frontier.head();
            frontier.removeFirst();
            list l = unused;
            while (!l.isEmpty()) {
                edge e = (edge)l.head();
                if (e.source == n) {
                    if (e.target == to) {
                        return true;
                    }
                    l.removeFirst();
                    frontier.append(e.target);
                    continue;
                }
                l = l.tail();
            }
        }
        return false;
    }

    public void saveConfig() {
        String fileName = fileChooser.selectFile("Save worksheet configuration", 1);
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    File old = new File(String.valueOf(fileName) + ".bak");
                    if (old.exists()) {
                        old.delete();
                    }
                    if (!file.renameTo(old)) {
                        errorDisplay.show("Coudn't rename old file " + fileName + " to " + fileName + ".bak;\noperation cancelled");
                        return;
                    }
                }
                this.saveConfig(new RandomAccessFile(file, "rw"));
            }
            catch (IOException e) {
                errorDisplay.show("Could not write to file " + fileName + ":\n" + e);
            }
        }
    }

    private void saveConfig(RandomAccessFile out) throws IOException {
        out.writeBytes("Worksheet configuration\n");
        if (this.getSize().width != this.defaultWidth || this.getSize().height != this.defaultHeight) {
            out.writeBytes("\nWorksheet size is (" + this.getSize().width + ", " + this.getSize().height + ")\n");
        }
        list l = this.nodes;
        int i = 0;
        while (!l.isEmpty()) {
            worksheetNode n = (worksheetNode)l.head();
            int ups = 0;
            String common = fileChooser.getDirectory();
            while (!n.fileName.startsWith(common)) {
                common = common.substring(0, common.lastIndexOf(File.separator, common.length() - 2) + 1);
                ++ups;
            }
            String f = n.fileName.substring(common.length());
            out.writeBytes("\nComponent " + i + " is ");
            if (ups > 0 && common.length() > 0) {
                out.writeBytes(String.valueOf(ups) + " up ");
            }
            out.writeBytes("\"" + f + "\" at (" + n.position.x + "," + n.position.y + ") ");
            int j = 0;
            while (j < n.openWindows()) {
                out.writeByte(42);
                ++j;
            }
            l = l.tail();
            ++i;
        }
        l = this.edges;
        if (!l.isEmpty()) {
            out.writeBytes("\n\nEdges are\n");
            do {
                edge e = (edge)l.head();
                out.writeBytes("\n  " + String.valueOf(this.nodeNumber(e.source)) + " -> " + String.valueOf(this.nodeNumber(e.target)));
            } while (!(l = l.tail()).isEmpty());
        }
        out.writeBytes("\n\nend\n");
        out.close();
    }

    private int nodeNumber(node n) {
        int i = 0;
        list l = this.nodes;
        while (true) {
            if (l.isEmpty()) {
                throw new InternalError();
            }
            if (l.head() == n) {
                return i;
            }
            ++i;
            l = l.tail();
        }
    }

    public void addConfig(boolean isLoad, worksheet ws) {
        if (isLoad && !this.confirm()) {
            return;
        }
        String fileName = isLoad ? fileChooser.selectFile("Load worksheet configuration", 0) : fileChooser.selectFile("Add worksheet configuration", 0);
        if (fileName != null) {
            this.addConfig(isLoad, fileName, ws);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addConfig(boolean isLoad, String fileName, worksheet ws) {
        block11: {
            fileChooser.setDirectory(new File(fileName).getParent());
            parser = null;
            ok = false;
            stream = null;
            try {
                try {
                    stream = new includer(new File(fileName));
                    parser = new configParser(new configParserTokenManager(new ASCII_CharStream(stream, 1, 1)));
                    parser.parse(fileName);
                    ok = true;
                }
                catch (includer.IncludeFileNotFoundException e) {
                    errorDisplay.show("Parsing of file " + fileName + " failed:\n" + e.getMessage());
                }
                catch (ParseException e) {
                    errorDisplay.show("Parsing of `" + fileName + "' failed:\n" + e.getMessage());
                }
                catch (TokenMgrError e) {
                    errorDisplay.show("Parsing of `" + fileName + "' failed:\n" + e.getMessage());
                }
            }
            catch (Throwable var9_11) {
                var8_12 = null;
                if (stream == null) throw var9_11;
                try {
                    stream.close();
                    throw var9_11;
                }
                catch (IOException var10_14) {
                    // empty catch block
                }
                throw var9_11;
            }
            {
                var8_13 = null;
                if (stream == null) break block11;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 211->219)] { 
lbl34:
            // 1 sources

            stream.close();
            break block11;
lbl36:
            // 1 sources

            catch (IOException var10_15) {
                // empty catch block
            }
        }
        if (ok == false) return;
        if (isLoad) {
            this.deleteAllNodes();
        }
        this.preferredSize = isLoad != false && parser.xDim >= 0 ? new Dimension(parser.xDim, parser.yDim) : this.getSize();
        this.setPreferredSize(this.preferredSize);
        ws.setReadMe(parser.readMe);
        ws.pack();
        createdNodes = new Vector<E>();
        this.insertNodes(parser.nodes, createdNodes);
        this.insertEdges(parser.edges, createdNodes);
        this.executeCommands(parser.nodes, createdNodes);
        this.openNodes(parser.nodes, createdNodes);
    }

    private void insertNodes(Vector infoVector, Vector created) {
        int i = 0;
        while (i < infoVector.size()) {
            configParser.nodeInfo info = (configParser.nodeInfo)infoVector.elementAt(i);
            worksheetNode n = this.parseNode(info.fileName);
            if (n != null) {
                this.addNode(n, info.position);
            }
            created.addElement(n);
            ++i;
        }
    }

    private void insertEdges(Vector edges, Vector nodes) {
        int i = 0;
        while (i < edges.size()) {
            configParser.edgeInfo info = (configParser.edgeInfo)edges.elementAt(i);
            worksheetNode source = (worksheetNode)nodes.elementAt(info.source);
            worksheetNode target = (worksheetNode)nodes.elementAt(info.target);
            if (source != null && target != null) {
                this.addEdge(source, target);
            }
            ++i;
        }
    }

    private void executeCommands(Vector infoVector, Vector nodes) {
        int i = 0;
        while (i < infoVector.size()) {
            worksheetNode node2 = (worksheetNode)nodes.elementAt(i);
            if (node2 != null) {
                configParser.nodeInfo info = (configParser.nodeInfo)infoVector.elementAt(i);
                int j = 0;
                while (j < info.execute.size()) {
                    int multiplicity = (Integer)info.execute.elementAt(j);
                    String command = (String)info.execute.elementAt(j + 1);
                    while (multiplicity-- > 0) {
                        node2.transferCommand(command, worksheetNode.USER_COMMAND);
                    }
                    j += 2;
                }
            }
            ++i;
        }
    }

    private void openNodes(Vector infoVector, Vector nodes) {
        int i = 0;
        while (i < infoVector.size()) {
            worksheetNode node2 = (worksheetNode)nodes.elementAt(i);
            if (node2 != null) {
                configParser.nodeInfo info = (configParser.nodeInfo)infoVector.elementAt(i);
                int j = 0;
                while (j < info.openWindows) {
                    node2.open();
                    ++j;
                }
            }
            ++i;
        }
    }
}

