/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.node;
import gui.nodeTypes.worksheetNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;

public class edge
extends Component
implements Observer {
    private static final long serialVersionUID = -3659412087089404459L;
    public static Object MOVEMENT = new Object();
    private static int arrowAngle = 40;
    private static int arrowLength = 15;
    private static int arrowWidth;
    private Color colour;
    public node source;
    public node target;
    private Point from;
    private Point to;
    private Rectangle bounds;

    public edge(node node2, node node3) {
        arrowWidth = (int)((double)arrowLength * Math.sin(arrowAngle / 2));
        this.colour = Color.black;
        this.bounds = new Rectangle();
        this.source = node2;
        this.target = node3;
        node2.observeMotionBy(this);
        node3.observeMotionBy(this);
        this.setBounds();
    }

    public void setColour(Color color) {
        this.colour = color;
    }

    private void setBounds() {
        this.from = this.source.getBorderPoint(this.target.position);
        this.to = this.target.getBorderPoint(this.source.position);
        if (this.from != null && this.to != null) {
            this.bounds.x = Math.min(this.from.x, this.to.x) - arrowWidth;
            this.bounds.y = Math.min(this.from.y, this.to.y) - arrowWidth;
            this.bounds.width = Math.abs(this.from.x - this.to.x) + 1 + 2 * arrowWidth;
            this.bounds.height = Math.abs(this.from.y - this.to.y) + 1 + 2 * arrowWidth;
        } else {
            this.bounds.width = 0;
            this.bounds.height = 0;
        }
        this.setBounds(this.bounds);
    }

    public boolean contains(int n, int n2) {
        double d;
        double d2;
        if (this.from == null || this.to == null) {
            return false;
        }
        if (n < 0 || n > this.bounds.width || n2 < 0 || n2 > this.bounds.height) {
            return false;
        }
        double d3 = this.to.y - this.from.y;
        double d4 = this.from.x - this.to.x;
        return Math.abs(d2 = (d3 /= (d = Math.sqrt(d3 * d3 + d4 * d4))) * (double)(n += this.bounds.x) + (d4 /= d) * (double)(n2 += this.bounds.y) - (d3 * (double)this.from.x + d4 * (double)this.from.y)) <= 5.0;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(this.colour);
        if (this.from == null || this.to == null) {
            return;
        }
        int n = this.from.x - this.bounds.x;
        int n2 = this.from.y - this.bounds.y;
        int n3 = this.to.x - this.bounds.x;
        int n4 = this.to.y - this.bounds.y;
        int n5 = (int)(90.0 + 57.29577951308232 * Math.atan2(n3 - n, n4 - n2));
        graphics.drawLine(n, n2, n3, n4);
        graphics.fillArc(n3 - arrowLength, n4 - arrowLength, 2 * arrowLength, 2 * arrowLength, n5 - arrowAngle / 2, arrowAngle);
    }

    public void update(Observable observable2, Object object) {
        if (object == MOVEMENT) {
            this.setBounds();
            this.invalidate();
            this.repaint();
        } else {
            ((worksheetNode)this.target).transferCommand(object, worksheetNode.VALUE);
        }
    }
}

