/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;

public abstract class scrollCanvas
extends Canvas
implements AdjustmentListener,
ComponentListener {
    private boolean scalingEnabled = true;
    private Point lastPressed = null;
    private Point firstPressed = null;
    private JScrollBar hScroll = null;
    private JScrollBar vScroll = null;
    protected double absL;
    protected double absR;
    protected double absT;
    protected double absB;
    protected double viewL;
    protected double viewR;
    protected double viewT;
    protected double viewB;
    private boolean scrollingEnabled = true;
    private static final int smax = 10000;

    public scrollCanvas() {
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.hScroll = new JScrollBar(0);
        this.vScroll = new JScrollBar(1);
        this.hScroll.addAdjustmentListener(this);
        this.vScroll.addAdjustmentListener(this);
        this.addComponentListener(this);
    }

    public JScrollBar getHScrollBar() {
        return this.hScroll;
    }

    public JScrollBar getVScrollBar() {
        return this.vScroll;
    }

    public void setAbsSilently(double d, double d2, double d3, double d4) {
        this.absL = d;
        this.absR = d2;
        this.absT = d3;
        this.absB = d4;
    }

    public void setViewSilently(double d, double d2, double d3, double d4) {
        this.viewL = d;
        this.viewR = d2;
        this.viewT = d3;
        this.viewB = d4;
    }

    public void setAbs(double d, double d2, double d3, double d4) {
        this.setAbsSilently(d, d2, d3, d4);
        this.adjustScrollBars();
    }

    public void setView(double d, double d2, double d3, double d4) {
        this.setViewSilently(d, d2, d3, d4);
        this.adjustScrollBars();
    }

    public void enableScrolling(boolean bl) {
        this.scrollingEnabled = bl;
        this.adjustScrollBars();
    }

    protected abstract void resizeView();

    private double absL() {
        return this.absL <= this.viewL ? this.absL : this.viewL;
    }

    private double absR() {
        return this.absR >= this.viewR ? this.absR : this.viewR;
    }

    private double absT() {
        return this.absT <= this.viewT ? this.absT : this.viewT;
    }

    private double absB() {
        return this.absB >= this.viewB ? this.absB : this.viewB;
    }

    protected void adjustScrollBars() {
        this.hScroll.removeAdjustmentListener(this);
        this.vScroll.removeAdjustmentListener(this);
        if (this.scrollingEnabled) {
            double d = Math.abs(this.absL() - this.absR());
            double d2 = Math.abs(this.absT() - this.absB());
            double d3 = Math.abs(this.viewL - this.absL());
            double d4 = Math.abs(this.viewT - this.absT());
            double d5 = Math.min(d - d3, Math.abs(this.viewL - this.viewR));
            double d6 = Math.min(d2 - d4, Math.abs(this.viewT - this.viewB));
            this.hScroll.setValues((int)(d3 * (10000.0 / d)), (int)(d5 * (10000.0 / d)), 0, 10000);
            this.vScroll.setValues((int)(d4 * (10000.0 / d2)), (int)(d6 * (10000.0 / d2)), 0, 10000);
            this.hScroll.setBlockIncrement(this.hScroll.getVisibleAmount() * 19 / 20);
            this.vScroll.setBlockIncrement(this.vScroll.getVisibleAmount() * 19 / 20);
        } else {
            this.hScroll.setValues(0, 100, 0, 100);
            this.vScroll.setValues(0, 100, 0, 100);
        }
        this.hScroll.addAdjustmentListener(this);
        this.vScroll.addAdjustmentListener(this);
    }

    public boolean between(double d, double d2, double d3) {
        return d2 <= d && d <= d3 || d3 <= d && d <= d2;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.hScroll) {
            this.hValueChanged(adjustmentEvent.getValue());
        } else if (adjustmentEvent.getAdjustable() == this.vScroll) {
            this.vValueChanged(adjustmentEvent.getValue());
        }
        this.invalidate();
        this.repaint();
        this.adjustScrollBars();
    }

    protected void hValueChanged(int n) {
        double d = this.viewR - this.viewL;
        this.viewL = this.absL() + (this.absR() - this.absL()) * ((double)n / 10000.0);
        this.viewR = this.viewL + d;
    }

    protected void vValueChanged(int n) {
        double d = this.viewB - this.viewT;
        this.viewT = this.absT() + (this.absB() - this.absT()) * ((double)n / 10000.0);
        this.viewB = this.viewT + d;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.resizeView();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void enableScaling(boolean bl) {
        this.scalingEnabled = bl;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 501) {
            if (!mouseEvent.isMetaDown() && !mouseEvent.isAltDown()) {
                this.lastPressed = mouseEvent.getPoint();
            } else if (this.scalingEnabled) {
                this.firstPressed = this.lastPressed = mouseEvent.getPoint();
                this.drawSquare(this.getGraphics());
            }
        } else if (mouseEvent.getID() == 502 && this.lastPressed != null) {
            if (!mouseEvent.isMetaDown() && !mouseEvent.isAltDown()) {
                this.lastPressed = null;
            } else if (this.scalingEnabled && this.firstPressed != null) {
                this.drawSquare(this.getGraphics());
                int n = Math.min(this.firstPressed.x, this.lastPressed.x);
                int n2 = Math.max(this.firstPressed.x, this.lastPressed.x);
                int n3 = Math.min(this.firstPressed.y, this.lastPressed.y);
                int n4 = Math.max(this.firstPressed.y, this.lastPressed.y);
                Dimension dimension = this.getSize();
                this.lastPressed = null;
                this.firstPressed = null;
                this.scalingRequest(this.viewL + (double)n / (double)dimension.width * (this.viewR - this.viewL), this.viewL + (double)n2 / (double)dimension.width * (this.viewR - this.viewL), this.viewT + (double)n3 / (double)dimension.height * (this.viewB - this.viewT), this.viewT + (double)n4 / (double)dimension.height * (this.viewB - this.viewT));
            }
        }
    }

    protected void scalingRequest(double d, double d2, double d3, double d4) {
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.getID() == 506 && this.lastPressed != null) {
            if (!mouseEvent.isMetaDown() && !mouseEvent.isAltDown()) {
                Point point = mouseEvent.getPoint();
                double d = (double)(point.x - this.lastPressed.x) * (this.viewR - this.viewL) / (double)this.getSize().width;
                double d2 = (double)(point.y - this.lastPressed.y) * (this.viewB - this.viewT) / (double)this.getSize().height;
                this.lastPressed = point;
                this.setView(this.viewL - d, this.viewR - d, this.viewT - d2, this.viewB - d2);
                this.adjustScrollBars();
                this.repaint();
            } else if (this.scalingEnabled && this.firstPressed != null) {
                Graphics graphics = this.getGraphics();
                this.drawSquare(graphics);
                this.lastPressed = mouseEvent.getPoint();
                this.drawSquare(graphics);
            }
        }
    }

    private void drawSquare(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        graphics.drawRect(Math.min(this.firstPressed.x, this.lastPressed.x), Math.min(this.firstPressed.y, this.lastPressed.y), Math.abs(this.lastPressed.x - this.firstPressed.x), Math.abs(this.lastPressed.y - this.firstPressed.y));
    }
}

