/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class textCanvas
extends Component {
    private static final long serialVersionUID = 281753164828405722L;
    private String[] textLines = new String[0];

    public textCanvas() {
        this.setBounds(0, 0, 0, 0);
        this.setFont(new Font(null));
    }

    public void addTextLine(String string) {
        String[] stringArray = this.textLines;
        this.textLines = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, this.textLines, 0, stringArray.length);
        this.textLines[stringArray.length] = string;
        this.updateBounds();
        this.invalidate();
    }

    public void removeTextLines() {
        this.textLines = new String[0];
        this.updateBounds();
        this.invalidate();
    }

    private void updateBounds() {
        int n = 0;
        int n2 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this.textLines.length; ++i) {
            n = Math.max(n, fontMetrics.stringWidth(this.textLines[i]));
            n2 = n2 + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        }
        Rectangle rectangle = this.getBounds();
        this.setBounds(rectangle.x + (rectangle.width - n) / 2, rectangle.y, n, n2);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 0;
        for (int i = 0; i < this.textLines.length; ++i) {
            String string = this.textLines[i];
            graphics.drawString(string, (this.getBounds().width - fontMetrics.stringWidth(string)) / 2, n += fontMetrics.getMaxAscent());
            n += fontMetrics.getMaxDescent();
        }
    }
}

