/*
 * Decompiled with CFR 0.152.
 */
package parsers;

import generators.SuperTable;
import generators.SyncedRule;
import generators.rexp;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.BSTGrammarParserConstants;
import parsers.BSTGrammarParserTokenManager;
import parsers.ParseException;
import parsers.Token;
import parsers.nameParser;
import parsers.syncTermParser;
import terms.finiteSignature;
import terms.fixedRankSignature;
import terms.symbol;
import terms.synchronizedSymbol;
import terms.term;

public class BSTGrammarParser
implements BSTGrammarParserConstants {
    public static int TYPE_PLAIN = 0;
    public static int TYPE_NORMAL = 1;
    public static int TYPE_EXTENDED = 2;
    public finiteSignature sig = new finiteSignature();
    public fixedRankSignature nonterminals = new fixedRankSignature(0);
    public fixedRankSignature syncSymbols = new fixedRankSignature(0);
    public int depth;
    public SuperTable tables;
    public term axiom;
    public Vector axiomSyncStrings;
    public boolean implicitRules = false;
    public int translationType = TYPE_NORMAL;
    public rexp regulation = null;
    protected ASCII_CharStream inputStream;
    private syncTermParser terms;
    private nameParser names;
    private Vector tableNames = new Vector();
    private Hashtable topTableNames = new Hashtable();
    private int topTableCount = 0;
    public BSTGrammarParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[18];
    private final int[] jj_la1_0 = new int[]{4096, 57344, 131072, 57344, 4096, 131072, 62464, 62464, 131072, 512, 256, 131072, 131072, 256, 131072, 33816704, 0x1800000, 33816704};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public BSTGrammarParser(ASCII_CharStream aSCII_CharStream) {
        this(new BSTGrammarParserTokenManager(aSCII_CharStream));
        this.names = new nameParser(aSCII_CharStream);
        this.inputStream = aSCII_CharStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector checkRhs(term term2, Vector vector) throws ParseException {
        symbol symbol2 = term2.topSymbol();
        if (this.nonterminals.contains(symbol2)) {
            if (!(symbol2 instanceof synchronizedSymbol)) throw new ParseException("Nonterminal " + symbol2 + " requires synchronization symbols");
            vector.addElement(((synchronizedSymbol)symbol2).getSync());
            return vector;
        } else {
            if (!this.sig.contains(symbol2)) throw new ParseException("Symbol " + symbol2 + " neither an output symbol nor a nonterminal");
            for (int i = 0; i < symbol2.rank(); ++i) {
                this.checkRhs(term2.subterm(i), vector);
            }
        }
        return vector;
    }

    public final void BSTGrammar() throws ParseException {
        boolean bl = true;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 12: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 12: {
                                this.jj_consume_token(12);
                                bl = false;
                                break;
                            }
                            default: {
                                this.jj_la1[0] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(10);
                        this.jj_consume_token(11);
                        this.implicitRules = bl;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 17: {
                                this.jj_consume_token(17);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 13: {
                                        this.jj_consume_token(13);
                                        this.translationType = TYPE_PLAIN;
                                        break;
                                    }
                                    case 14: {
                                        this.jj_consume_token(14);
                                        this.translationType = TYPE_NORMAL;
                                        break;
                                    }
                                    case 15: {
                                        this.jj_consume_token(15);
                                        this.translationType = TYPE_EXTENDED;
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[1] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                this.jj_consume_token(16);
                                break block0;
                            }
                        }
                        this.jj_la1[2] = this.jj_gen;
                        break block0;
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 13: {
                                this.jj_consume_token(13);
                                this.translationType = TYPE_PLAIN;
                                break;
                            }
                            case 14: {
                                this.jj_consume_token(14);
                                this.translationType = TYPE_NORMAL;
                                break;
                            }
                            case 15: {
                                this.jj_consume_token(15);
                                this.translationType = TYPE_EXTENDED;
                                break;
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(16);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 17: {
                                this.jj_consume_token(17);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 12: {
                                        this.jj_consume_token(12);
                                        bl = false;
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[4] = this.jj_gen;
                                    }
                                }
                                this.jj_consume_token(10);
                                this.jj_consume_token(11);
                                this.implicitRules = bl;
                                break block0;
                            }
                        }
                        this.jj_la1[5] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        this.jj_consume_token(18);
        this.nonterminals.parse(this.inputStream);
        this.jj_consume_token(17);
        this.sig.parse(this.inputStream);
        this.jj_consume_token(17);
        this.syncSymbols.parse(this.inputStream);
        this.jj_consume_token(17);
        this.depth = this.nat();
        this.terms = new syncTermParser(this.inputStream, this.depth, this.nonterminals, this.syncSymbols);
        this.tables = new SuperTable(this.depth > 0);
        this.jj_consume_token(17);
        this.table(this.tables, 0, "");
        this.jj_consume_token(17);
        this.axiom = this.terms.term();
        this.axiomSyncStrings = this.checkRhs(this.axiom, new Vector());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                if (!this.sig.disjointWith(this.nonterminals)) {
                    throw new ParseException("Restriction by regular expression only allowed if no nonterminals are output symbols.");
                }
                this.jj_consume_token(17);
                this.regulation = this.rexp();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        this.jj_consume_token(19);
    }

    public final void table(SuperTable superTable, int n, String string) throws ParseException {
        boolean bl = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                string = this.string();
                bl = true;
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        if (this.tableNames.contains(string)) {
            throw new ParseException("Table name " + string + " used twice");
        }
        this.tableNames.add(string);
        superTable.setName("TBL" + string);
        if (n == 1) {
            ++this.topTableCount;
            if (bl) {
                this.topTableNames.put(string, new Integer(this.topTableCount));
            }
        }
        this.jj_consume_token(20);
        if (n < this.depth) {
            this.tableList(superTable, n + 1, string, 1);
        } else {
            this.ruleList(superTable);
        }
        this.jj_consume_token(21);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                superTable.setWeight(this.rat());
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
    }

    public final void tableList(SuperTable superTable, int n, String string, int n2) throws ParseException {
        SuperTable superTable2 = new SuperTable(n < this.depth);
        superTable.addSubTable(superTable2);
        this.table(superTable2, n, string + "_" + n2);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                this.tableList(superTable, n, string, n2 + 1);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
    }

    public final void ruleList(SuperTable superTable) throws ParseException {
        this.rule(superTable);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(17);
            this.rule(superTable);
        }
    }

    public final void rule(SuperTable superTable) throws ParseException {
        symbol symbol2 = new symbol(this.names.name(), 0);
        if (!this.nonterminals.contains(symbol2)) {
            throw new ParseException(symbol2 + " not a nonterminal");
        }
        this.jj_consume_token(22);
        term term2 = this.terms.term();
        SyncedRule syncedRule = new SyncedRule(symbol2, term2);
        superTable.addRule(syncedRule);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                syncedRule.setWeight(this.rat());
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
    }

    public final rexp rexp() throws ParseException {
        rexp rexp2 = this.rexp1();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                rexp rexp3 = this.rexp();
                return rexp.union(rexp2, rexp3);
            }
        }
        this.jj_la1[14] = this.jj_gen;
        return rexp2;
    }

    public final rexp rexp1() throws ParseException {
        rexp rexp2 = this.rexp2();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 18: 
            case 25: {
                rexp rexp3 = this.rexp1();
                return rexp.conc(rexp2, rexp3);
            }
        }
        this.jj_la1[15] = this.jj_gen;
        return rexp2;
    }

    public final rexp rexp2() throws ParseException {
        rexp rexp2 = this.rexp3();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                return rexp.star(rexp2);
            }
            case 24: {
                this.jj_consume_token(24);
                return rexp.plus(rexp2);
            }
        }
        this.jj_la1[16] = this.jj_gen;
        return rexp2;
    }

    public final rexp rexp3() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                String string = this.string();
                Object v = this.topTableNames.get(string);
                if (v == null) {
                    throw new ParseException("undefined table `" + string + "' in regulating expression");
                }
                return rexp.num((Integer)v);
            }
            case 18: {
                this.jj_consume_token(18);
                rexp rexp2 = this.rexp();
                this.jj_consume_token(19);
                return rexp2;
            }
            case 25: {
                this.jj_consume_token(25);
                rexp rexp3 = this.rexp();
                this.jj_consume_token(26);
                return rexp.opt(rexp3);
            }
        }
        this.jj_la1[17] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String string() throws ParseException {
        Token token = this.jj_consume_token(7);
        return token.image.substring(1, token.image.length() - 1);
    }

    public final double rat() throws ParseException {
        Token token = this.jj_consume_token(6);
        try {
            return Double.parseDouble(token.image);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(token.image + " not a valid number");
        }
    }

    public final int nat() throws ParseException {
        double d = this.rat();
        if (d == Math.ceil(d) && d >= 0.0) {
            return (int)d;
        }
        throw new ParseException(d + " not a natural number");
    }

    public BSTGrammarParser(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new BSTGrammarParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public BSTGrammarParser(Reader reader) {
        this.jj_input_stream = new ASCII_CharStream(reader, 1, 1);
        this.token_source = new BSTGrammarParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public BSTGrammarParser(BSTGrammarParserTokenManager bSTGrammarParserTokenManager) {
        this.token_source = bSTGrammarParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(BSTGrammarParserTokenManager bSTGrammarParserTokenManager) {
        this.token_source = bSTGrammarParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 18; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[27];
        for (n2 = 0; n2 < 27; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 18; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((this.jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 27; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, BSTGrammarParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

