package algebras;

import terms.*;

/** The free term algebra, i.e., each symbol of rank <em>n</em> is
  * interpreted as an operation that takes <em>n</em> terms as arguments and yields
  * the term consisting of the given symbol as outer most one and the
  * <em>n</em> argument terms as subterms.
  * Since the semantics of symbols is fixed, the <code>parse</code>
  * method does nothing.
  * @see algebra
  * @see symbol
  */
public class termAlgebra extends algebra {

/** The operation associated with a symbol <em>s</em> of rank
  * <em>n</em> takes <em>n</em> terms <em>t1</em>, ..., <em>tn</em>
  * and returns <em>s</em>[<em>t1</em>, ..., <em>tn</em>].
  */
  protected Object apply(symbol op, Object[] args) {
    if (args.length != op.rank()) {
      return null;
    }
    term result = new term(op);
    for (int i = 0; i < args.length; i++) {
      if (args[i] instanceof term) {
        result.defineSubterm(i, (term)args[i]);
      }
      else {
        return null;
      }
    }
    return result;
  }
  
}
