package applications.collages;

import java.awt.geom.*;

public class collageOperation {

  private Object[] component;
  private int[] shuffle;
  
  public collageOperation(Object[] components) {
    component = components;
    shuffle = new int[components.length];
    for (int i = 0; i < components.length; i++) shuffle[i] = -1;
  }
  
  public collageOperation(Object[] components, int[] shuffle) {
    component = components;
    this.shuffle = shuffle;
  }
  
  public int arity() { return component.length; }
  
  public collage apply(Object[] args) {
    collage result = new collage();
    collage[] cargs = new collage[component.length];
    int j = 0;
    for (int i = 0; i < component.length; i++) {
      if (component[i] instanceof collage)  cargs[i] = (collage)((collage)component[i]).clone();
      else {
        cargs[i] = (collage)args[j++];
        cargs[i].transform((AffineTransform)component[i]);
      }
    }      
    boolean ready;
    do {
      ready = true;
      for (int i = 0; i < component.length; i++) {
        if (cargs[i] == null) continue;
        if (shuffle[i] < 1 || shuffle[i] >= cargs[i].numParts()) {
          result.unionWith(cargs[i]);
          cargs[i] = null;
        }
        else {
          result.transferFrom(cargs[i],shuffle[i]);
          ready = false;
        }
      }
    } while (!ready);
    return result;
  }
  
/*  public collage apply(Object[] args) {
    collage result = new collage();
    int j = 0;
    for (int i = 0; i < component.length; i++) {
      if (component[i] instanceof collage)  result.unionWith((collage)((collage)component[i]).clone());
      else {
        collage arg = (collage)args[j++];
        arg.transform((AffineTransform)component[i]);
        result.unionWith(arg);
      }
    }
    return result;
  }*/
}
