package applications.collages;

import java.awt.geom.*;
import java.util.*;
import java.io.*;
import parsers.*;
import terms.*;

public class gridAlgebra extends collageAlgebra {

  private int gridSize;
  private static float squareSize = 20;
  public static String squareName = "sq";
  private static GeneralPath sqPath =
    new GeneralPath(new Rectangle2D.Float(-squareSize,-squareSize,
                                  2*squareSize,2*squareSize));
  private static part square = new part(part.FILLED,sqPath);
  private static float dark = 100f/255f;
  private static float light = 200f/255f;
  private static collage greySquare = new collage();
  static {
    part p = new part(part.FILLED,sqPath);
    p.setColour(light,light,light);
    greySquare.add(p);
  }
  private static collage frame = new collage();
  static {
    part p = new part(part.OUTLINE,sqPath);
    p.setColour(dark,dark,dark);
    frame.add(p);
  }
  private static collage unknownConstant;
  static {
    unknownConstant = greySquare();
    unknownConstant.unionWith(frame());
    GeneralPath smallSqPath = new GeneralPath();
    smallSqPath.moveTo(-.8f*squareSize,-.8f*squareSize);
    smallSqPath.lineTo(.8f*squareSize,-.8f*squareSize);
    smallSqPath.lineTo(.8f*squareSize,.8f*squareSize);
    smallSqPath.lineTo(-.8f*squareSize,.8f*squareSize);
    smallSqPath.lineTo(-.8f*squareSize,-.8f*squareSize+squareSize/3);
    unknownConstant.add(new part(part.OUTLINE,smallSqPath));
    GeneralPath arrow = new GeneralPath();
    arrow.moveTo(-.8f*squareSize,-.8f*squareSize);
    arrow.lineTo(-.8f*squareSize+squareSize/8, -.8f*squareSize+squareSize/3);
    arrow.lineTo(-.8f*squareSize-squareSize/8, -.8f*squareSize+squareSize/3);
    arrow.closePath();
    unknownConstant.add(new part(part.FILLED,arrow));
  }
  private static collage sq = new collage();
  static {
      sq.add(square);
    }
  
  public gridAlgebra() { }
  
  public void setGridSize(int n) { gridSize = n; }
  
  protected Object extendBy(symbol s) {
    Object op = decodeOp(s.toString());
    int rank;
    if (op == null || op instanceof collage) rank = 0;
    else rank = ((collageOperation)op).arity();
    if (op == null || rank != s.rank()) {
      if (s.rank() == 1) {
        AffineTransform[] id = new AffineTransform[1];
        id[0] = new AffineTransform();
        return new collageOperation(id);
      }
      else if (s.rank() == 0) { return unknownConstant; }
    }
    if (rank != s.rank()) return null;
    else return op;
  }
  
  public Object decodeOp(String name) {
    if (squareName.equals(name)) return sq;
    // Create string buffer and insert -'s where necessary.
    // This is needed because StringTokenizer does not correctly
    // tokenize, e.g., ab3cd as two words and one number.
    StringBuffer buf = new StringBuffer(name);
    boolean digit = false;
    for (int i = name.length()-1; i >= 0; i--) {
      if (name.charAt(i) >= '0' && name.charAt(i) <= '9') digit = true;
      else if (name.charAt(i) == '-') digit = false;
      else if (digit) {
        buf.insert(i + 1, '-');
        digit = false;
      }
    }
    // OK, done with stupid part. Now for the actual work...
    StreamTokenizer tokens
      = new StreamTokenizer(new StringReader(buf.toString()));
    tokens.resetSyntax();
    tokens.parseNumbers();
    tokens.ordinaryChar('.');
    tokens.ordinaryChar('-');
    tokens.wordChars('a','d');
    tokens.lowerCaseMode(true);
    tokens.whitespaceChars('-','-');
    Vector result = new Vector();
    int sqIndex = 0;
    try{
      while (tokens.nextToken() != StreamTokenizer.TT_EOF) {
        AffineTransform aff = null;
        if (tokens.ttype == StreamTokenizer.TT_NUMBER) {
          sqIndex = (int)tokens.nval;
          if (tokens.nextToken() == StreamTokenizer.TT_WORD)
            aff = transformation(sqIndex, tokens.sval);
        }
        if (aff == null || sqIndex >= gridSize * gridSize) return null;
        else result.addElement(aff);
      }
    } catch (IOException e) { throw new InternalError("something wrong in gridAlgebra.java"); }
    AffineTransform[] aff = new AffineTransform[result.size()];
    result.copyInto(aff);
    return new collageOperation(aff);
  }

  
  private AffineTransform transformation(int sqNumber, String t) {
    double rot;
    int mirror;
    if ("ab".equals(t) || "abc".equals(t)) { rot = 0; mirror = 1; }
    else if ("bc".equals(t) || "bcd".equals(t)) { rot = Math.PI/2; mirror = 1; }
    else if ("cd".equals(t) || "cda".equals(t)) { rot = Math.PI; mirror = 1; }
    else if ("da".equals(t) || "dab".equals(t)) { rot = Math.PI/2*3; mirror = 1; }
    else if ("ad".equals(t) || "adc".equals(t)) { rot = Math.PI/2*3; mirror = -1; }
    else if ("dc".equals(t) || "dcb".equals(t)) { rot = Math.PI; mirror = -1; }
    else if ("cb".equals(t) || "cba".equals(t)) { rot = Math.PI/2; mirror = -1; }
    else if ("ba".equals(t) || "bad".equals(t)) { rot = 0; mirror = -1; }
    else return null;
    int squarePosX = sqNumber % gridSize;
    int squarePosY = sqNumber / gridSize;
    double size = 2 * squareSize / gridSize;
    double transX = -squareSize + squarePosX * size;
    double transY = -squareSize + squarePosY * size;
    AffineTransform result = AffineTransform.getScaleInstance(mirror / (double)gridSize, 1 / (double)gridSize);
    result.preConcatenate(AffineTransform.getRotateInstance(rot));
    result.preConcatenate(AffineTransform.getTranslateInstance(transX + size/2, transY + size/2));
    return result;
  }
  
  public static collage greySquare() {
    return (collage)greySquare.clone();
  }
  
  public static collage frame() {
    return (collage)frame.clone();
  }

/** Initialize a <code>gridAlgebra</code> by reading its definition from a stream.
  * @see gridAlgebraParser
  * @exception ParseException if an error occurs
  */
  public void parse(ASCII_CharStream stream) throws ParseException {
    gridAlgebraParser parser = new gridAlgebraParser(stream);
    parser.gridAlgebra(this);
  }

  
}
