package applications.geoWorld;

import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;
import applications.collages.*;
import terms.*;
import algebras.*;
import gui.*;
import util.*;

public class geoWorldAlgebra extends algebra implements reactive {

/** The implementation of commands to increase/decrease font size */

  private static String larger = "larger font";
  private static String smaller = "smaller font";
  private static String reset = "reset font";
  private double fontScale = 1;
  
  public list commands() {
    list cmds = new list();
    String[] c = new String[2];
    c[0] = smaller;
    c[1] = larger;
    cmds.append(c);
    c = new String[1];
    c[0] = reset;
    cmds.append(c);
    return cmds;
  }
  
  public void execute(String command) {
    if (larger.equals(command)) fontScale = fontScale * 10/9;
    else if (smaller.equals(command)) fontScale = fontScale * .9;
    else fontScale = 1;
  }
  
  public boolean requestsExit(String command) { return false; }
  
/** End of command implementation; what remains is the algebra itself... */

  private static float epsilon = 1f/3f;
  private static float veryLight = .9f;
  private static float light = .85f;
  private static float dark = .4f;
  private static symbol sym_a = new symbol("a",0);
  private static collage const_a = new collage();
  {
    GeneralPath p = new GeneralPath();
    AffineTransform rot = AffineTransform.getRotateInstance(Math.PI/2.0);
    p.moveTo(-.5f,-.5f); p.lineTo(.5f,-.5f); p.lineTo(0,0); p.closePath();
    part q = new part(part.FILLED,p);
    part outl = new part(part.OUTLINE,p);
    q.setColour(light);
    collage c = new collage(); c.add(q); c.add(outl);
    const_a.unionWith((collage)c.clone());
    q.setColour((light + dark)/2.0f);
    c.transform(rot);
    const_a.unionWith((collage)c.clone());
    q.setColour(dark);
    c.transform(rot);
    const_a.unionWith((collage)c.clone());
    q.setColour((light + dark)/2.0f);
    c.transform(rot);
    const_a.unionWith((collage)c.clone());
  }

  private static symbol sym_b = new symbol("b",0);
  private static collage const_b = new collage();
  {
    GeneralPath p = new GeneralPath();
    AffineTransform rot = AffineTransform.getRotateInstance(Math.PI/4.0);
    p.moveTo(-(float)Math.tan(Math.PI/8.0)/2.0f,-.5f); p.lineTo((float)Math.tan(Math.PI/8.0)/2.0f,-.5f); p.lineTo(0,0); p.closePath();
    part q = new part(part.FILLED,p);
    part outl = new part(part.OUTLINE,p);
    q.setColour(light);
    collage c = new collage(); c.add(q); c.add(outl);
    const_b.unionWith((collage)c.clone());
    q.setColour(dark + 3.0f*(light - dark)/4.0f);
    c.transform(rot);
    const_b.unionWith((collage)c.clone());
    q.setColour(dark + (light - dark)/2.0f);
    c.transform(rot);
    const_b.unionWith((collage)c.clone());
    q.setColour(dark + (light - dark)/4.0f);
    c.transform(rot);
    const_b.unionWith((collage)c.clone());
    q.setColour(dark);
    c.transform(rot);
    const_b.unionWith((collage)c.clone());
    q.setColour(dark + (light - dark)/4.0f);
    c.transform(rot);
    const_b.unionWith((collage)c.clone());
    q.setColour(dark +(light - dark)/2.0f);
    c.transform(rot);
    const_b.unionWith((collage)c.clone());
    q.setColour(dark +  3.0f*(light - dark)/4.0f);
    c.transform(rot);
    const_b.unionWith((collage)c.clone());
  }
  
  private static symbol sym_h = new symbol("h",2);
  private static symbol sym_v = new symbol("v",2);
  private static symbol sym_c = new symbol("c",1);
  
  private collage h(collage a, collage b) {
    Rectangle2D.Double bnds_a = a.bounds();
    Rectangle2D.Double bnds_b = b.bounds();
    double w = bnds_a.width + bnds_b.width + epsilon;
    a.transform(AffineTransform.getTranslateInstance(-w/2.0-bnds_a.x,0));
    b.transform(AffineTransform.getTranslateInstance(w/2.0-(bnds_b.x+bnds_b.width),0));
    a.unionWith(b);
    return a;
  }
  
  private collage v(collage a, collage b) {
    Rectangle2D.Double bnds_a = a.bounds();
    Rectangle2D.Double bnds_b = b.bounds();
    double h = bnds_a.height + bnds_b.height + epsilon;
    a.transform(AffineTransform.getTranslateInstance(0,-h/2.0-bnds_a.y));
    b.transform(AffineTransform.getTranslateInstance(0,h/2.0-(bnds_b.y+bnds_b.height)));
    a.unionWith(b);
    return a;
  }
  
  private collage c(collage a) {
    collage result = new collage();
    Rectangle2D.Double bnds = a.bounds();
    bnds.x -= epsilon; bnds.y -= epsilon; bnds.width += 2*epsilon; bnds.height += 2*epsilon;
    GeneralPath p = new GeneralPath();
    p.moveTo((float)bnds.x,(float)bnds.y); p.lineTo(-(float)bnds.x,(float)bnds.y);
    p.lineTo(-(float)bnds.x,-(float)bnds.y); p.lineTo((float)bnds.x,-(float)bnds.y); p.closePath();
    part q = new part(part.FILLED,p);
    q.setColour(veryLight);
    result.add(q);
    p = new GeneralPath();
    AffineTransform rot = AffineTransform.getRotateInstance(Math.PI);
    p.moveTo((float)bnds.x,(float)bnds.y); p.lineTo(-(float)bnds.x,(float)bnds.y);
    p.lineTo(-(float)bnds.x+epsilon,(float)bnds.y-epsilon);
    p.lineTo((float)bnds.x-epsilon,(float)bnds.y-epsilon); p.closePath();
    q = new part(part.FILLED,p);
    part outl = new part(part.OUTLINE,p);
    q.setColour(light);
    collage c = new collage(); c.add(q); c.add(outl);
    result.unionWith((collage)c.clone());
    q.setColour(dark);
    c.transform(rot);
    result.unionWith((collage)c.clone());
    p = new GeneralPath();
    p.moveTo((float)bnds.x,(float)bnds.y); p.lineTo((float)bnds.x,-(float)bnds.y);
    p.lineTo((float)bnds.x-epsilon,-(float)bnds.y+epsilon);
    p.lineTo((float)bnds.x-epsilon,(float)bnds.y-epsilon); p.closePath();
    q = new part(part.FILLED,p);
    outl = new part(part.OUTLINE,p);
    q.setColour((dark + light)/2.0f);
    c = new collage(); c.add(q); c.add(outl);
    result.unionWith((collage)c.clone());
    c.transform(rot);
    result.unionWith((collage)c.clone());
    result.unionWith(a);
    return result;
  }
  
  private collage unknown(String n) {
    collage result = new collage();
    GeneralPath p = new GeneralPath();
    p.moveTo(-.5f,-.5f); p.lineTo(.5f,-.5f); p.lineTo(.5f,.5f); p.lineTo(-.5f,.5f); p.closePath();
    part q = new part(part.FILLED,p);
    q.setColour(light);
    result.add(q);
    result.add(new part(part.OUTLINE,p));
    Font f = new Font("Serif",Font.ITALIC,10);
    GlyphVector gv = f.createGlyphVector(new FontRenderContext(null,false,true),n);
// For some reason, the following yields the wrong vertical placement on Mac OS X.
//    Rectangle2D b = gv.getVisualBounds();
//    GeneralPath path = new GeneralPath(gv.getOutline((float)-b.getCenterX(),(float)-b.getCenterY()));
//    path.transform(AffineTransform.getScaleInstance(.09*fontScale,-.09*fontScale));
    GeneralPath path = new GeneralPath(gv.getOutline());
    path.transform(AffineTransform.getScaleInstance(.09*fontScale,-.09*fontScale));
    Rectangle2D b = path.getBounds2D();
    path.transform(AffineTransform.getTranslateInstance(-b.getCenterX(),-b.getCenterY()));
    result.add(new part(part.FILLED,path));
    return result;
  }
  
  protected Object apply(symbol s, Object[] args) {
    if (s.equals(sym_a)) return const_a.clone();
    else if (s.equals(sym_b)) return const_b.clone();
    else if (s.equals(sym_h)) return h((collage)args[0],(collage)args[1]);
    else if (s.equals(sym_v)) return v((collage)args[0],(collage)args[1]);
    else if (s.equals(sym_c)) return c((collage)args[0]);
    else if (s.rank()==0) return unknown(s.toString());
    return null;
  }

}
