package applications.lineDrawings;

import terms.*;
import parsers.*;

public class chainCodeAlgebra extends lineDrawingAlgebra {

  private static symbol east = new symbol("e", 0);
  private static symbol west = new symbol("w", 0);
  private static symbol south = new symbol("s", 0);
  private static symbol north = new symbol("n", 0);
  private static symbol left = new symbol("l", 0);
  private static symbol right = new symbol("r", 0);
  private static symbol up = new symbol("u", 0);
  private static symbol down = new symbol("d", 0);
  private static String hide = "hide";

  protected Object apply(symbol op, Object[] args) {
    if (east.equals(op) || right.equals(op)) return new lineDrawing(new line(0, 0, 1, 0));
    if (west.equals(op) || left.equals(op)) return new lineDrawing(new line(0, 0, -1, 0));
    if (south.equals(op) || down.equals(op)) return new lineDrawing(new line(0, 0, 0, -1));
    if (north.equals(op) || up.equals(op)) return new lineDrawing(new line(0, 0, 0, 1));
    if (hide.equals(op.toString())) {
      double endX = 0;
      double endY = 0;
      for (int i = 0; i < args.length; i++) {
        endX += ((lineDrawing)args[i]).getEndpointX();
        endY += ((lineDrawing)args[i]).getEndpointY();
      }
      lineDrawing result = new lineDrawing();
      result.setEndpoint(endX, endY);
      return result;
    }
    return super.apply(op, args);
  }
  
  public void parse(ASCII_CharStream stream) { }
  
}
