package displays;

import java.awt.*;
import algebras.*;
import parsers.*;
import gui.*;
import util.*;

/** Displays the values of terms w.r.t. an algebra.
  * A display subclass
  * is designed for a particular type of algebras (i.e., for a subclass of the class
  * <code>algebra</code>). It should work for all values such an algebra could possibly
  * yield, and even for <code>null</code> (which indicates an undefined
  * value and should result in a display that reflects this fact).
  * @see algebra
  */
public abstract class display extends parsable implements visible, reactive {

  /** Checks whether the algebra is an instance of an <code>algebra</code> subclass
  * this kind of display can deal with.
  * @return <code>true</code> if the given algebra is of the right kind and
  * <code>false</code> if this kind of algebra cannot be dealt with.
  */
  public boolean acceptable(algebra a) {
    return true;
  }
  
/** Displays an object. */
  public void display(Object obj) {
    Component comp = visualizer();
    if (comp != null) displayObject(obj);
  }
    
 /** This is the method that actually implements how an object is shown.
  * It is called by the method <code>display</code>.
  * A <code>null</code> argument indicates an undefined value and should
  * result in a display that reflects this fact in an appropriate way.
  */
  protected abstract void displayObject(Object obj) throws ExitException;
  
/** By default there are no commands, i.e., the empty list is returned. */
  public list commands() { return new list(); }

/** The default <code>execute</code> method does nothing (because the
  * default provides no commands at all).
  */
  public void execute(String command) { }

/** The default <code>requestsExit</code> method returns <code>false</code>.
  */
  public boolean requestsExit(String command) { return false; }
    
}


